PRO WIDGET_CENTER, ID, PARENT=PARENT

;+
; NAME:
;     WIDGET_CENTER
;
; PURPOSE:
;     Center a widget on the screen,
;     or over an existing widget.
;
; CATEGORY:
;     Widgets.
;
; CALLING SEQUENCE:
;     WIDGET_CENTER, ID
;
; INPUTS:
;     ID        ID of the widget to be centered.
;
; KEYWORD PARAMETERS:
;     PARENT    ID of an existing widget over which
;               the widget should be centered.
;
; OUTPUTS:
;     None.
;
; EXAMPLE:
;base = widget_base()
;label = widget_label(base, value='Hello world')
;widget_center, base
;widget_control, base, /realize
;
; MODIFICATION HISTORY:
; Written by:   Liam.Gumley@ssec.wisc.edu
; $Id: widget_center.pro,v 1.1 2000/02/15 15:41:55 srio Exp $
;-

;- Check arguments

if n_elements(id) eq 0 then $
  message, 'Argument ID is undefined'
if widget_info(id, /valid_id) eq 0 then $
  message, 'Argument ID is invalid'
if n_elements(parent) eq 0 then parent = 0L

;- Get widget size

geometry = widget_info(id, /geometry)
xsize = geometry.scr_xsize + (2 * geometry.margin)
ysize = geometry.scr_ysize + (2 * geometry.margin)

;- Get center position of parent or screen

if widget_info(parent, /valid_id) then begin
  parent_geometry = widget_info(parent, /geometry)
  parent_xsize = parent_geometry.scr_xsize + $
    (2 * parent_geometry.margin)
  parent_ysize = parent_geometry.scr_ysize + $
    (2 * parent_geometry.margin)
  xcenter = parent_geometry.xoffset + parent_xsize / 2
  ycenter = parent_geometry.yoffset + parent_ysize / 2
endif else begin
  device, get_screen_size=screen_size
  xcenter = screen_size[0] / 2
  ycenter = screen_size[1] / 2
endelse

;- Compute offsets

xoffset = xcenter - (xsize / 2)
yoffset = ycenter - (ysize / 2)

;- Center the widget

widget_control, id, xoffset=xoffset, yoffset=yoffset

END

