
;+
; NAME:
;	CW_PFIELD
;
; PURPOSE:
;	This compound widget is designed for being used internally
;	by XPeakFit.
;
;	CW_PFIELD is a compound widget that creates a number
;	of text widgets containing floating numbers and 
;	for each floating two buttons: one labeled with "G" and
;	the other with "F".
;	The "F" button makes the text selection sensitive or
;	insensitive.
;
; CATEGORY:
;	Compound widgets.
;
; CALLING SEQUENCE:
;	Widget = CW_PField(Parent)
;
; INPUTS:
;	Parent:	  The ID of the parent widget.
;
; KEYWORD PARAMETERS:
;	UVALUE:	The user value for the widget.
;	TITLE:	A label or title (Default='Pars: ')
;	PTITLES: An array of strings with titles for the different fields. 
;	VALUE:	The initial value. It must be of structure type with
;		two tags. The first tag contains a floating array
;		with the values to be displayed. The second one 
;		contains an array of flags. Flag=0 means that the
;		corresponding floating number is unsensitive. Flag=1
;		means sensitive.
;	COLUMN:	Display widgets inside the compound widget in column.
;	FRAME:	Display a frame around the compound widget.
;	XSIZE:	the size (in characters) of the text widgets containing
;		the float numbers.
;	
; OUTPUTS:
;	The ID of the created widget is returned.
;
; SIDE EFFECTS:
;
;
;
;	CW_PField widgets generate events when the text is edited (finished 
;	by <enter>) and when a button is pressed.  
;	The event structure returned by the CW_PField function is defined by 
;	the following statement:
;
;	{ID:0L, TOP:0L, HANDLER:0L, INDEX:0L, TYPE:''}
;
;	ID is the widget ID of the button generating the event. TOP is the
;	widget ID of the top level widget containing ID. HANDLER contains the
;	widget ID of the widget associated with the handler routine. 
;	INDEX returns the index (starting with 0) of the affected field. 
;	Type returns "F" or "G" if the buttons labelled with the same letters
;	are pressed. It returns "" (empty string) if a floating number is
;	changed. 
;
; PROCEDURE:
;	
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio, srio@esrf.fr
;	15 January , 1999
;-
;
;===============================================================
;
Pro CW_PField_Set, id, value
; acceps 'Default' and , for instance, [0,3,3]
;
child=Widget_Info(id, /Child)
Widget_Control, child, Get_UValue=state, /No_Copy
;
; update values
;
nmin = N_Elements(value.(0)) < N_Elements(state.value.(0))
tmp1 = (value.(0))[0:nmin-1]
tmp2 = (value.(1))[0:nmin-1]
ttmp1 = (state.value.(0))
ttmp2 = (state.value.(1))
ttmp1[0:nmin-1]=tmp1
ttmp2[0:nmin-1]=tmp2
state.value.(0)=ttmp1
state.value.(1)=ttmp2
;
; update widgets
;
tmp=''
FOR i=0L,nmin-1 DO BEGIN
  ftmp = (value.(0))[i]
  itmp = (value.(1))[i]
  Widget_Control,state.wids.fields[i],Set_Value=ftmp,$
    Sensitive=itmp
ENDFOR

Widget_Control, child, Set_UValue=state, /No_Copy
END
;
;===============================================================
;
Function CW_PField_Get, id
child=Widget_Info(id, /Child)
Widget_Control, child, Get_UValue=state, /No_Copy

value = state.value

Widget_Control, child, Set_UValue=state, /No_Copy

RETURN,value
END
;
;===============================================================
;
Function CW_PField_Event, event

child = Widget_Info(event.handler, /Child)
Widget_Control, child, Get_UValue=state, /No_Copy

uValue=-1
Widget_Control,event.id, Get_UValue=uValue


wtype = Widget_Info(event.id,/Type)
stype =  ''
CASE wtype OF
  0:type='V'   ; Base????
  1: BEGIN     ; Button
	Widget_Control,event.id,Get_Value=stype
	IF stype EQ 'F' THEN BEGIN
	  flagValue = (state.value.(1))[uValue]
	  IF flagValue EQ 0 THEN newFlagValue=1 ELSE newFlagValue=0
	  tmp = state.value.(1)
	  tmp[uValue]=newFlagValue
	  state.value.(1)=tmp
	  ;(state.value.(1))(uValue)=3 ; newFlagValue
	  ;(state.value.flags)[uValue]=newFlagValue
	ENDIF
	END
  else:
ENDCASE

tmp=''
FOR i=0L,N_Elements(state.value.(0))-1 DO BEGIN
  Widget_Control,state.wids.fields[i],Get_Value=tmp
  aa=(state.value.(0))
  aa[i]=tmp[0]
  state.value.(0)=aa
  Widget_Control,state.wids.fields[i],Sensitive=((state.value.(1))[i])
ENDFOR
; print,state.value
  
out:
Widget_Control, child, Set_UValue=state, /No_Copy
;
; return event structure
;
iret=1
if iret then begin
  WIDGET_CONTROL, event.id, get_uvalue=uvalue
  if n_elements(uvalue) EQ 0 then uvalue=0
  return, { ID:event.handler, TOP:event.top, HANDLER:0L, $
    index:Long(uValue), type:stype }
endif else return,0

END
;
;
;===============================================================
;
Function CW_PField, parent, UValue=uval, Title=init_label, $
  Value=init_value,Column=Column,Frame=Frame, XSIZE=xsize, $
  PTitles=pTitles

On_Error,1

IF N_Elements(uval) EQ 0 THEN uval = 0
IF N_Elements(Frame) EQ 0 THEN Frame = 1
IF N_Elements(init_label) EQ 0 THEN init_label = 'Pars: '
IF N_Elements(xsize) EQ 0 THEN xSize=8

IF N_Elements(init_value) EQ 0 THEN BEGIN
  nn = 4
  init_value = { data:FltArr(nn), flags:Replicate(1,nn) }
ENDIF ELSE BEGIN
  nn = N_Elements(init_value.(0))
ENDELSE

row=1
If keyword_set(column) then row=0 else Column=0



cw_tlb = Widget_Base(parent, Frame=Frame, Uvalue=uval, $
   Column=Column,Row=Row, $
   Event_Func='CW_PField_Event',$
   Pro_Set_Value='CW_PField_Set', $
   Func_Get_Value='CW_PField_Get')
wtmp = Widget_Base(cw_tlb) ; To store state

;wbutton = Widget_Button(cw_tlb,Value='Browser...',UVALUE='BROWSER')
;wlabel = Widget_Label(cw_tlb, Value=init_label)
;wFileName = Widget_Text(cw_tlb, VALUE=value, UVALUE='FILENAME',/Edit,$
;	Xsize=xsize)

wtmp = Widget_Label(cw_tlb,Value=init_label,/Align_Left)

wFields = LonArr(nn)
wButtonsUp = LonArr(nn)
wButtonsDown = LonArr(nn)
FOR i=0L,nn-1 DO BEGIN
  uValue=i
  IF Keyword_Set(ptitles) THEN wtmp = Widget_Label(cw_tlb,/Align_Left,$
	Value=pTitles[i])
  wtmp = CW_Field(cw_tlb,/Float,Value=(init_value.(0))[i],Title=' ',$
    XSize=xSize,/Return_Events,UValue=uValue)
  wFields[i]=wtmp
  wtmp0 = Widget_Base(cw_tlb,/Col) 
    wtmp = Widget_Button(wtmp0,Value='G',Scr_XSize=15,Scr_YSize=15,$
	UValue=uValue)
    wButtonsUp[i]=wtmp
    wtmp = Widget_Button(wtmp0,Value='F',Scr_XSize=15,Scr_YSize=15,$
	UValue=uValue)
    wButtonsDown[i]=wtmp
ENDFOR

wids={fields:wFields, buttonsUp:wButtonsUp, buttonsDown:wButtonsDown}
state = {wids:wids, value:init_value}

child=Widget_Info(cw_tlb, /Child)
Widget_Control, child, Set_UValue=state , /No_Copy

widget_control,cw_tlb,set_value=init_value

Return, cw_tlb
END
