PRO Xop_UnSetEnv, key, All=all

;+
; NAME:
;       XOP_UNSETENV
;
; PURPOSE:
;       Simulates UnSetEnv for MacOs. Not implemented on other platforms.
;
; CATEGORY:
;       XOP
;
; CALLING SEQUENCE:
;       Xop_UnSetEnv, key, [/All]
;
; INPUTS:
;       key = variable name (STRING)
;
; KEYWORD PARAMETERS:
;       All: When set, deletes all keys in the "silo" buffer (destroys the object).
;
; OUTPUTS:
;
; SIDE EFFECTS:
;
; PROCEDURE:
;       Uses a common block to store the object reference.
;       The "silo" buffer uses keys (variable names) that are case insensitive.
;       The stored data (values) are case sensitive.
;
; COMMON BLOCKS
;       COMMON xop_env, silo
;
; EXAMPLES:
;       Xop_UnSetEnv, 'XOP_HOME'
;       Xop_UnSetEnv, /All
;
; MODIFICATION HISTORY:
;       Written by: Roger J. Dejus (dejus@aps.anl.gov) 01/29/99.
;       Uses a "silo" buffer: An object data storage mechanism written by
;       Robert.Mallozzi@msfc.nasa.gov
;       Modified by: Roger J. Dejus (dejus@aps.anl.gov) 02/03/99.
;       Added the keyword parameter "All".
;-

COMMON xop_env, silo

IF SDep() NE 'MACOS' THEN BEGIN
  Message, /Continue, 'Routine not implemented for ' +SDep()
  RETURN
ENDIF

IF Keyword_Set(all) AND Obj_Valid(silo) THEN BEGIN
  Obj_Destroy, silo
  RETURN
ENDIF

IF N_Params() EQ 0 THEN BEGIN
  Message, /Continue, 'Incorrect number of arguments.'
  RETURN
ENDIF

IF Obj_Valid(silo) THEN silo->Delete, key
  
RETURN
END
