FUNCTION Xop_Input_Load,_Extra=extra,inputFile=inputFile,Group=group

;+
; NAME:
;       XOP_INPUT_LOAD
;
; PURPOSE:
;       This function loads an XOP input file and returns and IDL
;	structure with the results.
;
; CATEGORY:
;       XOP
;
; CALLING SEQUENCE:
;       str = Xop_Input_Load()
;
; INPUTS:
;       
;
;
; KEYWORD PARAMETERS:
;       GROUP:  The widget ID of the group leader of the widget.  If this
;               keyword is specified, the death of the group leader results i n
;               the death of widgets created by XOP_WD.
;	inputFile: set to a file name containing the XOP input parameters.
;		(If inputFile is not selected, starts the file browser).
;	_Extra: any other keywords are passed to DIALOG_PICKFILE.
; OUTPUTS:
;       str: a structure with the result parameters
;
; SIDE EFFECTS:
;
; PROCEDURE:
;       Uses the syntaxis defined in Make_Str and Write_Str functions.
;
; USE:
;       This procedure is to be used by XOP when reading application
;	parameters from a file. 
;
; EXAMPLES:
;       str = xop_input_load,'file.xop'
;
; MODIFICATION HISTORY:
;       Written by:     Manuel Sanchez del Rio (srio@esrf.fr) 98/11/05
;-
Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   IF SDep(/W) THEN itmp = Dialog_Message(Dialog_Parent=group, $
   /Error,'XOP_INPUT_LOAD: error caught: '+!err_string)
   catch, /cancel
   on_error,2
   Return,0
endif

IF KeyWord_Set(inputFile) THEN BEGIN
  IF CheckFile(inputFile) NE 1 THEN BEGIN
   IF SDep(/W) THEN itmp = Dialog_Message(Dialog_Parent=group, $
     /Error,'XOP_INPUT_LOAD: File not found: '+inputFile)
   RETURN,0
  ENDIF
  ffile = inputFile
ENDIF ELSE BEGIN
  ffile = Dialog_Pickfile(_Extra=extra)
ENDELSE
if strcompress(ffile,/rem) EQ '' then Return,0

str = Make_Str(ffile,/File)

RETURN,str
END
