FUNCTION XAID_ReSample,x,y,xnew

;+
; NAME:
;	XAID_Resample
;
; PURPOSE:
;	This function resamples a data set (i.e., makes some kind of
;	smoothed interpolarion).
;
; CATEGORY:
;	XAID xafs data analysis package. 
;
; CALLING SEQUENCE:
;
;	yNew = Xaid_resample(x,y,xNew)
;
; INPUTS:
;	x,y the abscissas and coordinates of data to be resampled.
;	xNew the abscissas array for the resampled data.
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;
; OUTPUTS:
;	yNew: the resampled data array.
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;	The data ate sorted and removed duplicated abscissas before
;	making the operations.
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	For each point x[i] of xNew it calculates yNew consisting in
;	the average y values of all points (x,y) sitting in the 
;	interval [x[i]-0.5*step1,x[i]+0.5*step2], with step1=x[i]-x[i-1]
;	and step2=x[i+1]-x[i]. In the case that step1 or step2 are
;	undefined (first and last points) we used step=[x[1]-x[0]] instead 
;	step1 or step2.
;
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio. ESRF
;	May 10, 2000
;-

On_Error,2

ai = Uniq(x,Sort(x))
a = x[ai]
ay = y[ai]
b = xnew

by=b*0.0

n_a = N_Elements(a)
n_b = N_Elements(b)
step = Abs(b[1]-b[0])
FOR i=0L,n_b-1 DO BEGIN
  fstart = b[i]
  IF i GT 0 THEN fstart = fstart - 0.5*Abs(b[i]-b[i-1]) ELSE $
                 fstart = fstart - 0.5*step
  ;fend = b[(i+1)<(n_b-1)]
  fend = b[i]
  IF i LT (n_b-1) THEN fend = fend + 0.5*Abs(b[i+1]-b[i]) ELSE $
                       fend = fend + 0.5*step
  ;IF fstart EQ fend THEN fend = fstart + step
  xileft = 0L
  xiright = n_a-1
  nn = 0L
  yy=0.0
  FOR j=0L,n_a-1 DO BEGIN
    ftest = a[j]
    IF ftest LE fstart THEN xileft = j
    IF ftest GE fend THEN BEGIN
      xiright = j
      ;GoTo,jOut
    ENDIF
    IF (ftest GE fstart) AND (ftest LT fend) THEN BEGIN
      nn = nn+1
      yy = yy + ay[j]
    ENDIF
  ENDFOR
  IF nn EQ 0 THEN yy = (ay[xiright]+ay[xileft])/2.0 ELSE yy=yy/nn
jOut:
by[i] = yy
ENDFOR

RETURN,by
END ; XAID_Resample


