FUNCTION write_str,b,file=file,Group=group,Comment=comment

;+
; NAME:
;
; PURPOSE:
;	This function returns a string array with the contents of a 
;	structure.
;	Each line of the array contains two or three fields
;	separated by "|". Fists field is the initialization value, second field
;	is the tag name, and third field is the value. When third fields is
;	missing, the value is set equal to the initialization value.
;	When a file is selected, a number of comment lines plus N lines with
;	the same arrangements are used.
;	Lines starting with semicolon (;) are considered as comments.
;
; CATEGORY:
;	General utilities.
;
; CALLING SEQUENCE:
;
;	result = Write_Str(str)
;
; INPUTS:
;	str: the structure to be written to a file.
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;       FILE: If set to a string, use this string as file name 
;	  for writing the text.
;	GROUP: The widget id of the caller. 
;	COMMENT:a text array with comments. 
;
; OUTPUTS:
;	A string array with the structure text.
;
; PROCEDURE:
;	Straightforward.
;
; LIMITATIONS
;	Complex numbers and arrays not supported.
;	Nested structures not supported.
;
; SEE ALSO:
;	Make_Str
;
; EXAMPLE:
;	str = { a:0.7, b:'Its me again...'}
;	Print,Write_Str(str)
;	/* this gives: */
;	0.         | A                    |  0.700000
;	''         | B                    | 'Its me again...'
;
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio (srio@esrf.fr) 98-11-15
;	
;	98-12-14 srio@esrf.fr allows truncation of large arrays (>61)
;		because "execute" cannot handle them. 
;	
;-
Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   IF SDep(/w) THEN itmp = Dialog_Message(Dialog_Parent=group, $
   /Error,'WRITE_STR: error caught: '+!err_string)
   catch, /cancel
   on_error,2
   Return,0
endif

nel=IntArr(n_tags(b))
FOR i=0L,N_Tags(b)-1 DO nel[i]=N_Elements(b.(i))
typ=IntArr(N_Tags(b))
FOR i=0L,n_tags(b)-1 DO typ[i]=Type(b.(i))

text = StrArr(N_Tags(b))
tnames = Tag_Names(b)
FOR i=0,N_Tags(b)-1 DO BEGIN
  field1=''
  field2=''
  field3=''
  IF nel[i] GT 1 THEN BEGIN
    IF nel[i] GE 62 THEN BEGIN
      itmp = Dialog_Message(/Question,Dialog_Parent=group,$
	['WRITE_STR: ****** WARNING ******','',$
        StrCompress(nel[i])+' values found in structure tag # '+$
		StrCompress(i),$
        'A maximum number of 61 will be read. ',$
        'Do you want to truncate it to 61?','','Suggested: Yes'] )
      IF itmp EQ 'Yes' THEN nel[i]=61
    ENDIF
    CASE typ[i] OF
     1:field1='BytArr('+StrCompress(nel[i],/Rem)+')'
     2:field1='IntArr('+StrCompress(nel[i],/Rem)+')'
     3:field1='LonArr('+StrCompress(nel[i],/Rem)+')'
     4:field1='FltArr('+StrCompress(nel[i],/Rem)+')'
     5:field1='DblArr('+StrCompress(nel[i],/Rem)+')'
     7:field1='StrArr('+StrCompress(nel[i],/Rem)+')'
     ELSE: Message,'Variable type not allowed: '+String(typ[i])
    ENDCASE
    field3=Vect2String( (b.(i))(0:nel[i]-1) )
  ENDIF ELSE BEGIN
    ;;;;;;;;;;;; field3=StrCompress(b.(i),/Rem)
    field3=StrCompress(b.(i))
    CASE typ[i] OF
     1:field1='0B'
     2:field1='0'
     3:field1='0L'
     4:field1='0.'
     5:field1='0D0'
     7:BEGIN
	field1="''"
	field3="'"+field3+"'"
	END
     ELSE: Message,'Variable type not allowed: '+String(typ[i])
    ENDCASE
  ENDELSE
  nblanks = 10-StrLen(field1)>1
  tmp=''
  FOR ii=0L,nblanks-1 DO tmp=tmp+' '
  field1=field1+tmp
  field2=tnames[i]
  nblanks = 20-StrLen(field2)>1
  tmp=''
  FOR ii=0L,nblanks-1 DO tmp=tmp+' '
  field2=field2+tmp
  text[i] = field1+' | '+field2+' | '+field3
ENDFOR

IF Keyword_Set(comment) THEN text = [comment,text]

IF Keyword_Set(file) THEN BEGIN
  OpenW,unit,file,/Get_Lun
  FOR i=0,N_Elements(text)-1 DO PrintF,unit,text[i]
  Free_Lun,unit
  Message,/Info,'File '+file+' written to disk.'
ENDIF
Return,text
END
  
