Function whistogram,Input,_Extra=extra,Xval=xval,obinsize=binsize, hadd=hadd, $
  NBins=nBins

;+
; NAME:
;	WHISTOGRAM
;
; PURPOSE:
; 	Wrapper for histogram, with addional keywords
;
; CATEGORY:
;	Wrapper
;
; CALLING SEQUENCE:
;	Result = wHistogram(array)
;
; INPUTS:
;	array:	The vector or array for which the density function is to 
;		be computed.
;
; OUTPUTS:
;	Returns a 32-bit or a 64-bit integer vector equal to the density
;	function of the input Array.
;
;
; KEYWORDS:
;	XVal: set this keyword to a named variable that will contain 
;	      the abscissas array for the histogram.
;	NBins: Set this histogram to the number of bins for the histogram. 
;		Warning: the binsize is calculated as  
;		binsize = (max(array) - min(array)) /nbins, therefore:
;		i) the output dimension of the histogram may be nbins+1
;		   dur to round errors.
;		ii) If MIN and MAX keywords are used (see Histogram doc)
;		    they have no effect for the calculation if binsize
;	HAdd: set this keyword to an array. The returned result will be
;		the calculated histogram plus hAdd
;
;	Any other keyword from the IDL hitogram funcion can be entered.
;
; MODIFICATION HISTORY:
;	Manuel Sanchez del Rio, ESRF, srio@esrf.fr, 23 Feb 2001
;-
on_error,2
;
; wrapper for histogram
;
o1min=0 & o1max=0

if keyword_set(nbins) then  begin
  binsize =  (max(input) - min(input)) /nbins
  out = Histogram(input,_extra=extra,oMin=o1Min,oMax=o1Max,BinSize=binSize)
endif else begin
  out = Histogram(input,_extra=extra,oMin=o1Min,oMax=o1Max)
endelse

nbins = N_Elements(out)

IF N_Elements(extra) NE 0 THEN  BEGIN
  tnames = Tag_names(extra)
  tmp = Where(tnames EQ 'BINSIZE')
  IF tmp[0] EQ -1 THEN binsize=(o1Max-o1Min)/nbins
ENDIF
  
xval = o1Min + findgen(nbins)/(nbins-1)*(o1Max-o1Min)

IF N_Elements(hadd) NE 0 THEN BEGIN
  IF N_Elements(hadd) NE N_Elements(out) THEN BEGIN
    Message,'Number of elements of output histo and trailing '+$
    'histo are different.  Ignoring trailing.'
  ENDIF ELSE out=out+hadd
ENDIF
return,out
end

