Function StrMatch1, str, list, len, caseon = cas, all = all

;+
; NAME:
;	STRMATCH1
; PURPOSE:
;	Compares the string STR with the strings in the array LIST.  Comparison
;	is done for the first LEN characters, or all of them if LEN is 0.  If a
;	 match is found, STR is replaced by the full string from the list (or
;	if the keyword /ALL is set, by an array containing all the matching 
;	strings).
; CATEGORY:
;	String Processing
; CALLING SEQUENCE:
;	Result = STRMATCH1( STR, LIST [, LEN] [, keywords])
; INPUTS:
;    STR
;	Character string.
;    LIST
;	Character array.
; OPTIONAL INPUT PARAMETERS:
;    LEN
;	The number of characters to compare.  Default is full comparison.
; KEYWORD PARAMETERS:
;    /CASEON
;	Switch. If set the comparison is case sensitive. Default is ignore case.
;    /ALL
;	Switch.  If set, returns the indices of all the matching elements.
; OUTPUTS:
;	Returns the index of the first match, or -1l if no match is found.
;	Optionally (see keyword ALL above) returns all the matching indices.
; OPTIONAL OUTPUT PARAMETERS:
;	None.
; COMMON BLOCKS:
;	None.
; SIDE EFFECTS:
;	None other then the substitution in STR.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	Uses the function STREQ from MIDL.
; MODIFICATION HISTORY:
;	Created 15-JUL-1991 by Mati Meron.
;	Modified 20-NOV-1993 by Mati Meron.  Added keyword ALL.
;	Modified 3-JUL-2001 by M. Sanchez del Rio:
;	  Renamed from  strmatch to strmatch1 (strmatch exists in native
;	  format since idl 5.3)
;-

    match = where(Streq(str,list,len,caseon = cas), nmatch)
    if not keyword_set(all) then match = match(0)
    if nmatch gt 0 then str = list(match)

    return, match
end
