

;+
; NAME:
;	STEP_SIGMOID
; PURPOSE:
;	Returns the value of a step function (sigmoid)
; CATEGORY:
;	Mathematics.
; CALLING SEQUENCE:
;	Result = step_sigmoid(x,p)
; INPUTS:
;	x: the argument for the function (number or array)
;	p: array with the function coefficients:
;		p[0] Amplitud
;		p[1] Center
;		p[2] Width-related parameter
; SIDE EFFECTS:
; 	None.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	Easy: tt =   (x-p[1])/p[2] & y = ( 1.0D0/ (1.0D0+exp(-tt*4.0)) ) * p[0]
;
; MODOFICATION HISTORY:
;	M. Sanchez del Rio. ESRF. Grenoble December 2001
;
;-
FUNCTION step_sigmoid,x,p
; tt =  ( (x-p[1])*2.0*  sqrt(alog(2.))  /p[2])
tt =   (x-p[1])/p[2]
y = ( 1.0D0/ (1.0D0+exp(-tt*4.0)) ) * p[0]
RETURN,y
END

