
;+
; NAME:
;	STEP_ERRORF
; PURPOSE:
;	Returns the value of a step function (error function)
; CATEGORY:
;	Mathematics.
; CALLING SEQUENCE:
;	Result = step_errorf(x,p)
; INPUTS:
;	x: the argument for the function (number or array)
;	p: array with the function coefficients:
;		p[0] Amplitud
;		p[1] Center
;		p[2] Full Width at Half Maximum (of the derivative)
; SIDE EFFECTS:
; 	None.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	Easy: 
;	tt =  ( (x-p[1])*2.0*  sqrt(alog(2.))  /p[2])
;	y = 0.5D0* ( 1.0D0 + errorf(tt) ) * p[0]
;
; MODOFICATION HISTORY:
;	M. Sanchez del Rio. ESRF. Grenoble December 2001
;
;-
FUNCTION step_errorf,x,p
tt =  ( (x-p[1])*2.0*  sqrt(alog(2.))  /p[2])
y = 0.5D0* ( 1.0D0 + errorf(tt) ) * p[0]
RETURN,y
END

