FUNCTION mergearrays, x1,x2,x3,x4

;+
; NAME:
;	MERGEARRAYS
;
; PURPOSE:
; 	To merge up to five arrays
;
; CATEGORY:
;	Array manipulation
;
; CALLING SEQUENCE:
;	Result = MergeArrays(X, Y [, Z, A, B])
;
; INPUTS:
;	X:	The first array.  X must be a vector.
;	Y:	The second array.  
;
; OPTIONAL INPUTS:
;	Z,A,B:	Other arrays to be merged. 
;
; OUTPUTS:
;	The merged array
;
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	 Very simple:
;	 xx=[Reform(X),Reform(Y)]
;	 Return,xx[ Uniq(xx,Sort(xx))]
;
; EXAMPLE
;	print,mergearrays([2,4,6,8,10],[1,3,5,7,9]
;	1     2     3     4     5     6     7     8     9     10
;
; MODIFICATION HISTORY:
;	Manuel Sanchez del Rio, ESRF, srio@esrf.fr, 7 Feb 2001
;-

on_error,2
CASE N_Params() OF
  0: message,'Usage: MergeArrays,x1,x2'
  1: xx=Reform(x1)
  2: xx=[Reform(x1),Reform(x2)]
  3: xx=[Reform(x1),Reform(x2),Reform(x3)]
  4: xx=[Reform(x1),Reform(x2),Reform(x3),Reform(x4)]
  5: xx=[Reform(x1),Reform(x2),Reform(x3),Reform(x4),Reform(x5)]
  else: message,'Usage: MergeArrays,x1,x2,...,x5'
ENDCASE
RETURN,xx[ Uniq(xx,Sort(xx)) ]
END

