Function keyword_extra,extra,kw,return_value=return_value

;+
; NAME:
;	KEYWORD_EXTRA
; PURPOSE:
;	to manage the _EXTRA (inherited) keyword in idl > 5.0
;	It returns a non-zero value if the corresponding keyword name 
;		is passed to the routine.
;		
; CATEGORY:
;
; CALLING SEQUENCE:
;	result = keyword_extra(extra,'tag')
; INPUTS:
;	extra   The structute with the inherited keywords passed
;		to the routine with the _EXTRA=extra keyword.
;	tag	The inherited keyword name, which in fact is a 
;		tag in the extra structure.
; KEYWORD PARAMETERS:
;		Return_value: when set, the function returned value is
;			the value of the keyword. Otherwise the 
;			returned value is a flag indicating the existence of 
;			such a keyword.
; OUTPUTS:
;	A flag value: 1 if the keyword exists, 0 if either the keyword
;		does not exist of the "extra" structure is undefined.
;		Optionally (see keyword Return_value) it returns the 
;		keyword value.
; COMMON BLOCKS:
;	None.
; SIDE EFFECTS:
;	None.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	by M. Sanchez del Rio (srio@esrf.fr). Aug 29 1997
;
;-	

if type(extra) NE 8 then begin
  ;message,'Not valid structure. Return 0'
  out=0
  goto,out
endif
tags = tag_names(extra)

nn = where(tags EQ strupcase(kw))
if nn(0) EQ -1 then out=0 else out=1
if keyword_set(return_value) then begin
  if out EQ 0 then begin
    message,/info,'Keyword not found: '+kw
    goto,out
  endif
  out = extra.(nn(0))
endif
out:
return,out
end

