function HISTOGRAMW3,arr1,arr2,arr3,wei, $
binsizex=p_binsizex, binsizey=p_binsizey, binsizez=p_binsizez, $
XRANGE=p_xrange, YRANGE=p_yrange, ZRANGE=p_zrange
;+
; NAME:
;	HISTOGRAMW3
; PURPOSE:
;	Same as HISTOGRAM, but weighted by wei array and tridimensional.
; CATEGORY:
;	General
; CALLING SEQUENCE:
;	a= HISTOGRAM3(arr1,arr2,arr3,wei,keywords)
; INPUTS:
;	ARR1 name of the array with data
;	ARR2 name of the array with data
;	ARR3 name of the array with data
;	WEI name of the array with weigths 
; OPTIONAL INPUT PARAMETERS:
;	None.
; KEYWORD PARAMETERS:
;       BINSIZEX = bx :  binsize along x-axis.
;       BINSIZEY = by :  binsize along y-axis.
;       BINSIZEZ = bz :  binsize along z-axis.
;       XRANGE = [x_min,x_max]
;       YRANGE = [y_min,y_max]
;       ZRANGE = [z_min,z_max]
; OUTPUTS:
;	Density function of ARR (tridimensional)
; OPTIONAL OUTPUT PARAMETERS:
;	Same as HISTOGRAM.
; COMMON BLOCKS:
;	None.
; SIDE EFFECTS:
;	None.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	Straightforward.
; MODIFICATION HISTORY:
;	M. Sanchez del Rio. ESRF. Grenoble Feb 1995
;-
on_error,2

if n_params() LT 3 then begin
  print, $
    'HISTPGRAMW3: Usage Result = histogramw3(arr1,arr2,arr3,[w,],keywords)'
  return,0
endif

if n_params() EQ 3 then wei=arr1*0.+1.

if ( (n_elements(arr1) ne n_elements(arr2)) or $
     (n_elements(arr1) ne n_elements(arr3))  or $
     (n_elements(arr1) ne n_elements(wei)) ) then begin
  print,' array dimensions not compatible.' 
  return,0
endif
;
; set limits
;
if keyword_set(p_xrange) then xrange = p_xrange else $
                              xrange = [min(arr1),max(arr1)]
if keyword_set(p_yrange) then yrange = p_yrange else $
                              yrange = [min(arr2),max(arr2)]
if keyword_set(p_zrange) then zrange = p_zrange else $
                              zrange = [min(arr3),max(arr3)]
;
; set bins
;
if keyword_set(p_binsizex) then binsizex = p_binsizex else binsizex = 1
if keyword_set(p_binsizey) then binsizey = p_binsizey else binsizey = 1
if keyword_set(p_binsizez) then binsizez = p_binsizez else binsizez = 1
nbinsx = fix( .9999 + ((xrange(1) - xrange(0)) /binsizex))
nbinsy = fix( .9999 + ((yrange(1) - yrange(0)) /binsizey))
nbinsz = fix( .9999 + ((zrange(1) - zrange(0)) /binsizez))
print,'HISTOGRAMW3: bins in X, Y and Z: ',nbinsx,nbinsy,nbinsz
;
; calculate histogram
;
hy = fltarr (nbinsx,nbinsy,nbinsz)
nelem = n_elements(arr1)
for ii=0L,nelem-1 do begin
 if ( (arr1(ii) ge xrange(0)) and (arr1(ii) le xrange(1)) and  $
      (arr2(ii) ge yrange(0)) and (arr2(ii) le yrange(1)) and  $
      (arr3(ii) ge zrange(0)) and (arr3(ii) le zrange(1)) ) then begin
  hwx = fix( (arr1(ii)-xrange(0))/binsizex )
  hwy = fix( (arr2(ii)-yrange(0))/binsizey )
  hwz = fix( (arr3(ii)-zrange(0))/binsizez )
  if hwx ge nbinsx then hwx=nbinsx-1 & if hwx lt 0 then hwx=0
  if hwy ge nbinsy then hwy=nbinsy-1 & if hwy lt 0 then hwy=0
  if hwz ge nbinsz then hwz=nbinsz-1 & if hwz lt 0 then hwz=0
  hy(hwx,hwy,hwz) = hy(hwx,hwy,hwz) + wei(ii)
  endif
 endfor
return, hy
end
