FUNCTION getfwhm,set,plot=plot,reverse_plot=reverse_plot,group=group
;+
; NAME:
;	GETFWHM
;
; PURPOSE:
;	This function calculates the FWHM of a curve
;
; CATEGORY:
;	X-ray optics utilities.
;
; CALLING SEQUENCE:
;
;	fwhm_value = getfwhm(rc)
;
; INPUTS:
;	rc: a fltarr(2,npts) with the curve
;
; KEYWORD PARAMETERS:
;	PLOT:	when set to 1, put marks on the graphic y vs x
;	REVERSE_PLOT:	when set to 1, put marks on the graphic x vs y
;	GROUP = The widget ID of the widget that calls GETFWHM.
;		When this ID is specified, and GETFWHM fails to calculate
;		a result, them a widget message appears.
;
; OUTPUTS:
;	The fwhm value
;
; PROCEDURE:
;	Straightforward
;
; EXAMPLE:
;
;		a = getfwhm(rc,/plot)
;
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio.
;	April, 1993	
;	93-10-21 MSR Small changes
;	96-07-10 MSR Makes a linear interpolation between the two 
;		closest points to the half-max value in order to account 
;		for a more precise value of the fwhm.
;	97-04-19 MSR takes the minimum value of the array (not zero)
;		for the calculation.
;-
on_error,2
;
; get the fwhm
;
z1=set(1,*)
x = set(0,*)
;
tmp=0
hm = (abs( max(z1,min=tmp)-tmp )/2.)+tmp
npts = n_elements(z1)
;for j=1,npts-1 do begin
;  if (z1(j-1) lt hm) and (z1(j) ge hm) then xleft = j
;endfor
;
;
xleft = 0L
j = 1L & i_found = 0
while (i_found eq 0) and (j le npts-1) do begin
  if (z1(j-1) lt hm) and (z1(j) ge hm) then begin
    xleft = j
    i_found = 1
  endif
  j = j+1
end
;
xright = n_elements(z1) - 1
j = npts-1 & i_found = 0
while (i_found eq 0) and (j ge 1) do begin
  if (z1(j-1) gt hm) and (z1(j) le hm) then begin
    xright = j
    i_found = 1
  endif
  j = j-1
end
if ( xleft  eq 0 or xright eq n_elements(z1) - 1 ) then begin
  txt = 'Value not found. Returning 0.' 
  message,/info,txt
  if keyword_set(group) then itmp = Dialog_Message(Dialog_Parent=group,$
	'GETFWHM: '+txt)
  return,0
endif

; linear interpolation  left
m = (z1(xleft-1) - z1(xleft)) / (x(xleft-1) - x(xleft))
n = z1(xleft) - m*x(xleft)
xxl = (hm - n)/m
; linear interpolation  right
m = (z1(xright-1) - z1(xright)) / (x(xright-1) - x(xright))
n = z1(xright) - m*x(xright)
xxr = (hm - n)/m

;fwhm = abs(x(xleft)-x(xright))
fwhm = abs(xxl-xxr)
if keyword_set(plot) then $
  ;oplot,[0.5*(x(xleft)+x(xleft-1)),0.5*(x(xright)+x(xright-1))],[hm,hm],psym=1
  oplot,[xxl,xxr],[hm,hm],psym=1
if keyword_set(reverse_plot) then $
  ;oplot,[hm,hm],[0.5*(x(xleft)+x(xleft-1)),0.5*(x(xright)+x(xright-1))],psym=1
  oplot,[hm,hm],[xxl,xxr],psym=1

;
return,fwhm
end
