PRO Delete_Files,files,Confirm=confirm, Group=group, Silent=silent

;+
; NAME:
;	DELETE_FILES
;
; PURPOSE:
;	This procedures delete disk files.
;
; CATEGORY:
;	General utilities.
;
; CALLING SEQUENCE:
;
;	Delete_Files,files
;
; INPUTS:
;	files: a string (or string array) containing the file(s) to
;		be deleted.
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;	Confirm: When this keyword is set, and the current device
;		supports widgets, a dialog box is display to 
;		confirm deletion of each file.
;	Silent: If set, the information message after deletion of 
;		a file is suppressed.
;	Group: The widget id of the called. Used for centering the 
;		Dialog_Message window in case of messages.
;		
;
; OUTPUTS:
;
; SIDE EFFECTS:
;	Deletes files. If the "files" does not exist, no error
;	/warning  message is presented.
;
; PROCEDURE:
;	Straightforward. Uses FindFile to deal with wildcards and
;	the /Delete keyword in the Open procedure for removing files.
;
; EXAMPLE:
;	Delete_Files,'tmp'
;	Delete_Files,['tmp*','test*'],/Confirm
;
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio (srio@esrf.fr) 99-01-15
;	
;-

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   IF SDep(/W) THEN itmp = Dialog_Message(/Error,Dialog_Parent=group, $
     'DELETE_FILES: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF

IF N_Params() EQ 0 THEN RETURN
IF Type(files) NE 7 THEN RETURN

FOR i=0L,N_Elements(files)-1 DO BEGIN
  ifiles = FindFile(files[i])
  FOR j=0L,N_Elements(ifiles)-1 DO BEGIN
    IF ifiles[j] NE '' THEN BEGIN
      itmp = 'Yes'
      IF Keyword_Set(confirm) THEN BEGIN
        IF SDep(/W) THEN itmp = Dialog_Message(/Question,Dialog_Parent=group,$
           'Remove file '+ifiles[j]+' ?',/Cancel)
        IF itmp EQ 'Cancel' THEN RETURN
      ENDIF
      IF itmp EQ 'Yes' THEN BEGIN
        Catch,/Cancel
        OpenW,unit,ifiles[j],/Get_Lun,Error=error,/Delete
        IF error EQ 0 THEN BEGIN
          Free_Lun,unit 
          IF NOT(Keyword_Set(silent)) THEN $
            Message,/Info,'File removed: '+ifiles[j]
        ENDIF ELSE BEGIN
          IF NOT(Keyword_Set(silent)) THEN $
            Message,/Info,'Error removing file: '+ifiles[j]
        ENDELSE
        Catch, error_status
      ENDIF
    ENDIF
  ENDFOR
ENDFOR

END
