FUNCTION conv_gauss,f1,sigma
;+
; NAME:
;	CONV_GAUSS
;
; PURPOSE:
;	This function returns the convoluted set of data between
;	the input set of data and a normalized gaussian.
;	Input and output data set are defined as fltarr(2,npts).
;
; CATEGORY:
;	Mathematics.
;
; CALLING SEQUENCE:
;
;	result = CONV_GAUSS(f1,sigma)
;
; INPUTS:
;	f1 : the input data set
;	sigma : the sigma value of the gaussian.
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;
; OUTPUTS:
;	the convoluted function
;
; SIDE EFFECTS:
;
; PROCEDURE:
;	change each y value by the 
;	Integral(y_array*gaussian_centered_in_xi)
;
; EXAMPLE:
;
;		a = conv(f1,0.2)
;
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio 95-03-16
;
;-
;
;
on_error,2

t = size(f1)
if (t(n_elements(t)-2) eq 5) then double=1 else double=0
if double then sigma=double(sigma) else sigma=float(sigma)

x=reform(f1(0,*) )
y=reform(f1(1,*) )

nn=n_elements(x)
step = x(1) - x(0)
if step LT 0. then sort=1 else sort=0
if sort then begin
  print,'CONV_GAUSS: Sorting data...'
  xsort = sort(x)
  x=x(xsort)
  y=y(xsort)
endif
if abs(sigma) LT abs(step) then $
  print,'CONV_GAUSS: Warning: sigma smaller than step size. '
steplast = x(nn-1) - x(nn-2)
if step-steplast GT 1e-7 then begin
  print,'CONV_GAUSS: Error: X sampling must be regular. Returning'
  return,0
endif
if double then yconv = dblarr(nn) else yconv = fltarr(nn)
print,y

for i=0,nn-1 do begin
  gauss = exp(- (x-x(i))^2/2./sigma^2 )/sqrt(2.*!pi)/sigma
  yconv(i) = int_tabulated( x,y*gauss) 
endfor

f2=f1
f2(0,*)=x
f2(1,*)=yconv 

return,f2
;
end
