pro boxchart,y,color=color,title=title,names=names,ynozero=ynozero,$
  xtitle=xtitle,ytitle=ytitle
;+
; NAME:
;	BOXCHART
; PURPOSE:
;	Creates a boxchart graph
; CATEGORY:
;	Graphics
; CALLING SEQUENCE:
;	BOXCHART, ARR [, Keywords]
; INPUTS:
;    ARR
;	The array with the box heights.
; OPTIONAL INPUT PARAMETERS:
;	None.
; KEYWORD PARAMETERS:
;    COLOR color index to fill the boxes.
;    TITLE string with title
;    NAMES string or numerical vector (with the same dimension as ARR) with 
;	the titles of the boxes.
;    YNOZERO (as in idl's plot)
;    XTITLE  (as in idl's plot)
;    YTITLE  (as in idl's plot)
; OUTPUTS:
;	Makes a boxchart graph.
; OPTIONAL OUTPUT PARAMETERS:
;    None.
; COMMON BLOCKS:
;	None.
; SIDE EFFECTS:
;	None.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	Based in the example at the IDL User Guide (pag. 14-17)
; MODIFICATION HISTORY:
;	Created 1-NOV-1995 by M. Sanchez del Rio (srio@esrf.fr) (c)ESRF
;-

on_error,2
ny = float(n_elements(y))
;help,ny
xval = findgen(ny)/(ny+1) + .2
print,xval
;yval = [100.,200.,123.,664.]
yval = y
if not(keyword_set(color)) then color=intarr(ny) + 128

;names=['A','B','C','D']
if not(keyword_set(names)) then names = strcompress(sindgen(ny),/rem)
if not(keyword_set(ynozero)) then ynozero = 0
if not(keyword_set(xtitle)) then xtitle = ''
if not(keyword_set(ytitle)) then ytitle = ''
if not(keyword_set(title)) then title= ''

plot,xval,yval,ynozero=ynozero,xrange=[0,1],xtickv=xval,xticks=ny-1,xtickname=$
names, /nodata, title=title, xtitle=xtitle, ytitle=ytitle

for i=0L,ny-1 do begin
  polyfill, $
  [xval(i)-.08, xval(i)-.08, xval(i)+ 0.08, xval(i)+ 0.08], $ 
  [!y.crange(0), Yval(i), Yval(i), !y.crange(0)] , color = color(i)
;  print,'X: ',[xval(i)-.08, xval(i)-.08, xval(i)+ 0.08, xval(i)+ 0.08]
;  print,'Y: ',[!y.crange(0), Yval(i), Yval(i), !y.crange(0)]
;  print,''
endfor
end
