; INTERNAL FUNCTIONS AND PROCEDURES
;___________________________________
;
; This procedure loads in `handle' the information contained in the main header
; block that correspond to the current scan.
pro __headerload, handle 
   if handle.headerpt ne handle.scan(handle.currscan).headerpt then begin
      n = handle.scan(handle.currscan).headerlines
      motorlbl = handle.motornames
      motorlbl(*, *) = ''
      motor_no = handle.motor_no
      motor_no(*) = 0
      epoch = -1L
      nmotlines = -1
      if n gt 0 then begin
         openr, Unit, handle.specfile, /get_lun
         point_lun, Unit, handle.scan(handle.currscan).headerpt
         line = ''
         motline = 0
	 ; srio 98/08/25 places "nmotlines = -1" outside the "if" block
         ;nmotlines = -1
         for i = 1, n do begin
            __readline, Unit, line
            case strmid(line, 1, 1) of
               'E': begin
                  epoch=long(strmid(line, 2, strlen(line)-2))
               end

               'O': begin
                  aux = __linecut(line)
                  reads, aux, format='(2X,I)', motline
                  aux = __linesplit(line, 2, 0, 0)
                  if aux(0) eq '' then begin
                     motor_no(motline) = 0
                  endif else begin
                     motor_no(motline) = n_elements(aux)
                     motorlbl(motline, 0:n_elements(aux) - 1) = aux
                  endelse
                  if motline + 1 gt nmotlines then nmotlines = motline + 1
               end

               else:

            endcase
         endfor
         free_lun, Unit
      endif
      handle.headerpt = handle.scan(handle.currscan).headerpt
      handle.epoch = epoch
      handle.nmotorlines = nmotlines
      handle.motor_no = motor_no
      handle.motornames = motorlbl
   endif
end
