;
;+
;
;==============================  Xxcom   =======================================
;
; Xxcom is a widget based graphical interface to calculate and display 
; photon cross sections. 
;
; It interfaces XCOM, a computer program and data base to calculate photon 
; cross sections for scattering, photoelectric absorption and pair production,
; as well as attenuation coefficients, in any element, compound or mixture,
; at energies from 1keV to 100GeV.
;
; The XCOM program has been written by M.J. Berger and J.H. Hubbell at NIST
; (see Help/Xcom).
;
; DESCRIPTION OF THE CONTROLS IN THE MAIN WINDOW:
;
;  File:
;    Xxcom input parameters: This option allows to save the current
;		parameters to a file for later loading. It also allows
;		to save the current parameters as defaults for being
;		used when the application is initialized. In the last
;		case, the file is named "application".xop (where 
;		"application " is the name of the current XOP
;		application) and is written in the directory pointed
;		by the XOP_DEFAULTS_DIR environment variable (which
;		must be set). The parameter file is ASCII and can be
;		read and edited with care.
;  Quit: to exit from the program
;
; Set_Parameters:
;  Set Parameters: to define the parameters for the calculation.
;		The same result is obtained pressing the "Set Parameters"
;		button in the main Xxcom window. 
;               Please refer to the information under the HELP
;		button for a complete description of the parameters. After 
;		pressing the ACCEPT button, xcom starts running.
;  Set Defaults: Sets the default parameters.
;
;  Show: Display results
;    Plot Data: Shows the output data with the XPLOT
;	facility. It is possible to switch between the output 
;	quantities and to do a large number of operations and 
;	display presentations by using the XPLOT controls
;    Numerical Data: Displays the output file.
;
;  Help:   Shows the xcom help and xxcom help (this text).
;
;
; COPYRIGHT:
;	xxcom  belongs to XOP package and it is distributed within XOP.
;	PLEASE REFER TO THE XOP COPYRIGHT NOTICE BEFORE USING IT.
;
; CREDITS:
;	Published calculations made with XOP should refer:
;
;	  M. Sanchez del Rio and R. J. Dejus "XOP: Recent Developments"
;	  SPIE proceedings vol. 3448, pp.340-345, 1998.
;
;	In addition, published calculations using the xcom aplication 
;	should also cite:
;	  XCOM: Photon Cross Sections on a Personal Computer
;	  M. J. Berger and J. H. Hubbell, Center for Radiation Research,
;	  National Bureau of Standards, Gaithersburg, MD 20899
;
;
; LAST MODIFICATION: msr/msr/99-03-16
;
;
;-
; -----------------------------------------------------------------------
;	Author: M. Sanchez del Rio (srio@esrf.fr) , ESRF, April 17, 1996
;	Modification history:
;	97/01/20 srio@esrf.fr ports to Windows95. Cosmetics. Version 1.1.
;	97/10/27 srio@esrf.fr doc updated.
;	98/12/10 srio@esrf.fr adapts for XOP2.0
;	99/03/16 srio@esrf.fr updates doc.
;
;-
;		
;========================================================================
;
FUNCTION XXCOM_VERSION
return,'1.2'
end
;
;========================================================================
;
PRO xxcom_inp_write,str, Group=group

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=group, $
     'XXCOM_INP_WRITE: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF
;
openw,Unit,'xcom.inp',/GET_LUN
;
;
;
;
sep = sdep(/ds)
;
; this is because the windows version has XOP_HOME finished
; by \ (required by imd) and the impro and xcom programs do not
; accept \\ in the file name. 
;
IF SDep() EQ 'WINDOWS' THEN sep2='' ELSE sep2=sep
printf,Unit,Xop_GetEnv('XOP_HOME')+sep2+'data'+sep+'xcom'+sep

;printf,Unit,Xop_GetEnv('XOP_HOME')+sep+'data'+sep+'xcom'+sep
printf,Unit,str.name
isubstance = fix(str.substance(0))+1
printf,Unit,isubstance
if isubstance NE 4 then begin
  printf,Unit,str.description
  if isubstance LE 2 then begin
    printf,Unit,fix(str.elementoutput(0))+1
  endif
endif else begin
  n = strparse(str.description,':',listdes)
  m = strparse(str.fraction,':',listfrac)
  printf,Unit,n+1
  for i=0,n do begin
    printf,Unit,listdes(i)
    printf,Unit,listfrac(i)
  endfor
  printf,Unit,'1' 
endelse

igrid = fix(str.grid(0))+1
printf,Unit,igrid
if igrid NE 1 then begin
  igridinput = fix(str.gridinput(0)+1)
  printf,Unit,igridinput
  if igridinput EQ 1 then begin
    nn = strparse(str.griddata,':',listgrid)
    printf,Unit,nn+1
    for i=0,nn do printf,Unit,listgrid(i)
  endif else begin
    printf,Unit,str.griddata
    printf,Unit,str.fileconv
  endelse
endif
printf,Unit,'xcom.out'
printf,Unit,'1'

;
;
;
free_lun,Unit
end
;
;========================================================================
;
PRO xxcom_event,event,GROUP=group

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=event.top, $
     'XXCOM_EVENT: error caught: '+!err_string)
   Catch, /Cancel
   If Type(stateid) EQ 3 THEN $
     IF Widget_Info(stateid,/Valid_Id) AND N_Elements(state) NE 0 THEN $
     Widget_Control,stateid,Set_UValue=state,/No_Copy
   On_Error,2
   RETURN
ENDIF

;
; register the events
;
Widget_control, event.id, Get_uvalue=eventuval

stateid = Widget_Info(event.handler,/Child)
Widget_control, stateid,  Get_uvalue=state,/No_Copy

;inp = state.str



WIDGET_CONTROL, event.id, GET_UVALUE=eventuval
widget_control, event.top, get_uvalue = str

CASE eventuval OF

        'FILEINPUT': BEGIN
          action=''
          Widget_Control,event.id, Get_Value=action
          CASE action OF
            'Load from file...': BEGIN
              ;if sdep() EQ 'UNIX' then filter='*.xop' else filter=0
	      filter='*.xop'
              str_par = Xop_Input_Load(Title=$
              'Select Xxcom input file...',$
              /NoConf,Filter=filter,Group=event.top)
              IF Type(str_par) EQ 8 THEN BEGIN
                tmp = state.str.parameters
                Copy_Structure,str_par, tmp, Group=event.top ,/OnlyFirstField
                state.str.parameters = tmp
              ENDIF
            END
            'Save to file...': BEGIN
              str_par = state.str.parameters
              Xop_Input_Save,str_par,File='xxcom.xop',$
                /Write, Group=event.top, Comment='; xop/xxcom(v'+$
              xxcom_version()+') input file on '+SysTime()
            END
            'Save as default': BEGIN
              str_par = state.str.parameters
              Xop_Input_Save,str_par,Group=event.top, $
                Default='xxcom.xop',Comment='; xop/xxcom(v'+$
              xxcom_version()+') input file on '+SysTime()
            END
          ENDCASE
        END
;	'FILELOAD': BEGIN
;		ffile = pickfile(title='Select Xxcom input file...',/NOCONF)
;		if strcompress(ffile,/rem) EQ '' then GoTo,out
;		version = 0
;		restore,ffile,/VERBOSE
;		if version NE xxcom_version() then itmp = widget_message( $
;		  dialog_parent=event.top,$
;		  'Input file and current Xxcom have different versions.')
;		state.str.parameters = str_par
;		END
;	'FILEWRITE': BEGIN
;		ffile = pickfile(/WRITE,file='xxcom.inp')
;		if strcompress(ffile,/rem) EQ '' then GoTo,out
;		version = xxcom_version()
;		str_par = state.str.parameters
;		command = 'save,version,str_par,'+$
;		'FILENAME='+"'"+strcompress(ffile,/rem)+"'"+',/VERBOSE'
;		tmp = execute(command)
;		;itmp = widget_message(dialog_parent=event.top,$
;		;	/INFO,'File '+ffile+' written to disk.')
;		END
        'QUIT': BEGIN
		  Delete_Files,['xcom.inp','xcom.out'],Group=event.top
                  WIDGET_CONTROL,event.top,/DESTROY
		  Return
		END
	'SETDEF': BEGIN
		itmp = widget_message(dialog_parent=event.top,$
		/Question,['This option initializes the',$
		'xxcom parameters to their default values.',$
		'Then you must click Set_parameters to run the program.',$
		'Please confirm:'],title='xxcom')
		if itmp eq 'No' then goto,out
		state.str.parameters = state.str_defaults
		END
	'SETPAR': BEGIN
		str_par = state.str.parameters

		sep = sdep(/ds)
		helpcmd = "xdisplayfileNative,'"+Xop_GetEnv('XOP_HOME')+$
		  sep+'doc'+sep+"xxcom_par.txt'"
		XscrMenu,str_par,/NOTYPE,/INTERP, $
		TITLES=state.str.titles, FLAGS=state.str.flags, $
		WTITLE='Xxcom input data',ACTION=action,FIELDLEN=50, $
		HELP=helpcmd
		if action eq 'DONT' then GoTo,out
		Widget_control,/Hourglass
		state.str.parameters = str_par
		xxcom_inp_write,str_par, Group=event.top

		command = 'xcom < xcom.inp'
		Xop_Spawn,command,CleanFiles=['xcom.out']
		END
        'SHOWNUM':     BEGIN
		XDISPLAYFILE1,'xcom.out',GROUP=base, WID=80
                END
        'SHOWPLOT':     BEGIN
		coltitles = ['Photon Energy ','Coherent scat ',$
		  'Incoherent scat ','Photoel abs ',$
		  'Pair prod in nucl field ',$
		  'Pair prod in elec field ',$
		  'Tot atten with coh scat ', $
		  'Tot atten w/o coh scat ']
		if (fix(state.str.parameters.substance(0))+1) LE 2 then begin
		  ielementoutput = fix(state.str.parameters.elementoutput(0))+1
		  case ielementoutput of 
		    1: units = ['[MeV]',replicate('[b/atom]',7)]
		    2: units = ['[MeV]',replicate('[b/atom]',5), $
			replicate('[cm2/g]',2)]
		    3: units = ['[MeV]',replicate('[cm2/g]',7)]
		    else: units = replicate('?',8)
		  endcase
		endif else units = ['[MeV]',replicate('[cm2/g]',7)]
		widget_control,/hourglass
		xplot,'xcom.out',GROUP=base,WTITLE='xcom results', $
		  XTITLE='-1',YTITLE='-1',COLTITLES=coltitles+units, $
		  /XLOG,/YLOG,title=state.str.parameters.name
                END
	'Help.Xxcom':	Xhelp,'xxcom',Group=event.top
	'Help.Xcom':	BEGIN
		sep = sdep(/ds)
		hfile = Xop_GetEnv('XOP_HOME')+sep+'doc'+sep+'xcom.txt' 
		XDISPLAYFILE1,hfile,GROUP=Event.Top
		END
	else:
endcase

out:
Widget_Control, stateid, Set_Uvalue=state, /No_Copy
;
end
;
;========================================================================
;
PRO xxcom, GROUP=group, InputFile=inputFile
;
Forward_Function xop_defaults
Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=group, $
     'XXCOM: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF

if xregistered('xxcom') then return
; if not(keyword_set(group)) then xop_wd,/default

;
; widget definition
;

base=WIDGET_BASE(/COLUMN,TITLE='Xxcom '+xxcom_version(),$
	MBAR=wMenuBar)

wButtons = widget_base(base,/Column) ; also to store state

wFile = widget_button(wMenuBar,VALUE='File',/MENU)

  wtmp0 = widget_button(wFile,VALUE='Xxcom input parameters', /Menu)
    wtmp = widget_button(wtmp0,VALUE='Load from file...',UValue='FILEINPUT')
    wtmp = widget_button(wtmp0,VALUE='Save to file...',UValue='FILEINPUT')
    wtmp = widget_button(wtmp0,VALUE='Save as default',UValue='FILEINPUT')
  ;  wtmp = widget_button(wFile,VALUE='Load Xxcom input file...', $
  ;		UVALUE='FILELOAD')
  ;  wtmp = widget_button(wFile,VALUE='Write Xxcom input file...', $
  ;		UVALUE='FILEWRITE')
  wtmp = widget_button(wFile,VALUE='Quit', UVALUE='QUIT',/SEPARATOR)

wSetParameters = widget_button(wMenuBar,VALUE='Set_Parameters', /MENU)
  wtmp = widget_button(wSetParameters,VALUE='Set Parameters', UVALUE='SETPAR')
  wtmp = widget_button(wSetParameters,VALUE='Set Defaults', UVALUE='SETDEF')

wResults = widget_button(wMenuBar,VALUE='Show',/MENU)
  wtmp = widget_button(wResults,VALUE='Plot Data.', UVALUE='SHOWPLOT')
  wtmp = widget_button(wResults,VALUE='Numerical Data.', UVALUE='SHOWNUM')

wHelp = widget_button(wMenuBar,VALUE='Help', /Help)
  wtmp = widget_button(wHelp,VALUE='Xxcom', UVALUE='Help.Xxcom')
  wtmp = widget_button(wHelp,VALUE='xcom', UVALUE='Help.Xcom')
;
wtmp = widget_button(BASE,VALUE='Set Parameters', UVALUE='SETPAR')

if sdep() EQ 'WINDOWS' then font = 'VERDANA*BOLD*ITALIC*24' else $
  font = '-adobe-helvetica-bold-o-normal--18-180-75-75-p-104-iso8859-1'

wtmp = WIDGET_LABEL( BASE, FONT=font, VALUE=' Xxcom')
wtmp = WIDGET_LABEL( BASE, FONT=font, VALUE='   Photon Cross Sections   ')


str = xop_defaults('xxcom')
str_defaults = str.parameters


IF KeyWord_Set(inputFile) THEN BEGIN
  str_par = Xop_Input_Load(InputFile=inputFile)
  IF Type(str_par) EQ 8 THEN BEGIN
    tmp = str.parameters
    Copy_Structure,str_par, tmp, Group=group
    str.parameters = tmp
  ENDIF
ENDIF


wids = {dummy:0L}
state = { str:str, str_defaults:str_defaults,  wids:wids}
;
;actions
;
Widget_control,Widget_Info(base,/Child),Set_uvalue=state,/No_Copy
Widget_control,base,/Realize
Xmanager,'xxcom',base,Group_leader=group
;
end

