function crystal_bent_theories,entry,names=nam

;+
; NAME:
;	CRYSTAL_BENT_THEORY
;
; PURPOSE:
;	returns the information in the file:
;	$XOP_IFC/crystal_bent_theories.dat (when $XOP_IFC is set) or
;	$XOP_HOME/ifc/crystal_bent_theories.dat. (default)
;	The purpose of this function is to extract at run time the name of 
;	the codes and their description to be used in xop/xcrystal_bent
;	The reason of the existence of this function is to allow to add
;	more code modules after the embedding.
;
;	This function is only called by xop_defaults()
;
; CATEGORY:
;	Xop application. Used by xcrystal_bent.pro.
;
; CALLING SEQUENCE:
;
;	inp = crystal_bent_theories([entry,/name])
;
; OPTIONAL INPUTS:
;	entry: the entry index (starting at 0) of the value to be
;	returned. If this input is not present, the function returns all 
;	the array.
;	
; KEYWORD PARAMETERS:
;	NAME: when set, it retutns the theory name, otherwise returns 
;		the code name.
;
; OUTPUTS:
;	An array with the required information.
;
; PROCEDURE:
;	Straightforward.
;
;
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio  97/01/03
;	97/10/08 srio@esrf.fr include the XOP_IFC directory in the search.
;		Uses sdep().
;	97/11/07 srio@esrf.fr reads dat file from $XOP_HOME/ifc (not longer
;		$XOP_HOME/data)
;-

on_error,2
tmp = ''
names = ''
codes = ''

sep = sdep(/ds)
if Xop_GetEnv('XOP_IFC') ne '' then begin
  file = Xop_GetEnv('XOP_IFC')+sep
endif else begin
  file = Xop_GetEnv('XOP_HOME')+sep+'ifc'+sep
endelse

if (sdep() EQ 'WINDOWS' and sdep(/vs) EQ '4')then $
  file = file+'crysta~1.dat' else $
  file = file+'crystal_bent_theories.dat'

if not(checkfile(file)) then begin
  message,'file '+file+' not found.'
  return,0
endif

openr,unit,file,/Get_lun
for i=0,14 do readf,unit,tmp
readf,unit,names
readf,unit,codes
while not eof(unit) do begin
  readf,unit,tmp
  names = [names,tmp]
  readf,unit,tmp
  codes = [codes,tmp]
endwhile
free_lun,unit

if n_params() ne 0 then begin
  if entry gt n_elements(codes)-1 then begin
    message,'Wrong entry'
    return,0
  endif
  codes = codes(entry)
  names = names(entry)
endif
if keyword_set(nam) then return,names else return,codes
end

