FUNCTION VECT2STRING,a,_extra=extra,NoCompress=noCompress
;+
;
; NAME:
;       VECT2STRING
;
; PURPOSE:
;       This function returns a string with the input array formatted
;	in the IDL style (e.g., [3,2,4,9])
;
; CATEGORY:
;       Utilities
;
; CALLING SEQUENCE:
;       result = Vect2String(input)
;
; INPUTS:
;       A vector array
;
; KEYWORD PARAMETERS:
;	NoCompress: flat to avoid removing trailing blanks in the output
;	Any other keyword  is passed to the "String" function.
;
; OUTPUTS:
;       An string with the formatted vector
;
; PROCEDURE:
;	Use IDL String function. 
;
; EXAMPLE:
;	IDL> a = [4.9,5]
;	IDL> print,vect2String(a)
;	[4.90000,5.00000]
;	IDL> print,vect2String(a,Format='(G3.1)')
;	[5.,5.]
;	IDL> print,vect2String(a,Format='(G3.1)',/NoCompress)
;	[ 5., 5.]
;
; MODIFICATION HISTORY:
;       Written by:     Manuel Sanchez del Rio
;	2002-09-30 srio@esrf.fr added _extra kw to pass parameters to String
;		   Added doc.
;
;-

; FUNCTION VECT2STRING,a
;
; srio@esrf.fr
dum = size(a)
type =  dum(dum(0) + 1)
nelem = n_elements(a)

result = '['
if type EQ 7 then begin   ; string case
  for i=0,nelem-2 do begin
     result = result  + "'" +  a(i) + "'" +  ','
  endfor
  result = result  + "'" + a(nelem-1) + "'" + ']'
endif else begin         ; numerical case
  for i=0,nelem-2 do begin
     result = result  + string(a(i),_extra=extra) + ','
  endfor
  result = result  + string(a(nelem-1),_extra=extra) + ']'
endelse
;
IF Keyword_Set(noCompress) THEN Return,result ELSE $
				Return,StrCompress(result,/Rem)

END
