pro covar_fit,x,y,a,equation, sigma=sigma,statsigma=statsigma, $
outsigma=outsigma,covar=covar,double=idouble
;+
;
;	NAME:
;		COVAR_FIT
;	PURPOSE:
;		to calculate the covariance matrix of a fit
;	CALLING SEQUENCE:
;		COVAR_FIT,x,y,a,equation
;	INPUT PARAMETERS:
;		X = X array of data
;		Y = Y array of data
;		A = array with fit parameters
;		equation: a string text with the f(x;a) equation
;	OPTIONAL INPUT PARAMETERS:
;	KEYWORD PARAMETERS:
;		Inputs:
;		SIGMA = array with sigma values of Y points
;		STATSIGMA = when set to 1, then takes 
;		sigma = sqrt(yfit) (statistical error)
;		Outputs:
;		COVAR = the covariance matrix
;		OUTSIGMA = the sigma velues for the fitting parameters
;			(i.e the sqrt of the covar matrix diagonal)
;		DOUBLE = forces calculation in double precision.
;	OUTPUTS:
;		Prints the results on the screen
;	COMMON BLOCKS:
;		None.
;	SIDE EFFECTS:
;
;	RESTRICTIONS:
;		Unknown.
;	PROCEDURE:
;		calculates the numerical derivatives of the function
;		respect each parameter, and then calculate COVAR
;		(taken fron the curvefit.pro version of Amara Graps
;		agraps@netcom.com)
;	EXAMPLE: 
;
;	covar_fit,xx,yy,aa,'a(0)/(a(1)^2+(x-a(2))^2)'
;
;	MODIFICATION HISTORY:
;       by  Manuel Sanchez del Rio. ESRF. 95-03-16
;	97/10/21 srio@esrf.fr adds /double kw.
;	99/03/04 srio@esrf.fr allows naming the parameter either A or P.
;
;-
;
on_error,2
x=reform(x)
y=reform(y)

t = size(a)
double=0
if keyword_set(idouble) then double = 1 
if (t(n_elements(t)-2) eq 5) then double=1 

; be sure everything is double
if double EQ 1 then begin
 x=double(x) 
 y=double(y) 
 a=double(a) 
 if keyword_set(sigma) then sigma=double(sigma)
endif

if n_params() ne 4 then  begin
  print,'COVAR_FIT: Usage:  covar_fit,x,y,a,equation
  return
endif

p=a
error = not(execute('yfit = '+equation) )
if error then begin
  print,'COVAR_FIT: Error interpreting equation'
  return
endif 
;
; calculate the numerical derivative
;
res = nr_machar(double=double)
eps=sqrt(res.eps)
nterms = n_elements(a)
if double EQ 1 then pder = dblarr(n_elements(x), nterms) else $
	pder = fltarr(n_elements(x), nterms)

a_old = a
for term=0, nterms-1 do begin
  p = a_old       ; Copy current parameters
  ; Increment size for forward difference derivative
  inc = eps * abs(p(term))
  if (inc eq 0.) then inc = eps
  p(term) = p(term) + inc
  a = p
  error = not(execute('yfit1 = '+equation) )
  if error then begin
    print,'COVAR_FIT: Error interpreting equation'
    return
  endif 
  pder(0,term) = (yfit1-yfit)/inc
endfor
a=a_old
;
; define sigma
;
if not(keyword_set(sigma)) then sigma = x*0+1 else sigma=reform(sigma)
if keyword_set(statsigma) then sigma=sqrt(yfit)
w=1./sigma^2
;help,w
;help,sigma
;
; calculate covariances
;
diag = indgen(nterms)*(nterms+1) ; Subscripts of diagonal elements
alpha = transpose(pder) # (w # (fltarr(nterms)+1)*pder)
covar=invert(alpha)
outsigma=sqrt(covar(diag))
print,'***********************   covariance results *******************'
if double then print,'Double precission used.'
if keyword_set(statsigma) then  print,'Statistical sigma weight used.'
print,'equation: ',equation
print,'parameters: ',a
print,'sigmas : ',outsigma
print,'covariance matrix: '
print,covar
print,'*******************  end  covariance results *******************'
END
