PRO copy_structure,str_in,str_out,OnlyFirstField=onlyFirstField, $
  Group=group

;+
; NAME:
;	COPY_STRUCTURE
;
; PURPOSE:
;	This procedures copies whith the same tag-names the tags from 
;	an input-structure to an output-structure.
;
; CATEGORY:
;	General utilities.
;
; CALLING SEQUENCE:
;
;	copy_structure,str_in,str_out
;
; INPUTS:
;	str_in: the input structure
;	str_out: the output structure
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;	onlyFirstField: When this keyword is set, and a tag is
;		of StrArr type, in this case copy only the 
;		first field of the StrArr variable. 
;		This optionis used to read XOP/DABAX input files 
;		which may contain a variable number of items in 
;		the StrArr variable and only the first field
;		(selected index) is important.
;	Group: The widget id of the called. Used for centering the 
;		Dialog_Message window in case of error messages.
;		
;
; OUTPUTS:
;	The modified structure
;
; SIDE EFFECTS:
;
; PROCEDURE:
;	Straightforward.
;
; EXAMPLE:
;	a={x:10,y:90} & c={x:10, y:0, z:80}
;	copy_structure,a,c
;	help,/str,c
;	** Structure <31fc30>, 3 tags, length=6, refs=1:
;	   X               INT             10
;	   Y               INT             90
;	   Z               INT             80
;
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio (srio@esrf.fr) 97-04-07
;	97-08-27 srio@esrf.fr make the copy recurrent (a tag type can
;		also be a structure).
;	98-11-24 srio@esrf.fr adds the onlyFirstField and Group keywords.
;		Uses Catch.
;	98-12-10 srio@esrf.fr bug fixed with onlyFirstField
;	
;-

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   IF SDep(/W) THEN itmp = Dialog_Message(Dialog_Parent=group, $
   /Error,'COPY_STRUCTURE: error caught: '+!err_string)
   catch, /cancel
   on_error,2
   RETURN
endif

if type(str_in) NE 8 or type(str_out) ne 8 then begin
  message,/info,'Error: An input parameter is not an structure.  Quitting.'
  return
endif

tmp=0
tmp_out=0
showErrorFlag=1

tagnames = tag_names(str_in)
for i=0,n_elements(tagnames)-1 do begin
  command = ' tmp = str_in.'+tagnames(i)
  itmp = execute(command)
  if itmp NE 1 then message,/info,'Error in executing: '+command
  if type(tmp) EQ 8 then begin   ; the tag is a structure
    command = ' tmp_out = str_out.'+tagnames(i)
    itmp = execute(command)
    if itmp NE 1 then message,/info,'Error in executing: '+command
    copy_structure,tmp,tmp_out
    command = ' str_out.'+tagnames(i)+' = tmp_out'
    itmp = execute(command)
    if itmp NE 1 then message,/info,'Error in executing: '+command
  endif else begin
    IF ( (Keyword_Set(onlyFirstField) EQ 1) AND (Type(tmp) EQ 7) $
      AND (N_Elements(tmp) GT 1) ) THEN  BEGIN
      tmp1=0
      command = ' tmp1 = str_out.'+tagnames(i)
      itmp = execute(command)
      nval = StrCompress(fix(tmp[0]) < (N_Elements(tmp1)-2) > 0,/Rem)
      command = 'str_out.'+tagnames(i)+'[0] = '+nval
      ENDIF $
      ELSE command = 'str_out.'+tagnames(i)+' = str_in.'+tagnames(i)
    itmp = execute(command)
    IF itmp NE 1 THEN BEGIN
       message,/info,'Error copying stucture tag: '+tagnames(i)
       IF showErrorFlag EQ 1 THEN BEGIN
	itmp = Dialog_Message(/Question,Dialog_Parent=group,$
	  ['COPY_STRUCTURE: Error copying stucture tag: '+tagnames(i),$
	   ' ','Do you want see next error messages?'])
	IF itmp EQ 'No' THEN showErrorFlag=0
       ENDIF
    ENDIF
  endelse
endfor
end

