FUNCTION sync_ang,flag,angle_mrad,Pol=pol,  $
  E_GeV=e_gev,I_A=i_a,HDiv_mrad=hdiv_mrad,R_M=R_M,Energy=energy,EC_eV=ec_eV

;+
; NAME:
;       SYNC_ANG
;
; PURPOSE:
;       Calculates the synchrotron radiation angular distribution
;
; CATEGORY:
;       Mathematics.
;
; CALLING SEQUENCE:
;       Result = sync_angle(flag, angle )
;
; INPUTS:
;	flag: 	0 Flux fully integrated in photon energy
;		1 Flux at a given photon energy
;       amgle:  the angle array [in mrad]
;
; KEYWORD PARAMETERS:
;	POLARIZATION: 0 Total 
;		      1 Parallel       (l2=1, l3=0, in Sokolov&Ternov notation)
;		      2 Perpendicular  (l2=0, l3=1)
;
;	IF FLAG=0 THE FOLLOWING KEYWORDS MUST BE ENTERED
;		E_GeV= The electron energy [in GeV] 
;		I_A= the electron beam intensity [in A]
;		HDiv_mrad= the horizontal divergence [in mrad]
;		R_M= the bending magnet radius [in m]
;
;	IF FLAG=1 THE FOLLOWING KEYWORDS MUST BE ENTERED
;		All keyworsd for FLAG=0 plus:
;		Energy = the energy value [in eV]
;		EC_eV= The critical energy [eV]
;
; OUTPUTS:
;       returns the array with the flux [photons/sec/0.1%bw]
;
; PROCEDURE:
;
;	References: 
;		G K Green, "Spectra and optics of synchrotron radiation" 
;			BNL 50522 report (1976)
;		A A Sokolov and I M Ternov, Synchrotron Radiation, 
;			Akademik-Verlag, Berlin, 1968
;
; MODIFICATION HISTORY:
;       Written by:     M. Sanchez del Rio, srio@esrf.fr, 2002-06-03
;
;-

CASE Fix(flag) OF
  0: BEGIN ; fully integrated in photon energy
	; numerical cte 
        a8 = 3d10*physical_constants('c')*physical_constants('ec')/ $
	  (physical_constants('mee'))^5 ; 41.357
	gamma = E_GEV*1d3/Physical_Constants('MEE')
	a5 = sync_f(angle_mrad*gamma/1d3,Pol=pol)*a8*i_A*hDiv_mrad/R_M*(e_gEv)^5
	END
  1: BEGIN ; at photon = cte
	a8 = physical_constants('ec')/(physical_constants('mee'))^2/ $
	  physical_constants('h')*(9d-2/2/!dpi) ; 1.3264d13
	eene = Double(energy)/Double(ec_ev)
	gamma = E_GEV*1d3/Physical_Constants('MEE')
	a5=sync_f(angle_mrad*gamma/1d3,eene,Pol=pol)*(eene)^2* $
	  a8*i_A*hDiv_mrad*(e_gev)^2
	END
ENDCASE

RETURN, a5
END
