PRO bragg_out,str
;

; 
; European Synchrotron Radiation Facility (ESRF)
;+
; NAME:
;       BRAGG_OUT
;
; PURPOSE:
;	Writes the structure returned by bragg_calc to a disk file.
;	
; CATEGORY:
;       X-Ray optics.
;
; CALLING SEQUENCE:
;	bragg_out,str
; INPUTS:
;	str: the structure with the data to be written down.
;	
; KEYWORDS:
;
; OUTPUT:
;	A disk file (str.outfil)
;
; PROCEDURE:
;
; EXAMPLE:
;	str = dabax_defaults('bragg')
;	str1 = bragg_calc(str)
;	bragg_out,str1
;
; SEE ALSO:
;       bragg_calc, bragg_inp, dabax_defaults.
;
; MODIFICATION HISTORY:
;       96-07-10 Written by M. Sanchez del Rio (srio@esrf.fr)
;       96-12-19 srio@esrf.fr, Change the format for the f0coefficients to
;		allow reading CromerMann data (9 coeffs) and Waasmaier
;		and Kirfel data (11).
;-
on_error,2
;
; Now prepare the file for SHADOW.
;
outfil = str.outfil
RN = str.rn
d_spacing = str.d_spacing
nbatom = str.nbatom
atnum = str.atnum
fract = str.fract
temper = str.temper
G_0 = str.G_0
G = str.G
G_BAR = str.G_BAR
f0coeff = str.f0coeff
NPOINT = str.NPOINT
energy = str.ENERGY
f1 = str.f1
f2 = str.f2

        OPENW,UnitOut,OUTFIL,/get_lun
        printf,UnitOut,  '# Bragg version, Data file type'
        printf,UnitOut,  '2.2 1'
        printf,UnitOut,  '# RN = (e^2/(m c^2))/V) [cm^-2], d spacing [cm]'
        printf,UnitOut,  RN,D_SPACING 
        printf,UnitOut,  '# Number of different element-sites in unit cell NBATOM:'
        printf,UnitOut,  nbatom
        printf,UnitOut, '# for each element-site, the atomic number'
        printf,UnitOut,  ATNUM 
        printf,UnitOut, '# for each element-site, the occupation factor'
	printf,UnitOut,FRACT

        printf,UnitOut, '# for each element-site, the temperature factor'
	printf,UnitOut, TEMPER 

        printf,UnitOut,  '# for each type of element-site, COOR_NR=G_0'
	printf,UnitOut,G_0

        printf,UnitOut,  '# for each type of element-site, G and G_BAR (both complex)'
	for i=0,nbatom-1 do begin
          printf,UnitOut,  G(I)
          printf,UnitOut,  G_BAR(I)
	endfor
        printf,UnitOut, '# for each type of element-site, the number of f0 coefficients followed by them'
	ncoe = n_elements(f0coeff(0,*))
	format = '(I2,X,'+string(ncoe)+'(G12.6," "))'
	for i=0,nbatom-1 do printf,UnitOut,format=format,ncoe,f0coeff(i,*)
        printf,UnitOut,  '# The number of energy points NPOINT: '
        printf,UnitOut, NPOINT
	printf,UnitOut, '# for each energy point, energy, F1(1),F2(1),...,'+$
		'F1(nbatom),F2(nbatom)'

        FOR I = 0, NPOINT-1 DO BEGIN
          printf,UnitOut,  energy(i)
	  for j=0,nbatom-1 do begin
	    printf,UnitOut,  F1(j,i),F2(j,i)
	  endfor
	ENDFOR
        message,/info,'File '+OUTFIL+' written to disk.'
	free_lun,UnitOut
end

