FUNCTION RandomU1, ixx, d1,d2


;+
; NAME:
;	RANDOMU1
;
; PURPOSE:
;       This function returns one or more uniformly-distributed,
;	floating-point, pseudo-random numbers in the range 0 < Y <1.0.
;	(Note: this routine has similar and more limited functionality
;	than the IDL's RANDOMU routine. However, it allows one to fix
;	the seed (i.e., correctly initialize it). )
;
; CATEGORY:
;	Mathematics
;
; CALLING SEQUENCE:
;       Result = RandomU1( [seed, d1, d2] )
;
; OPTIONAL INPUTS:
;       
;	Seed: A long integer used to initialize the random number generator. 
;		You can use Seed to start the sequence. If Seed is a named 
;		variable, RANDOMU1 update it to the next long integer in 
;		the sequence. To generate a random seed from the system time, 
;		set Seed equal to either zero or to an undefined named variable.
;
;	d1,d2: The dimensions of the result. The dimension parameters can 
;		be any scalar expression. Up to TWO dimensions can be specified.
;		If no dimensions are specified, it sets d1=d2=1 (default)
;
; OUTPUTS:
;       This function return the pseudo-random number.
;
; PROCEDURE:
;       
;       I have taken this random number generator from the default EGS4
;	program and documentation (http://ehssun.lbl.gov/egs/egs.html)
;	
;	Initialization: ixx = seed (USE AN ODD NUMBER!!!)
;	Iteration: 
;	  IXX=IXX*663608941 
;	  R =0.5 + IXX*0.23283064E-09
;
;	This random number generator works well in any 32-bit machine
;	and the cycle is about 2^30.
;
;	It is obvious that this procedure is much slower than the 
;	"compiled-in" RandomU.
;
; EXAMPLE:
;       print,RandomU1()
;	0.728027 (or any other number)
;	print,randomu1(1L,5)
;	0.654508     0.481739     0.851256     0.325832    0.0432754
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio (srio@esrf.fr), 98-12-21
;
;-

On_Error,2
IF Keyword_Set(ixx) EQ 0 THEN ixx=Long(SysTime(1))
IF N_Elements(d1) EQ 0 THEN d1=1L
IF N_Elements(d2) EQ 0 THEN d2=1L
out = FltArr(d1*d2)
FOR i=0L,(d1*d2)-1 DO BEGIN
  IXX=IXX*663608941 
  out[i]=0.5 + IXX*0.23283064E-09
ENDFOR
IF d2 EQ 1 THEN out1 = Reform(out,d1) ELSE out1 = Reform(out,d1,d2)
RETURN,out1
END

