
FUNCTION getsysprinter,VERBOSE=verbose
;+
; NAME:
;	GETSYSPRINTER
;
; PURPOSE:
;	This function returns the printer default printer, which
;	is defined in the environment variable $PRINTER or $LPDEST
;
; CATEGORY:
;	General utilities.
;
; CALLING SEQUENCE:
;
;	PrinterName = getsysprinter()
;
; INPUTS:
;	None
;
; KEYWORD PARAMETERS:
;	VERBOSE: when set, display the system call message.
;
; OUTPUTS:
;	The Printer name (string)
;
; PROCEDURE:
;	Straightforward
;
; EXAMPLE:
;
;		Name = getsysprinter()
; LIMITATIONS:
;	Initially set for hp and sun machines. Please update for others
;	and tell me (srio@esrf.fr)
;
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio.
;	January 17, 1996	
;	96/07/10 MSR (srio@esrf.fr) changes spawn by getsys().
;	96/11/0 MSR (srio@esrf.fr) includes (and modify) change from R.  Dejus:
;       	96-05-20 RJD, added DEC AXP alpha (note: string is case 
;		sensitive).
;-
on_error,2
;
  CASE !version.os OF
    'hp-ux': PrinterName = getenv('LPDEST')
    'sunos': PrinterName = getenv('PRINTER')
    'OSF': PrinterName = getenv('PRINTER')
    else: PrinterName=getenv('PRINTER')
  ENDCASE
return,PrinterName
end
