;+
;=================================   xcrystal   ================================
;
;
;   Xcrystal is a widget based graphical interface to calculate diffraction
;   profiles of perfect and mosaic crystals. It allows Bragg and Laue
;   geometries and (in the case of perfect crystals) diffracted and
;   transmitted intensity calculations.  The diffracted intensity can be
;   calculated as a function of either rock angle or photon energy.
;   It uses the DABAX database to define the crystal structure and to 
;   retrieve the scattering factors to build the crystal structure factors.
;
;   It interfaces diff_pat, a computer program written by M. Sanchez del Rio
;   (srio@esrf.fr) derived from the SHADOW application bragg.
;
;
; DESCRIPTION OF THE CONTROLS IN THE MAIN WINDOW:
;
;  File:
;    Xcrystal input parameters: This option allows to save the current
;		parameters to a file for later loading. It also allows
;		to save the current parameters as defaults for being
;		used when the application is initialized. In the last
;		case, the file is named "application".xop (where 
;		"application " is the name of the current XOP
;		application) and is written in the directory pointed
;		by the XOP_DEFAULTS_DIR environment variable (which
;		must be set). The parameter file is ASCII and can be
;		read and edited with care.
;  Quit: to exit from the program
;
; Set_Parameters:
;  Set Parameters: to define the parameters for the calculation.
;		The same result is obtained pressing the "Set Parameters"
;		button in the main XCrystal window. 
;               Please refer to the information under the HELP
;		button for a complete description of the parameters. After 
;		pressing the ACCEPT button, diff_pat starts running.
;  Set Defaults: Sets the default parameters.
;
;  Show: Display results
;   Diffraction Curve: starts a graphical window with the calculation results.
;   Crystal Parameters: shows output parameters of the calculation.
;   Crystallographic Parameters: shows numerical values used to build the 
;		crystal structure factor.
;
;  Help:   Shows the xcrystal help (this text).
;
;
; COPYRIGHT:
;	xcrystal  belongs to XOP package and it is distributed within XOP.
;	PLEASE REFER TO THE XOP COPYRIGHT NOTICE BEFORE USING IT.
;
; CREDITS:
;	Published calculations made with XOP should refer:
;
;	  M. Sanchez del Rio and R. J. Dejus "XOP: Recent Developments"
;	  SPIE proceedings vol. 3448, pp.340-345, 1998.
;
;	In addition, published calculations with the xcrystal_bent aplication 
;	should also cite:
;	  M. Sanchez del Rio, C. Ferrero and V. Mocella. 
;	  "Computer simulations of bent perfect crystal diffraction profiles" 
;	  SPIE proceedings vol. 3151, pp.312-323, 1997. 
;
; LAST MODIFICATION: msr/msr/99-03-16
;
;-
; ----------------------------------------------------------------------
;
;       Modification history:
;		97/01/03 srio@esrf.fr creates the initial version.
;			This version obsoletes xreflex and xpenpol.
;		97/01/21 srio@esrf.fr adapts for Windows95.
;		97/10/07 srio@esrf.fr version for xop 1.9, now v 1.1
;			Many bugs and cosmetic fixes. 
;		98/12/10 srio@esrf.fr version for xop 2.0, now v 1.2
;		99/03/16 srio@esrf.fr updates doc.
;-
;
;========================================================================
;
FUNCTION XCRYSTAL_version
return,'1.2'
end
;		
;========================================================================
;
PRO XCrystal_Inp_Write,state, Group=group


Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=group, $
     'XCRYSTAL_INP_WRITE: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF
;
; write the contents of the structure with parameters for running reflex
;
inp = state.str.parameters
name='xcrystal.inp'
;
Openw,unit,name,/GET_LUN
;
;
Printf,unit,state.str.bragg.parameters.outfil
Printf,unit,inp.mosaic(0)

Printf,unit,state.str.parameters.geometry(0)

if strcompress(inp.mosaic(0),/rem) EQ 0 then begin ; perfect
  Printf,unit,StrCompress(state.str.parameters.Thickness,/Remove_All)
  Printf,unit,StrCompress(state.str.parameters.asymmetry_angle,/Remove_All)
endif else begin  ; mosaic
  Printf,unit,StrCompress(state.str.parameters.Mosaic_fwhm,/Remove_All)
  Printf,unit,StrCompress(state.str.parameters.Thickness,/Remove_All)
endelse

scanFlag= 1+fix(state.str.parameters.scan(0))
Printf,unit,StrCompress(scanFlag)

;Printf,unit,StrCompress(state.str.parameters.Energy,/Remove_All)
Printf,unit,StrCompress(string(state.str.parameters.Energy,$
  Format='(F16.9)'),/Remove_All)

if scanFlag LE 3 then $
  Printf,unit,StrCompress(state.str.parameters.Unit(0),/Remove_All)
;
Printf,unit,StrCompress(state.str.parameters.ScanFrom,/Remove_All)
Printf,unit,StrCompress(state.str.parameters.ScanTo,/Remove_All)
Printf,unit,StrCompress(state.str.parameters.ScanPoints,/Remove_All)
;
Free_Lun,unit
;
END
;=======================================================================
;
PRO Xcrystal_EVENT,event


Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=event.top, $
     'XCRYSTAL_EVENT: error caught: '+!err_string)
   Catch, /Cancel
   If Type(stateid) EQ 3 THEN $
     If Widget_Info(stateid,/Valid_Id) AND N_Elements(state) NE 0 THEN $
     Widget_Control,stateid,Set_UValue=state,/No_Copy
   On_Error,2
   RETURN
ENDIF
;
; register the events
;
Widget_control, event.id, Get_uvalue=eventuval

stateid = Widget_Info(event.handler,/Child)
Widget_control, stateid,  Get_uvalue=state,/No_Copy

;inp = state.str

CASE eventuval OF

       'FILEINPUT': BEGIN
         action=''
         Widget_Control,event.id, Get_Value=action
         CASE action OF
           'Load from file...': BEGIN
             ;if sdep() EQ 'UNIX' then filter='*.xop' else filter=0
	     filter='*.xop'
             str_par = Xop_Input_Load(Title=$
             'Select Xcrystal input file...',$
             /NoConf,Filter=filter,Group=event.top)
             IF Type(str_par) EQ 8 THEN BEGIN
               tmp = state.str.parameters
               Copy_Structure,str_par, tmp, Group=event.top ; , /OnlyFirstField
               state.str.parameters = tmp
             ENDIF
           END
           'Save to file...': BEGIN
             str_par = state.str.parameters
             Xop_Input_Save,str_par,File='xcrystal.xop',$
               /Write, Group=event.top, Comment='; xop/xcrystal(v'+$
             xcrystal_version()+') input file on '+SysTime()
           END
           'Save as default': BEGIN
             str_par = state.str.parameters
             Xop_Input_Save,str_par,Group=event.top, $
               Default='xcrystal.xop',Comment='; xop/xcrystal(v'+$
             xcrystal_version()+') input file on '+SysTime()
           END
         ENDCASE
       END


;	'FILELOAD': BEGIN
;		if sdep() eq 'UNIX' then filter='*.inp' else filter=0
;		ffile = pickfile(title='Select Xcrystal input file...',$
;		/NOCONF,FILTER=filter)
;		if strcompress(ffile,/rem) EQ '' then GoTo,out
;		version = 0
;		restore,ffile,/VERBOSE
;		if version NE xcrystal_version() then $
;		  itmp = Dialog_Message(dialog_parent=event.top,$
;		 	'Input file and current '+$
;		  	'Xcrystal have different versions.')
;		state.str.parameters = str_par
;		END
;	'FILEWRITE': BEGIN
;		ffile = pickfile(/WRITE,file='xcrystal.inp')
;		if strcompress(ffile,/rem) EQ '' then GoTo,out
;		version = xcrystal_version()
;		str_par = state.str.parameters
;		command = 'save,version,str_par,'+$
;		'FILENAME='+"'"+strcompress(ffile,/rem)+"'"+',/VERBOSE'
;		tmp = execute(command)
;		itmp = Dialog_Message(dialog_parent=event.top,$
;			/INFO,'File '+ffile+' written to disk.')
;		END
	'QUIT': BEGIN
		files = ['xcrystal.bra','diff_pat.dat','diff_pat.par', $
		  'xcrystal.inp'] 
		Delete_Files,files,Group=event.top
		Widget_control,event.top,/Destroy
		RETURN
		END
	'SETDEF': BEGIN
		itmp = Dialog_Message(dialog_parent=event.top,$
		  /Question,['This option initializes the',$
		  'xcrystal parameters to their default values.',$
		  'Then you must click Set_parameters to run the program.',$
		  'Please confirm'],title='xcrystal')
		if itmp eq 'No' then goto,out
		;tmp = xop_defaults('xcrystal')
		state.str.parameters = state.str_defaults
		END
	'SETPAR': BEGIN
		str_par = state.str.parameters

		sep = sdep(/ds)
                helpcmd = "xdisplayfileNative,'"+Xop_GetEnv('XOP_HOME')+$
                  sep+'doc'+sep+"xcrystal_par.txt'"
		Xscrmenu,str_par,Group=event.top,Ncol=3,Action=action,$
		Titles=state.str.titles, Flags=state.str.flags, $
		/NoType, /Interp, Wtitle='Xcrystal input parameters',$
		help=helpcmd
		IF (action EQ 'DONT') THEN Goto,out
		; test for correct laue setting
		IF (Fix((str_par.geometry)[0]) EQ 1 OR $ ; Laue
		    Fix((str_par.geometry)[0]) EQ 3) AND $ ; Laue
		   str_par.asymmetry_angle EQ 0 THEN BEGIN
		   itmp = Dialog_Message(Dialog_Parent=event.top,/Question, $
			['In xcrystal the asymmetry angle is the angle',$
			'between Bragg planes and crystal surface, ',$
			'in BOTH Bragg and Laue geometries.','',$
			'It seems you want to use Laue-symmetrical ',$
			'configuration so the asymmetry angle must be',$
			'90 deg instead of 0','Correct it?'])
		   IF itmp EQ 'Yes' THEN str_par.asymmetry_angle=90.0 
		ENDIF


		Widget_control,/Hourglass
		state.str.parameters = str_par
		Xcrystal_Inp_Write,state, Group=event.top
		; bragg
		strbragg = state.str.bragg
		strbragg.parameters.filef0 = str_par.filef0
		strbragg.parameters.filef1f2 = str_par.filef1f2
		if strcompress(str_par.Scan(0),/rem) EQ '3' then begin 
							; energy scan
		  strbragg.parameters.estep = $
			(str_par.ScanTo-str_par.ScanFrom)/100
		  strbragg.parameters.emin = str_par.ScanFrom -1 
		  strbragg.parameters.emax = $
			str_par.ScanTo + strbragg.parameters.estep + 1
		endif else begin
		  strbragg.parameters.emin = str_par.energy - $
			state.str.energy_shift
		  strbragg.parameters.emax = str_par.energy + $
			state.str.energy_shift
		  strbragg.parameters.estep = state.str.energy_step
		endelse
		strbragg.parameters.ilattice = str_par.Crystal_material
		strbragg.parameters.hmiller = str_par.Miller_index_h
		strbragg.parameters.kmiller = str_par.Miller_index_k
		strbragg.parameters.lmiller = str_par.Miller_index_l
		strbragg.parameters.i_absorp = str_par.i_absorp
		strbragg.parameters.temper = str_par.temper
		Message,/Info,'Running bragg_calc'
		tmp = bragg_calc(strbragg)
		Message,/Info,'Writing results (bragg_out)'
		bragg_out,tmp
		command = 'diff_pat < xcrystal.inp'
		Xop_Spawn,command, CleanFiles=['diff_pat.par','diff_pat.dat']
		END
        'HELP': Xhelp,'xcrystal',Group=event.top
	'SHOW':	BEGIN
		WIDGET_CONTROL,event.id,GET_VALUE=eventval
		root='diff_pat' 
		ffile = root+'.dat'
		size_inp = SIZE(state.str.parameters)
		IF (checkfile(ffile) EQ 0 OR  size_inp(1) EQ 0) THEN BEGIN
		  message,/info,'File not found. '
		  itmp = Dialog_Message(dialog_parent=event.top,$
			/ERROR,['Crystal data file not found...',$ 
			'Set Parameters before...  '])
		  Goto,Out
		ENDIF 
		  title='Crystal '+xcrystal_version()+' '+ $
state.str.parameters.Crystal_material( fix(strcompress(state.str.parameters.Crystal_material(0),/rem)) + 1) +$
' '+STRCOMPRESS(state.str.parameters.Miller_index_h,/REM)+STRCOMPRESS(state.str.parameters.Miller_index_k,/REM)+STRCOMPRESS(state.str.parameters.Miller_index_l,/REM)+' E='+STRCOMPRESS(state.str.parameters.Energy,/REM)+' eV, t='+STRCOMPRESS(state.str.parameters.Thickness,/REM)+' cm'
		  CASE eventval OF
		  "Diffraction curve": $
			XPLOT,SPEC=root+'.dat',$
			wtitle='xcrystal results', TITLE=title,GROUP=event.top,$
			xtitle='-1',ytitle='-1'
		  "Crystal Parameters":XDisplayFile1,root+'.par',Group=event.top
		  "Crystallographic Parameters":XdisplayFile1,$
		     state.str.bragg.parameters.outfil,Group=event.top
		  else: message,/info,'case item not found'
		  ENDCASE
		  END  ;END SHOW
  ENDCASE
out:
Widget_Control, stateid, Set_Uvalue=state, /No_Copy
END
;
;==============================================================================
;
PRO Xcrystal, GROUP=group, InputFile=inputFile

Forward_Function xop_defaults

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=group, $
     'XCRYSTAL: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF

if xregistered('xcrystal') gt 1 then return
; if not(keyword_set(group)) then xop_wd,/default
;
; widget definition
;

base=WIDGET_BASE(/COLUMN,TITLE='Xcrystal '+xcrystal_version(),$
	MBAR=wMenuBar)

wButtons = widget_base(base,/Column) ; also to store state

wFile = widget_button(wMenuBar,VALUE='File',/MENU)
;  wtmp = widget_button(wFile,VALUE='Load Xcrystal input file...', $
;		UVALUE='FILELOAD')
;  wtmp = widget_button(wFile,VALUE='Write Xcrystal input file...', $
;		UVALUE='FILEWRITE')

  wtmp0 = widget_button(wFile,VALUE='Xcrystal input parameters', /Menu)
    wtmp = widget_button(wtmp0,VALUE='Load from file...',UValue='FILEINPUT')
    wtmp = widget_button(wtmp0,VALUE='Save to file...',UValue='FILEINPUT')
    wtmp = widget_button(wtmp0,VALUE='Save as default',UValue='FILEINPUT')
  wtmp = widget_button(wFile,VALUE='Quit', UVALUE='QUIT',/Separator)

wSetParameters = widget_button(wMenuBar,VALUE='Set_Parameters', /MENU)
  wtmp = widget_button(wSetParameters,VALUE='Set Parameters', UVALUE='SETPAR')
  wtmp = widget_button(wSetParameters,VALUE='Set Defaults', UVALUE='SETDEF')

wResults = widget_button(wMenuBar,VALUE='Show',/MENU)
  wtmp = widget_button(wResults,VALUE='Diffraction curve', UVALUE='SHOW')
  wtmp = widget_button(wResults,VALUE='Crystal Parameters', UVALUE='SHOW')
  wtmp = widget_button(wResults,VALUE='Crystallographic Parameters', $
	UVALUE='SHOW')

wHelp = widget_button(wMenuBar,VALUE='Help', /Help)
  wtmp = widget_button(wHelp,VALUE='xcrystal', UVALUE='HELP')
;
wtmp = widget_button(BASE,VALUE='Set Parameters', UVALUE='SETPAR')


if sdep() EQ 'WINDOWS' then font = 'VERDANA*BOLD*ITALIC*24' else $
  FONT='-b&h-lucida-bold-i-normal-sans-24-240-75-75-p-151-iso8859-1'
;  font = '-adobe-helvetica-bold-o-normal--18-180-75-75-p-104-iso8859-1'


wtmp = WIDGET_LABEL( BASE,  VALUE='Crystal' , FONT=font)
wtmp = WIDGET_LABEL( BASE,  VALUE='   (Crystal Diffraction)   ',FONT=font)

;
;state
;
str = xop_defaults('xcrystal')
str_defaults = str.parameters


IF KeyWord_Set(inputFile) THEN BEGIN
  str_par = Xop_Input_Load(InputFile=inputFile)
  IF Type(str_par) EQ 8 THEN BEGIN
    tmp = str.parameters
    Copy_Structure,str_par, tmp, Group=group
    str.parameters = tmp
  ENDIF
ENDIF
wids = {dummy:0L}
state = { str:str, str_defaults:str_defaults, wids:wids}
;
;actions
;
Widget_control,Widget_Info(base,/Child),Set_uvalue=state,/No_Copy
Widget_control,base,/Realize
Xmanager,'xcrystal',base,Group_leader=group
end
;
