Function atomic_symbols,z

; 
; European Synchrotron Radiation Facility (ESRF)
;+
; NAME:
;       ATOMIC_SYMBOLS
;
; PURPOSE:
;	Returns an array with the atomic symbols.
;	
; CATEGORY:
;       X-Ray optics. DABAX data base.
;
; CALLING SEQUENCE:
;	out = atomic_symbols( [zetas] )
; OPTIONAL INPUTS:
;	zetas: an integer (or array of integers) with the z value of 
;		the desired symbol(s). If undefined returns an array 
;		with all (103) elements + vacuum (Z=0!!)
;	
; OUTPUT:
;	out: a string array with the symbols. 
;
; PROCEDURE:
;	Straightforward.
;
; EXAMPLES:
;	IDL> print,atomic_symbols(14) (returns 'Si')
;
; RESTRICTIONS:
;	Returns a two-character symbol (i.e. 'Si', 'H ') except for 
;	vacuum (i.e. atomic_symbols(0) )
;
; MODIFICATION HISTORY:
;       96-11-25 Written by M. Sanchez del Rio (srio@esrf.fr)
;-
;
on_error,2

symbols = strarr(104)
symbols(0:10) = ['Vacuum','H ','He','Li','Be','B ','C ','N ','O ','F ','Ne']
symbols(11:20) = ['Na','Mg','Al','Si','P ','S ','Cl','Ar','K ','Ca']
symbols(21:30) = ['Sc','Ti','V ','Cr','Mn','Fe','Co','Ni','Cu','Zn']
symbols(31:40) = ['Ga','Ge','As','Se','Br','Kr','Rb','Sr','Y ','Zr']
symbols(41:50) = ['Nb','Mo','Tc','Ru','Rh','Pd','Ag','Cd','In','Sn']
symbols(51:60) = ['Sb','Te','I ','Xe','Cs','Ba','La','Ce','Pr','Nd']
symbols(61:70) = ['Pm','Sm','Eu','Gd','Tb','Dy','Ho','Er','Tm','Yb']
symbols(71:80) = ['Lu','Hf','Ta','W ','Re','Os','Ir','Pt','Au','Hg']
symbols(81:90) = ['Tl','Pb','Bi','Po','At','Rn','Fr','Ra','Ac','Th']
symbols(91:100)= ['Pa','U ','Np','Pu','Am','Cm','Bk','Cf','Es','Fm']
symbols(101:103)= ['Md','No','Lw']

if n_params() eq 0 then return,symbols else return,symbols(z)
end


