
;=========================== copyright =========================================
;                       XAID (XAfs with IDl) package.                          ;
;     Copyright European Synchrotron Radiation Facility (1993-1996).           ;
; This software may be used, copied, or redistributed as long as it is not     ;
; sold and this copyright notice is reproduced on each copy made.              ;
; The software is provided as is without any express or implied warranties     ;
; whatsoever.                                                                  ;
; Other limitations apply as described in the file README.copyright.           ;
;                                                                              ;
; REFERENCE: "XAID: A package for XAFS data analysis based on IDL"             ;
;       Manuel Sanchez del Rio. To be published at the proceedings of          ;
;       the 9th International Conference on X-ray Absorption Fine Structure    ;
;       26th - 30th August 1996,  E S R F - Grenoble  France                   ;
;==============================================================================;
PRO zoomset,set,set1
;+
; NAME:
;	ZOOMSET
;
; PURPOSE:
;	This procedure plot a set or two sets of data and allow s
;	a zoom.
;
; CATEGORY:
;	XAID xafs data analysis package. 
;
; CALLING SEQUENCE:
;
;	ZOOMSET, set
;
; INPUTS:
;	set:	fltarr(ncol,npoints) set of data
;
; OPTIONAL INPUTS:
;	set1:	fltarr(2,npoints) set of data to be overplotted
;	
; KEYWORD PARAMETERS:
;
; OUTPUTS:
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;	Sucesive graphics
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	Straightforward
;
; EXAMPLE:
;
;		ZOOMSET,set,set1
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio. ESRF
;	May, 1993
;-
;
on_error,2
n_par = n_params()
print,'n_par = ',n_par
;
settmp=set
plotset,settmp
if (n_par eq 2) then plotset,set1,/over
repeat begin
  print,' Please, click the lower left point for the zoom: ? '
  cursor,x1,y1,3
  plotset,[x1,y1],psym=1,/over
  print,' Please, click the upper right point for the zoom: ? '
  cursor,x2,y2,3
  plotset,[x2,y2],psym=1,/over
  ;
  rect=fltarr(2,5)
  rect(0,*)=[x1,x2,x2,x1,x1]
  rect(1,*)=[y1,y1,y2,y2,y1]
  plotset,rect,/over
  ;
  pause
  xmin=min([x1,x2])
  xmax=max([x1,x2])
  ymin=min([y1,y2])
  ymax=max([y1,y2])
  plotset,settmp,xrange=[xmin,xmax],yrange=[ymin,ymax],psym=-1
  if (n_par eq 2) then plotset,set1,/over
  ;
  i_again = getyesornot(' Zoom again ? [n]')
endrep until not(i_again)
;
return
end
