
;=========================== copyright =========================================
;                       XAID (XAfs with IDl) package.                          ;
;     Copyright European Synchrotron Radiation Facility (1993-1996).           ;
; This software may be used, copied, or redistributed as long as it is not     ;
; sold and this copyright notice is reproduced on each copy made.              ;
; The software is provided as is without any express or implied warranties     ;
; whatsoever.                                                                  ;
; Other limitations apply as described in the file README.copyright.           ;
;                                                                              ;
; REFERENCE: "XAID: A package for XAFS data analysis based on IDL"             ;
;       Manuel Sanchez del Rio. To be published at the proceedings of          ;
;       the 9th International Conference on X-ray Absorption Fine Structure    ;
;       26th - 30th August 1996,  E S R F - Grenoble  France                   ;
;==============================================================================;
pro gettwoabscissas,x1,x2,method=method
;+
; NAME:
;	GETTWOABSCISSAS
;
; PURPOSE:
;	This procedure asks to the user for a couple of coordinates
;	of the current graphic device. The user  select them using 
;	the mouse or typing the coordinates	
;
; CATEGORY:
;	XAID XAFS data analysis package.
;
; CALLING SEQUENCE:
;
;	GETTWOABSCISSAS,x1,x2
;
; INPUTS:
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;	METHOD = 0 (Default) asks for selecting Mouse or Typing method
;		 1 Uses the mouse to get the coordinates
;		 2 Ask the user to type the coordinates
;
; OUTPUTS:
;	x1 the first clicked/typed abscissa
;	x2 the second clicked/typed abscissa
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;	None
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	Straightforward
;
; EXAMPLE:
;
;		GETTWOABSCISSAS,x1,x2
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio. ESRF
;	May, 1993
;-
on_error,2
if not(keyword_set(method)) then method=0
;
if (method eq 0) then begin
  print,' Please select values from the current graphic with: '
  print,'		[1] Mouse '
  print,'		[2] hand-typyng'
  i_menu = getvalue('[Default=1] ? ',1)
endif
if (method eq 1) then i_menu=1
if (method eq 2) then i_menu=2
;
if (i_menu eq 1) then begin
  print,' Please, click the first point <?>'
  cursor,x1,y1,3
  print,'	point selected is: ',x1
  plotset,[[x1,-1000000],[x1,1000000]],/over
  print,'                   last point ? '
  cursor,x2,y2,3
  print,'	point selected is: ',x2
  plotset,[[x2,-1000000],[x2,1000000]],/over
  pause
endif else begin
  print,' Please, type the first point: <?> '
  read,x1
  print,'                  last point: <?> '
  read,x2
endelse
;
return
end
