;
;===============================================================================;

Pro xsh_ray_prop_controls_event,event

;
; Create the control window for XSh_Ray_Prop
; To be used internally by XSh_Ray_Prop
; srio@esrf.fr 98-04-30
;
Widget_Control, event.id, get_UValue=eventUValue
Widget_Control, event.id, get_Value=Value
 
if n_elements(eventuvalue) EQ 0 then eventuvalue = ''
if not(keyword_set(eventuvalue)) then eventuvalue = ''
 
stateid = Widget_Info(event.handler,/Child)
Widget_Control, stateid, get_UValue=state, /No_Copy
 

Case eventUValue OF
    'SHOWHIDE': BEGIN
	IF state.wids.caller_id EQ 0L THEN BEGIN
	  Widget_control,event.top,/Destroy 
	  return
	ENDIF ELSE BEGIN
	  tmp = 0
          Widget_Control,state.wids.xrange,get_value=tmp
	  if tmp(0) EQ tmp(1) then (*(state.strptr)).default_xrange=1 else $
		(*(state.strptr)).default_xrange=0
          Widget_Control,state.wids.yrange,get_value=tmp
	  if tmp(0) EQ tmp(1) then (*(state.strptr)).default_yrange=1 else $
		(*(state.strptr)).default_yrange=0
          Widget_Control,state.wids.range,get_value=tmp
	  if tmp(0) EQ tmp(1) then (*(state.strptr)).default_range=1 else $
		(*(state.strptr)).default_range=0
	  newevent=event
	  newevent.handler=state.wids.caller_id
	  XSh_Ray_Prop_Event,newevent
	ENDELSE
	Return
	END
    'APPLY': BEGIN
	IF state.wids.caller_id EQ 0L THEN BEGIN
	  itmp = Dialog_Message(Dialog_Parent=event.top, /Error,$
		'XSh_Ray_Prop_Controls not called from XSh_Ray_Prop')
	  GoTo,out
	ENDIF
	XSh_Ray_Prop_PStr_Update,state.wids,state.strptr
	newevent=event
	newevent.handler=state.wids.caller_id
	XSh_Ray_Prop_Event,newevent
	END
    ;'REDRAW': BEGIN
	;index=0
	;Widget_Control,event.id,Get_Value=index
	;tmp = state.StrPtr
	;(*tmp).AutoRefresh=index
	;END
    else: BEGIN
	tmp = state.StrPtr
	END
EndCase


out:
Widget_Control, stateid, set_UValue=state, /No_Copy
end
;
;===============================================================================;

PRO xsh_ray_prop_controls, input, Group=Group, TLB_ID=wbase, $
CALLER_ID=caller_id

on_error,2

IF NOT(Keyword_Set(caller_id)) THEN caller_id=0L
if NOT(Keyword_Set(input)) THEN BEGIN
  itmp = Dialog_Message(Dialog_Parent=group, [ $
	'No input data given to XSh_Ray_Prop_Controls','Using Default',$
	'(Creating Pointer that will not be deleted).'])
  input = Ptr_New(Xsh_Defaults_Results('XSH_RAY_PROP'))
endif

wbase=widget_base(/col,title='Ray_Prop controls')
wtmp = widget_base(wbase) ; to store state

;
; main buttons
;
wtmp0 = widget_base(wbase,/Row) 
  wtmp = widget_button(wtmp0,Value='Close',UValue='SHOWHIDE')
  wapply = widget_button(wtmp0,Value='Go Animation',UValue='APPLY')
 
; 
; file & column selection
;
wtmp = Widget_Base(wbase,/Row)
  wshadow_in=cw_pickfile(wtmp,Value='begin.dat',/Frame)
  wcol1 = cw_xshcol(wtmp,Value='1',Title='Horiz Column:',/Column,/Frame,$
     UValue='COL1')
  wcol2 = cw_xshcol(wtmp,Value='3',Title='Vert Column:',/Column,/Frame,$
     UValue='COL2')

wtmp0=Widget_Base(wbase,Row=1) 
  wrange=CW_ARRAY(wtmp0,Value=[0.0,0.0],Title='Range',/Column,$
	/Default,UValue='RAN',Names=['Minumum','Maximum'],/Frame)
  wtmp1=Widget_Base(wtmp0,Col=1,/Frame) 
    wtmp = Widget_Label(wtmp1,Value='Number of frames: ')
    wIters = widget_slider(wtmp1, MIN=3,MAX=100,XSIZE=205)
  wtmp1=Widget_Base(wtmp0,Col=1,/Frame) 
    wtmp = Widget_Label(wtmp1,Value='Wait between frames (sec): ')
    wWait = cw_fslider(wtmp1, VALUE=0.0, MIN=0.0,MAX=1.0,XSIZE=205,/Edit)

wtmp0=Widget_Base(wbase,Row=1,/Frame) ;,UValue=hist_control_tlb)
  wxrange=CW_ARRAY(wtmp0,Value=[0.0,0.0],Title='XRange',/Column,$
	/Default,UValue='XRAN',Names=['Minumum','Maximum'])
  wyrange=CW_ARRAY(wtmp0,Value=[0.0,0.0],Title='YRange',/Column,$
	/Default,UValue='YRAN',Names=['Minumum','Maximum'])

  wtmp1=Widget_Base(wtmp0,Col=1) 
    wtmp = Widget_Label(wtmp1,Value='Rays: ')
    loster=['0','All rays','Good Only','Lost Only']
    wnolost=cw_droplist(wtmp1,Value=loster, UValue='NOLOST')
  wtmp1=Widget_Base(wtmp0,Col=1) 
    wtmp = Widget_Label(wtmp1,Value='Cartesian Axes: ')
    wcart=cw_droplist(wtmp1,Value=['0','No','Yes'], UValue='CART')

;
; titles
;
wtmp0 = Widget_Base(wbase,/Col,/Frame)
  wtmp = Widget_Label(wtmp0,Value='Titles: ')
  wtitle=cw_field (wtmp0,XSize=60,Value='',Title='Top  ',/String,$
	UVal='TITLE',/Return_Events)
  wxtitle=cw_field(wtmp0,XSize=60,Value='',Title='Horiz.',/String,$
	UVal='XTITLE',/Return_Events)
  wytitle=cw_field(wtmp0,XSize=60,Value='',Title='Vert. ',/String,$
	UVal='YTITLE',/Return_Events)

wids={ shadow_in:wshadow_in, col1:wcol1, col2:wcol2, range:wrange, $
  iters:witers, cart:wcart, wait:wWait, xrange:wxrange, yrange:wyrange, $
  nolost:wnolost, title:wtitle, xtitle:wxtitle, ytitle:wytitle,$
  caller_id:caller_ID, apply:wapply }
state = {wids:wids, strptr:input}

xsh_ray_prop_controls_update,wids,input
widget_control,Widget_Info(wbase,/Child),set_uvalue=state,/no_copy
widget_control,wbase,/realize
xmanager,'xsh_ray_prop_controls',wbase,GROUP=group,/No_Block

END
