FUNCTION slopes,input,x,y
;+
; returns the x and y slope errors of a surface
;
; FUNCTION slopes,z,x,y 
; or
; FUNCTION slopes,a    where a is the structure with the surface (a.x, a.y, a.z)
;
; MSR 1994
;-
;
input_type = (size(input)) ((size(input)) (0)+1)
if input_type eq 8 then begin
  print,'Structure input selected'
  z=input.z
  x=input.x
  y=input.y
endif else z=input
nx = n_elements(z(*,0))
ny = n_elements(z(0,*))
;
if not(keyword_set(x)) then x=findgen(nx)
if not(keyword_set(y)) then y=findgen(ny)
help,x
help,y
help,z
;
slope=fltarr(2,nx,ny)

; 
; slopes in x direction
;
for i=0,nx-2 do begin
  step = x(i+1) - x(i)
  slope(0,i,*) = atan( (z(i+1,*) - z(i,*) )/step )
endfor
slope(0,nx-1,*) = slope(0,nx-2,*)
;
; slopes in y direction
; 
for i=0,ny-2 do begin
  step = y(i+1) - y(i)
  slope(1,*,i) = atan( (z(*,i+1) - z(*,i) )/step )
endfor
slope(1,*,ny-1) = slope(1,*,ny-2)
;
slope = slope*180./!pi*3600.  ; from rad to arc sec
print,' Slope error rms in X direction: ',stddev(slope(0,*,*)),' arc sec'
print,' Slope error rms in Y direction: ',stddev(slope(1,*,*)),' arc sec'
;
return,slope
end
