function  REFLAG, shadow_in, SLITCOL=slitcol, SLITRANGE=slitrange, $
FLAGVAL=flagval,FILE=FILE
;+
; NAME:
;	REFLAG 
; PURPOSE:
;	an IDL implementation amd extension of the REFLAG and 
;	SHADOWIT SHADOW's utilities
; CATEGORY:
;	SHADOW's utilities.
; CALLING SEQUENCE:
;	 shadow_out=reflag(shadow_in)
; INPUTS:
;	shadow_in   IDL structure with SHADOW data
;	shadow_out  IDL structure with the resulting SHADOW data after
;		changing the flag
; OPTIONAL INPUTS:
; KEYWORD PARAMETERS:
;       SLITCOL   = number of the column where flag has to be applied.
;		When this keyword and the FILE one are selected, the
;		new flag column is the one of shadow_in, otherwise
;		it takes the one of file.
;       SLITRANGE  = range of good values for the SLITCOL considered.
;		the points outside this interval are flagged negatively.
;	FLAGVAL = value of the flag to out in (default=-1)
;	FILE = shadow file or IDL-SHADOW structure where to apply the 
;		SLITCOL and SLITRANGE keywords (If this keyword is omitted
;		then use the same as shadow_in)
;	OUTPUTS:
;	shadow_out: the ne IDL-SHADOW structure
; OPTIONAL OUTPUT PARAMETERS:
; COMMON BLOCKS:
; SIDE EFFECTS:
; 	None.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	Similar to SHADOW's original.
; MODOFICATION HISTORY:
;	M. Sanchez del Rio. ESRF. Grenoble August 1993
;	94/07/06 MSR Changes to a function and solves a bug when using
;		the FILE and SLITCOL options together.
;-
on_error,2
;
if not(keyword_set(flagval)) then flagval=-1.0
;
; load shadow-idl structures
;
in = readsh(shadow_in)
if keyword_set(file) then filein = readsh(file)
;
; prepare the output
;
out = in
if  keyword_set(file) then begin
  if not(keyword_set(slitcol)) then out.ray(9,*) = filein.ray(9,*)
  in = filein
endif
if keyword_set(slitrange) and keyword_set(slitcol) then  begin
  ; 
  ; if slitcol is energy
  ;
  if (slitcol eq 11) then slitrange = slitrange*2.0*!pi/1.239852D-4
  ;
  aa = where(in.ray(slitcol-1,*) le slitrange(0) )
  if n_elements(aa) gt 1 then out.ray(9,aa) = flagval
  bb = where(in.ray(slitcol-1,*) ge slitrange(1) )
  if n_elements(bb) gt 1 then out.ray(9,bb) = flagval
endif
return,out
end
