pro ray_prop,shadow_in,col1,col2,RANGE=range,ITERS=iters,          $
XRANGE=xrange,YRANGE=yrange,TITLE=title,XTITLE=xtitle,YTITLE=ytitle,  $
NOLOST=nolost,PRINT=print,CART=cart,WAIT=wait,GROUP=group
;+
; NAME:
;	RAY_PROP 
; PURPOSE:
;	plot the evolution of an image (cols 1,3) in vacuum along the beamline
; CATEGORY:
;	SHADOW's utilities.
; CALLING SEQUENCE:
;	ray_prop,shadow_in,keyword_parameters
; INPUTS:
;	shadow_in   IDL structure with SHADOW data
; OPTIONAL INPUTS:
;	col1 [default=1] The column to be placed in the Horizontal axis.
;	col2 [default=2] The column to be placed in the Verical axis.
; KEYWORD PARAMETERS:
;	RANGE  = [min,max]  limits of Y axis (col 2) to where retrace the image 
;	ITERS  = number of iterations (default=20)
;	XRANGE = [min,max], limits of the x scale. 
;	YRANGE = [min,max], heigth limits of the y scale. 
;	NOLOST = consider losses
;		0 all rays (default option)
;		1 exclude losses 
;		2 only losses 
;       TITLE = top title
;       XTITLE = title in X column
;       YTITLE = title in Y column
;	PRINT  = if set to 1, set to screen all the images. This
;		option is suitable for generating the PS file.
;	CART = if set, force cartesian axes (same H and V aspect ratio)
;	WAIT = time between frames (default=0)
;       GROUP The parent id for the caller widget (used to positioning
;               error and information windows).
;	
; OUTPUTS:
;	the interactive view of the beam evolution
; OPTIONAL OUTPUT PARAMETERS:
; COMMON BLOCKS:
; SIDE EFFECTS:
; 	None.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	Similar to SHADOW's RETRACE
; MODOFICATION HISTORY:
;	Original from Steve Turner
;       92/10/13 MSR lots of modifications
;	98/04/30 srio@esrf.fr Almost rewritten. Adapted for SHADOWVUI.
;
;-
;
p_position_old= !p.position
p_charsize_old = !p.charsize
catch, error_status
 if error_status ne 0 then begin
   catch, /cancel
   message,/info,'Error caught: '+!err_string
   if sdep(/w) then itmp = dialog_message(/Error,Dialog_Parent=group,$
	'RAY_PROP: Error caught: '+!err_string)
   goto,out
endif
; set graphic environment and font's size independently from device
;
!p.position = [0.04,0.04,0.7,0.9]
bfy = float(!d.y_ch_size)/!d.y_size
bfx = float(!d.x_ch_size)/!d.x_size
xsize = 0.0065/bfx
ysize = 0.018/bfy
!p.charsize = min([xsize,ysize]) 
if not(keyword_set(title)) then  title = ' '
if not(keyword_set(wait)) then  wait = 0
if n_params() eq 1 then begin
  col1=1
  col2=3
endif
if not(keyword_set(xtitle)) then  xtitle = column_name(col1)
if not(keyword_set(ytitle)) then  ytitle = column_name(col2)
;
; load shadow-idl structure and define arrays and constants
;
shadow_out = readsh(shadow_in,NoLost=nolost)
;
;	redefine arrays when excluding losses
;
flg = shadow_out.ray(9,*)
;rays = shadow_out.ray
;if keyword_set(nolost) then begin
; if nolost eq 1 then rays = rays(*,where(flg>0))
; if nolost eq 2 then rays = rays(*,where(flg<0))
;endif 
;
;
;
arr1 = getshcol(shadow_out,col1)
arr2 = getshcol(shadow_out,col2)
tmp=0
if not(keyword_set(xrange)) then xrange = [min(arr1,max=tmp),tmp]
if not(keyword_set(yrange)) then yrange = [min(arr2,max=tmp),tmp]
;
if not(keyword_set(iters)) then iters = 20L
if not(keyword_set(range)) then range = [-10.0,10.0] 
stepsize = (range(1)-range(0))/float(iters)
if keyword_set(cart) then begin
   cart_axes,xrange,yrange,position=!p.position,$
      title=title,xtitle=xtitle,ytitle=ytitle
endif else begin
   plot,[0,0],xrange=xrange,yrange=yrange,/NoData,$
      title=title,xtitle=xtitle,ytitle=ytitle
endelse

;ppoints = getshcol(shadow_out,[col1,col2])
stdevx = fltarr(iters+1)
stdevy = fltarr(iters+1)
yy=fltarr(iters+1)
icounter=0L
tmpxx=0
tmpyy=0
for y = range(0)/stepsize, range(1)/stepsize do begin
    tmp = retrace(shadow_out,dist=stepsize*y)
    ;points = rays(0:2,*)+ stepsize*y*rays(3:5,*)
    ;stdevx(icounter)=stddev(points(0,*))
    ;stdevy(icounter)=stddev(points(2,*))
    tmpx = getshcol(tmp,col1)
    tmpy = getshcol(tmp,col2)
    stdevx(icounter)=stddev(tmpx)
    stdevy(icounter)=stddev(tmpy)
    yy(icounter) = stepsize*y
    if not(keyword_set(print)) then begin
      oplot,tmpx,tmpy,psym = 3
      if icounter NE 0 then oplot,tmpxx,tmpyy, psym = 3,color = 0
      wait,wait
    endif
    tmpxx = tmpx  &  tmpyy=tmpy
    icounter = icounter+1
end
;oplot,ppoints(0,*),ppoints(2,*),psym = 3,color = 0
;oplot,rays(0,*),rays(2,*),psym=3
if not(keyword_set(print)) then oplot,tmpxx,tmpyy, psym = 3,color = 0
oplot,arr1,arr2,psym=3
;
; plot stdev's
;
!p.position = [0.74,0.04,0.9,0.43]
off=0.1*abs(max(stdevx)-min(stdevx))
if off lt 1e-10 then off=0.5*max(stdevx)
plot,yy,stdevx,psym=1,/noerase,yrange=[min(stdevx)-off,max(stdevx+off)]
oplot,yy,stdevx
!p.position = [0.74,0.47,0.9,0.9]
off=0.1*abs(max(stdevy)-min(stdevy))
if off lt 1e-10 then off=0.5*max(stdevy)
plot,yy,stdevy,psym=1,/noerase,yrange=[min(stdevy)-off,max(stdevy)+off]
oplot,yy,stdevy
;
;
;spawn,'date',/noshell,date
cd,current=pwd
;spawn,'pwd',/noshell,pwd
if sdep() eq 'UNIX' then user=getenv('USER')+'@'+getenv('HOST') else user='' 
xyouts,.04,.96,/norm,pwd+sdep(/ds)+shadow_out.name+'  '+$
  '   '+user+'   '+systime()
;xyouts,.04,.93,/norm,title
xyouts,0.76,0.85,/norm,'StDev Vert: '
xyouts,0.76,0.83,/norm,column_name(col2)
xyouts,0.76,0.38,/norm,'StDev Horiz:'
xyouts,0.76,0.36,/norm,column_name(col1)
;
out:
!p.position = p_position_old
!p.charsize = p_charsize_old
end
