pro INTENS,shadow_in,intens_out,NFILES=nfiles,POLARIZATION=pol,   $
NOLOST=nolost
;+
; NAME:
;	INTENS
; PURPOSE:
;	calculates the intensity from a file or set of files
; CATEGORY:
;	SHADOW's utilities.
; CALLING SEQUENCE:
;	intens,shadow_in,intens_out,Keyword_parameters
; INPUTS:
;	shadow_in  may be:
;          a SHADOW file (between quotes): eg. 'begin.dat' or
;          an IDL-SHADOW structure (without quotes)
; OPTIONAL INPUT PARAMETERS:
;	intens_out the name of an IDL variable with the intensity values
; KEYWORD PARAMETERS:
;		NOLOST = consider losses
;			0 all rays (default option)
;			1 exclude losses;
;               POLARIZATION = when set to 1 calculates the polarization 
;                              parameters:
;                              Is (total intensity for s-polarization)
;                              Ip (total intensity for p-polarization)
;                              S0-stokes = |Es|^2 + |Ep|^2
;                              S1-stokes = |Es|^2 - |Ep|^2
;                              S2-stokes = 2 |Es| |Ep| cos(phase_s-phase_p)
;                              S3-stokes = 2 |Es| |Ep| sin(phase_s-phase_p)
; OUTPUTS:
; COMMON BLOCKS:
;	None.
; SIDE EFFECTS:
;	None.
; RESTRICTIONS:
;	None.
; PROCEDURE;
;	Similar to SHADOW's original.
; MODIFICATION HISTORY:
;	M. Sanchez del Rio. ESRF. Grenoble, Oct 1992
;	96/04/16 MSR change fix() by long() in line 16 (to work for
;		large number of rays)
;-
on_error,2
;
; start loop through the number of files
;
if not(keyword_set(nfiles)) then nfiles = 1
intens_out=fltarr(nfiles)
for i=1,nfiles do begin
istr = strtrim(i,2)
;
; load shadow-idl structure and define arrays and constants
;
if (nfiles eq 1) then shadow=shadow_in else $
shadow = shadow_in+'-'+istr
input_type = (size(shadow)) ((size(shadow)) (0)+1)
if input_type eq 7 then shadow_out = readsh(shadow)
if input_type eq 8 then shadow_out = shadow
;
; define flag, energy (eV) and intensity
;
nelem = shadow_out.npoint
flg = shadow_out.ray(9,0:shadow_out.npoint-1)
;
int=shadow_out.ray(6,0:shadow_out.npoint-1)^2+ $
shadow_out.ray(7,0:shadow_out.npoint-1)^2+ $
shadow_out.ray(8,0:shadow_out.npoint-1)^2
if shadow_out.ncol eq 18 then int = int + $
shadow_out.ray(15,0:shadow_out.npoint-1)^2+ $
shadow_out.ray(16,0:shadow_out.npoint-1)^2+ $
shadow_out.ray(17,0:shadow_out.npoint-1)^2
ray = shadow_out.ray(0:5,0:shadow_out.npoint-1)
;
; calculate the polarization values
;
if (keyword_set(pol) and shadow_out.ncol eq 12) then begin
 message,/info,'Polarization calculations are not posible using only 12 columns'
 exit
endif
if keyword_set(pol) then begin
  as_pol = sqrt(shadow_out.ray(6,*)^2+   $
                shadow_out.ray(7,*)^2+   $
                shadow_out.ray(8,*)^2)
  as2_pol = shadow_out.ray(6,*)^2+       $
            shadow_out.ray(7,*)^2+       $
            shadow_out.ray(8,*)^2
  ap_pol = sqrt(shadow_out.ray(15,*)^2+  $
                shadow_out.ray(16,*)^2+  $
                shadow_out.ray(17,*)^2)
  ap2_pol = shadow_out.ray(15,*)^2+      $
            shadow_out.ray(16,*)^2+      $
            shadow_out.ray(17,*)^2
  phase = getphase(shadow_out)
  cos_pol = cos(phase(0,*)-phase(1,*))
  sin_pol = sin(phase(0,*)-phase(1,*))
  
  s0=as2_pol+ap2_pol
  s1=as2_pol-ap2_pol
  s2= 2*as_pol*ap_pol*cos_pol
  s3= 2*as_pol*ap_pol*sin_pol
endif
;
;
;  redefine arrays when excluding losses
;
if keyword_set(nolost) then begin
 nelem = long(total( flg>0 ))
 if (nelem eq 0)  then begin
   intens_out=0. & return
 endif
 new = fltarr (6,nelem)
 for k=0,5 do begin
   new(k,*) = ray(k,where(flg>0))
 endfor
 ray = new
 int = int(where(flg>0))
 if keyword_set(pol) then begin
  ap2_pol = ap2_pol(where(flg>0))
  as2_pol = as2_pol(where(flg>0))
  s0 = s0(where(flg>0))
  s1 = s1(where(flg>0))
  s2 = s2(where(flg>0))
  s3 = s3(where(flg>0))
 endif
endif
;
;
;
if (nfiles gt 1) then message,/info,' ------------------File number '+$
  strcompress(i,/Rem)
message,/info,'Total intensity is              = '+strcompress(total(int))
intens_out(i-1)=total(int)
;
if keyword_set(pol) then begin
 print,'INTENS: ---------------------------------------------------------'
 print,'INTENS: Polarization parameters:    '
 print,'INTENS: |Es|^2 (total intensity for s-polarization) = ',total(as2_pol)
 print,'INTENS: |Ep|^2 (total intensity for p-polarization) = ',total(ap2_pol)
 print,'INTENS: S0-stokes = |Es|^2 + |Ep|^2 = ',total(s0)
 print,'INTENS: S1-stokes = |Es|^2 - |Ep|^2 = ',total(s1)
 print,'INTENS: S2-stokes = 2 |Es| |Ep| cos(phase_s-phase_p) = ',total(s2)
 print,'INTENS: S3-stokes = 2 |Es| |Ep| sin(phase_s-phase_p) = ',total(s3)
 print,'INTENS: ---------------------------------------------------------'
endif
;
endfor
return
end
