function histosh,arr2,w,nbins=nbins,xrange=xrange, $
  plot=plot,swap=swap,erase=erase,fill=fill,yrange=yrange
;+
;
; function histosh,arr2,w,nbins=nbins,xrange=xrange, $
;  plot=plot,swap=swap,erase=erase,fill=fill,yrange=yrange
;
; (to be used internally bu plotxy and histo1)
;
; M. Sanchez del Rio, ESRF, June 1995
;	97-04-03 srio@esr.fr adds catch.
;
;-

catch,error
if error NE 0 then begin
  message,/info,'Error detected. Returning [0,0].'
  catch,/cancel
  on_error,2
  return,[0,0]
endif
if n_params() EQ 1 then w = arr2*0.+1
if not(keyword_set(nbins)) then nbins = 26
if keyword_set(erase) then erase
if not(keyword_set(xrange)) then begin
  off2 = 0.1*abs( max(arr2)-min(arr2) )
  if off2 lt 1e-10 then off2=0.5*max(arr2)
  xrange =[min(arr2)-off2,max(arr2)+off2]
  xrange = round1( xrange,fix(alog(xrange(1)-xrange(0))/alog(10))-2)
endif

binsize =(xrange(1)-xrange(0))/float(nbins)
hy = histogramw(arr2,w,binsize=binsize,min=xrange(0),max=xrange(1))
hx = fltarr(nbins)
for i=0,nbins-1 do hx(i) = xrange(0)+ binsize/2 + binsize*i 
hout = fltarr (2,nbins)
hout(0,*) = hx
hout(1,*) = hy

if keyword_set(plot) then begin
  hh = fltarr (2,2*nbins)
  for i=0,2*nbins-1,2  do begin
   hh(0,i) = hx(fix(i/2))-binsize/2
   hh(0,i+1) = hx(fix(i/2))+binsize/2
   hh(1,i) = hy(fix(i/2))
   hh(1,i+1) = hy(fix(i/2))
  endfor
  if not(keyword_set(yrange)) then yrange = [0,1.1*max(hy)]
  if keyword_set(swap) then begin
    plot,hh(1,*),hh(0,*),psym=10,/noerase,xrange=yrange
    if keyword_set(fill) then polyfill,hh(1,*),hh(0,*)
  endif else begin
    plot,hh(0,*),hh(1,*),psym=10,/noerase,yrange=yrange
    if keyword_set(fill) then polyfill,hh(0,*),hh(1,*)
  endelse
endif
return,hout
end
