FUNCTION nop_defaults,program_name, Group=group
;+
; NAME:
;	NOP_DEFAULTS
;
; PURPOSE:
;	Define the data structure for each program of the Xop application.
;	The purpose of this function is to contain all the default input
;	parameter definitions in order to allow different Xop users to
;	customize their particular input defaults.
;
; CATEGORY:
;	Xop application.
;
; CALLING SEQUENCE:
;
;	inp = XOP_DEFAULTS('xprogram')
;
; INPUTS:
;	xprogram:	Name of the program interface in Xop.
;
; OPTIONAL INPUTS:
;
; KEYWORD PARAMETERS:
;
; OUTPUTS:
;	The input structure with the data necessary to run the program.
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;
; RESTRICTIONS:
;       *** WARNING  ***
;     Be careful with the type of the variables. Setting for instance
;     A:4 initializes the variable A as a short integer (16-bit) and it will
;     NEVER be used as a floating point variable. Use A:4.0 to set it as
;     a floating point variable.
;
; PROCEDURE:
;	Straightforward.
;
; EXAMPLE:
;	inp = xop_defaults('xurgent')
;
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio
;	October, 1994
;	95/10/24 MSR adds xopmap (mapping option)
;	95/10/31 MSR adds filedir keyword , to allow users to create
;		a file ~/.xop_defaults with his own customization.
;	96/01/11 MSR+RJD include xus and xws for realeasing xop1.3
;	96/01/17 MSR removes case 'Printer' (obsoleted by GetSysPrinter
;		function)
;	96/01/22 srio@esrf.fr adds XOPMAP.editor and XOPMAP.idlcommand
;	96/04/23 srio@esrf.fr adds XCOM and ABSORP
;	96/06/26 srio@esrf.fr adds xsrcomp/rb_choice and xsrcomp/bfield_t
;	96/07/29 srio@esrf.fr adds xpenpol
;	96/12/19 srio@esrf.fr small modifications in xpenpol
;	97/01/03 srio@esrf.fr introduces xcrystal_bent which obsoletes
;		xreflex and xpenpol (deleted).
;	97/01/06 srio@esrf.fr adds xpower
;	97/01/16 srio@esrf.fr adapts for Windows95.
;	97/03/13 MSR removes xopmap (mapping option). It is now handled
;		by $XOP_HOME/data/xop_menu.dat file.
;	97/03/24 bug in xcrystal/thickness label mm->cm. Introduce dummy
;		values in xpower structure to get better parameter
;		presentation under idl5.0-b5
;	97/10/01 srio@esrf.fr removes obsoleted shadow applications:
;		(xsrcomp, xabrefc, xtransmit, xbragg). Makes use of sdep()
;	97/10/06 srio@esrf.fr removes obsoleted shadow application: xmlayer
;	97/10/07 srio@esrf.fr some fixes in xcrystal
;	97/10/09 srio@esrf.fr some changes in xcrystal_bent
;	97/11/10 srio@esrf.fr added K(GAP) tool entry in xwiggler.
;	97/11/11 srio@esrf.fr added xop.LogUsersFile entry.
;	97/11/17 RJD+MSR included RJD modificactions from APS version:
;       	97/09/08 RJD: set the keyword remove_all in strcompress and
;               rewrote latter part of the function related to using data from
;               the .xop_defaults data files. Minor modifications to some text.
;               Added the forward_function statement for the function spec_name
;               so that it will be recognized upon execution (and for an error
;               free compilation). Added an entry for the interface for
;		the tuning curve program XTC.
;	98/11/04 srio@esrf.fr removed code dependencies for IDL version 4.
;		Looks for file xop_defaults instead of .xop_defaults under
;		WINDOWS. Use of Catch.
;	98/11/24 srio@esrf.fr reads now defaults (sequentially) from
;		files $XOP_HOME/defaults/<application>.xop and
;		$XOP_DEFAULTS_DIR/<application>.xop
;		(the last one, in Unix, usually points to
;		$HOME/.xop/<application>.xop).
;	98/12/14 srio@esrf.fr Adapted for XOP2.0. Deletex xop and www
;		entries.
;	01/11/19 boisseau@esrf.fr Adapted for NOP1.0. Add nflux entry.
;
;
;
;-

forward_function spec_name, crystal_bent_theories


catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,'NOP_DEFAULTS: error caught: '+!err_string)
   catch, /cancel
   on_error,2
   IF N_Tags(out) GT 0 THEN RETURN,out ELSE RETURN,0
endif

program_name = strupcase(program_name)

case program_name of
	'NMIRROR': begin
		list = dabax_ls()
		if (sdep() EQ 'WINDOWS' and sdep(/vs) EQ '4') $
		  then list = strlowcase(list)
		datasets = list(where(strpos(list,'Neutron_SLCS_') NE -1))
		if (sdep() EQ 'WINDOWS' and sdep(/vs) EQ '4') $
		  then filecomp = 'COMPNDS.DAT' else filecomp = 'Compounds.dat'
		file = dabax_pathf(filecomp,group=group)
		h = dabax_access(file,group=group)
		n = spec_access(h)
		mat_list = strarr(n)
		for i=0,n-1 do mat_list(i)=spec_name(h,i+1,/index)
		titles = ['datasets','material','table','formula','density [g/cm3]',$
		    'Polarization','Calculate','Wavelength [A] grid',$
		    'Initial Wavelength [A]','Final Wavelength [A]','Number of points',$
			'Grazing angle','Roughness rms [A]',$
			'Starting Graz angle [mrad]','To [mrad]',$
			'Number of angular points']
		flags = ['1','1','w(1) eq 2','w(1) le 1','w(1) eq 1',$
			'w(0) le 1','1', $
			'(w(6) eq 0 or w(6) gt 5)',$
			'(w(6) eq 0 or w(6) gt 5)',$
			'(w(6) eq 0 or w(6) gt 5) and w(7) Eq 1',$
			'(w(6) eq 0 or w(6) gt 5) and w(7) Eq 1',$ ;energy
			'w(6) eq 0 or w(6) eq 11', $
			'w(6) eq 0 or w(6) eq 11',$
			'w(6) eq 0 or w(6) eq 11',$
			'(w(6) eq 0 or w(6) eq 11) and w(11) eq 1',$
			'(w(6) eq 0 or w(6) eq 11) and w(11) eq 1']
		;
		; define structure
		;
		nMirror= { titles:titles, $
		flags:flags, $
		parameters:{ datasets:['1','all',datasets], $
                  mat_flag:['0','Element(formula)',$
			'Mixture(formula)','Mixture(table)'], $
                  mat_list:['0',mat_list], $
                  descriptor:'Ge', $
                  density:1.0, $
                  polar:['0','Unpolarized','Up(+1/2)','Down(-1/2)'], $
                  calculate:['7','all', $
			'Real(b)',$	; F=1
			'Imag(b)',$	; F=2
            		'Scattering Cross Section [barn]', $	; F=3
            		'Incoherent Cross Section [barn]', $	; F=4
            		'Coherent Cross Section [barn]', $	; F=5
            		'Absorption Cross Section [barn]', $	; F=6
			'delta (n=1-delta-i beta)', $	; F=7
			'beta (n=1-delta-i beta)',$	; F=8
			'Nuclear absorption coef [cm^-1]', $	; F=9
			'Mass Nuclear absorp coef [cm^2/g]',$ ; F=10
			'Reflectivity'], $	; F=11
                  GRID:['1','Single Value','User defined'], $
                  GRIDSTART:0.02, GRIDEND:20.0, GRIDN:100L, $
		  THETAGRID:['0','Single value','User Defined'], $
		  ROUGH:0.0, THETA1:2.0,THETA2:5.0,THETAN:50L $
		   } }
		end
	'NBRAGG': begin   ; needed for ncrystal and ncrystal_bent
		;
		list = dabax_ls()
		xtalfile = 'CrystalStructures.dat'
		; get list of crystals
		h = dabax_access(xtalfile,group=group)
		n = spec_access(h)
		xtals = strarr(n)
		for i=0,n-1 do xtals(i)=spec_name(h,i+1,/index)
		;
		list = dabax_ls()
		;
		; get f1f2 file list
		filef0 = list(where(strpos(list,'Neutron_SLCS_') NE -1))
		filef0 = reverse(filef0) ; to get by default the DataBooklet 
		;
		; titles and flags
		bragg_titles = [ 'DABAX file','Neutron polarization',$
		'Crystal','h miller index','k miller index','l miller index',$
		'E min [eV]','E max [eV]','E step [eV]',$
		'TDS cross-section [barn]','Temp. factor [see help]',$
;;srio		'Asymmetry angle [deg]', $
		'Linear cell expansion','Output file']

		flags=replicate('1',n_elements(bragg_titles))
;;srio		flags(1)='w(0) eq 0' ; polarization available only if NuclearSpin database set
		;
		; define structure
		;
		nbragg = { titles:bragg_titles, $
		flags:flags, $
		parameters:{ filef0:['0',filef0],$
		  polar:['0','Unpolarized','Up(+1/2)','Down(-1/2)'], $
		  ilattice:['2',xtals], $
		  hmiller:1, $
		  kmiller:1, $
		  lmiller:1,$
		  EMIN:1.0D2, $
		  EMAX:1.0D3, $
		  ESTEP:1.0D1, $
		  sig_tds:0.d0, $
		  DWf:'1.0', $
;;srio		  alpha:0.0D0, $
		  EXPANS:1.0D0, $
		  OUTFIL:'nbragg.out'} $ ;end parameters
		}
		end
	'NCRYSTAL': begin
		a = nop_defaults('nbragg')
		a.parameters.outfil = 'ncrystal.bra'
		;if sdep() EQ 'WINDOWS' then $
		;  a.parameters.outfil = 'ncrystal.bra' else $
		titles = ['DABAX file with scat. lengths','Polarization',$
			'Crystal',$
			'h Miller index','k Miller index','l Miller index',$
			'TDS cross-section [barn]','Debye Waller factor',$
			'Linear cell expansion',$
			'Mosaic Crystal',$ ; w9
			'Geometry','Scan type (Energy or Angular)','Energy/Wavelength unit',$
;;srio			'Angular Unit','Asymmetry angle [deg]','Fixed value (En. or Ang.)',$
			'Angular Unit','Fixed value (En. or Ang.)',$
			'Min scan value (En. or Ang.)','Max scan value (En. or Ang.)',$
			'Scan Points:','Asymmetry angle [deg]',$
			'Crystal thickness [cm]','Mosaicity [deg, FWHM]']
		flags = ['1','1',$
			'1',$
			'1','1','1',$
			'1','1',$
			'1',$
			'1',$    ; w9
			'1','1','1',$   ;'w(11) LE 2'angular units always ?
			'1','1', $
			'1','1',$
			'1','1', $
			'1','w(9) EQ 1']
		ncrystal = { titles:titles, flags:flags, bragg:a, $
			parameters:{ filef0:a.parameters.filef0, $
			polar:a.parameters.polar, $
			Crystal_material: a.parameters.ilattice, $
			Miller_index_h:  a.parameters.hmiller, $
			Miller_index_k:  a.parameters.kmiller, $
			Miller_index_l:  a.parameters.lmiller, $
			sig_tds: a.parameters.sig_tds, $
			DWf: a.parameters.DWf, $
			expans: a.parameters.expans, $
			mosaic: ['0','No','Yes'],$
			Geometry: ['0','BRAGG: diffr beam','LAUE: diffr beam', $
                  	  'BRAGG: transm beam','LAUE: transm beam'] , $
			Scan:['2','Theta (absolute)','Th minus ThBragg(corrected)',$
                          'Th minus Th Bragg', 'Energy/Wavelength',$
                          'Y (Zachariasen)'], $
;			EUnit:['1','Wavelength [A]','Photon energy [eV]',$
			EUnit:['0','Wavelength [A]',$
			  'Neutron energy [meV]','Neutron velocity [m/s]'], $
			Unit:['1','Radians','micro rads','Degrees','ArcSec'],$
;;srio			Alpha:0.0, Energy:1.0,ScanFrom:-100.0, ScanTo:100.0,  $
			Energy:1.0,ScanFrom:-100.0, ScanTo:100.0,  $
			ScanPoints:800, Asymmetry_angle:0.0, $
			Thickness:0.70, Mosaic_fwhm:0.1} $
			}
		end

	'NCRYSTAL_BENT': begin
		a = nop_defaults('bragg')
		if sdep() EQ 'WINDOWS' then $
		  a.parameters.outfil = 'xcrystal.bra' else $
		  a.parameters.outfil = 'xcrystal.bragg'
		energy_shift = 100.
		energy_step = 5.
		titles = ['DABAX f0 file','DABAX f1f2 file',$
			'Crystal',$
			'h miller index','k miller index','l miller index',$
			'Include absorption','Temperature factor',$
		        'Linear cell expansion ',$
                	'Calculation theory',$
			'Geometry',$
			'Min Y value','Max Y value','Y step',$
                        'Energy units', $
			'Energy/Wavelength/Velocity',$
                        'Asymmetry angle [deg]',$
			'Polarization',$
			'Radius of Curvature [m]', $
			'Crystal thickness [mm]','Poisson ratio']
		flags = replicate('1',n_elements(titles))
		;flags(6) = 0 ; by now, do not ask to include absorption
		tt_titles=['window [microns]',$
			  'step [microns]',$
			  'Write file with network?',$
			  'Write file with all diff prof?']
		tt_flags = replicate('1',n_elements(tt_titles))
;		tt_pars={window:-1.0, $
;			step:-1.0, $
;			net:['0','No','Yes'],$
;			all:['0','No','Yes']}
		ncrystal_bent = { $
;			tt_pars:tt_pars, $
			n_main:21, $
			n_tt:4, $
			tt_titles:tt_titles,$
			tt_flags:tt_flags,$
			titles:titles, flags:flags, bragg:a, $
			energy_shift:energy_shift, $
			energy_step:energy_step, $
			codes:crystal_bent_theories(),$
			parameters:{ filef0:a.parameters.filef0, $
			  filef1f2:a.parameters.filef1f2, $
			  Crystal_material: a.parameters.ilattice, $
			  Miller_index_h:  a.parameters.hmiller, $
			  Miller_index_k:  a.parameters.kmiller, $
			  Miller_index_l:  a.parameters.lmiller, $
			  i_absorp: a.parameters.i_absorp, $
			  temper: a.parameters.temper, $
			  expans: a.parameters.expans, $
			  theory: ['0',crystal_bent_theories(/NAMES)],$
			  Geometry: ['1','BRAGG','LAUE'], $
			  Y_start:-25.0, $
			  Y_end:25.0, $
			  Y_step:0.2, $
                          EUnit:['1','Wavelength[A]','Photon energy[eV]',$
			    'Neutron energy [meV]','Neutron velocity [m/s]'],$
			  Energy:33144.0, $
			  Asymmetry_angle:63.78, $
			  Polarization:['0','Sigma','Pi','Non polarized'],$
			  Radius_min_m:12.98, $
			  Thickness:0.70, $
			  Elastic: 0.2202, $ ; END MAIN PARAMETERS (20)
			    window:-1.0, $
			    step:-1.0, $
			    net:['0','No','Yes'],$
			    all:['0','No','Yes'] $  ; END TT PARS (2)
; ;
; IF CHANGED THE NUMBER OF PARS< ALSO CHANGE N_MAIN AND N_TT
;
			  } $ ;end parameters
			}
		end

	'NFLUX': begin
		filecomp = 'Compounds.dat'
		ipos = 13
		iden_f = 'Neutron_SLCS_'
                list = dabax_ls()
                dataf1f2 = list(where(strpos(list,iden_f) NE -1))
		file = dabax_pathf(filecomp)
		h = dabax_access(file)
		n = spec_access(h)
		mat_list = strarr(n)
		for i=0,n-1 do mat_list(i)=spec_name(h,i+1,/index)
		h = dabax_access(file)
		n = spec_access(h)
		mat_list = strarr(n)
		for i=0,n-1 do mat_list(i)=spec_name(h,i+1,/index)
		titles = ['  Scatt. Length. dataset:  ','Polarization',$
                  'Source:', 'DUMMY1','DUMMY2','DUMMY3', $
		  'From wavelength [A]:', 'To wavelength [A]:', $
                  'Wavelength points:  ', 'File with source:', $
		  'Number of elements:',$
                  '1st oe formula','kind:',$
			'thickness [mm]','Mirror angle[mrad]',$
			'Roughness[A]', 'Density [g/cm^3]', $
                  '2nd oe formula','kind:',$
			'thickness [mm]','Mirror angle[mrad]',$
			'Roughness[A]', 'Density [g/cm^3]', $
                  '3rd oe formula','kind:',$
			'thickness [mm]','Mirror angle[mrad]',$
			'Roughness[A]', 'Density [g/cm^3]', $
                  '4th oe formula','kind:',$
			'thickness [mm]','Mirror angle[mrad]',$
			'Roughness[A]', 'Density [g/cm^3]', $
                  '5th oe formula','kind:',$
			'thickness [mm]','Mirror angle[mrad]',$
			'Roughness[A]', 'Density [g/cm^3]' ]
		flags = replicate('1',n_elements(titles))
		flags(3:5)='0' ;dummy values
		flags(6) = 'w(2) eq 0'
		flags(7) = 'w(2) eq 0'
		flags(8) = 'w(2) eq 0'
		flags(9) = 'w(2) eq 1'
		istart = 11
		for i=0,4 do begin
		  flags(istart+0+6*i) = ' w(10) ge '+strcompress(i,/rem)
		  flags(istart+1+6*i) = ' w(10) ge '+strcompress(i,/rem)
		  flags(istart+2+6*i) = ' w(10) ge '+strcompress(i,/rem)
		  flags(istart+3+6*i) = $
			'w('+strcompress(istart+1+6*i,/rem)+') ne 0 and' +$
			' w(10) ge '+strcompress(i,/rem)
		  flags(istart+4+6*i) = $
			'w('+strcompress(istart+1+6*i,/rem)+') ne 0 and'+$
			' w(10) ge '+strcompress(i,/rem)
		  flags(istart+5+6*i) = ' w(10) ge '+strcompress(i,/rem)
		endfor
		nflux= { titles:titles, flags:flags, $
		mat_list:mat_list,$
		parameters:{ nflux, $
	        f1f2: ['0',dataf1f2],$
		polar: ['0','unpolarized','up (+1/2)','down (-1/2)'], $
;	        dummy0: '',$
		source: ['0','Normalized to 1 (from keyboard)',$
				'From external file',$
				'Nop/source Flux (Energies in meV - file SRCOMPE)',$
				'Nop/source Flux (Wavelength in A - file SRCOMPW)'],$
		dummy1:'', $
		dummy2:'', $
		dummy3:'', $
		ener_min: 0.02, $
		ener_max: 20., $
		ener_n: 100, $
		source_file: '?', $
		Nelements:['2','1','2','3','4','5'], $
		;
		el1_for:'Be', $
		el1_flag:['0','Attenuator','Mirror (reflec.)','Mirror (trans.)'], $
		el1_thi:0.5, el1_ang:3.0, el1_rou:0.0, el1_den:'?', $
		;
		el2_for:'Rh', $
		el2_flag:['1','Attenuator','Mirror (reflec.)','Mirror (trans.)'], $
		el2_thi:0.5, el2_ang:3.0, el2_rou:0.0, el2_den:'?', $
		;
		el3_for:'Al', $
		el3_flag:['2','Attenuator','Mirror (reflec.)','Mirror (trans.)'], $
		el3_thi:0.5, el3_ang:3.0, el3_rou:0.0, el3_den:'?', $
		;
		el4_for:'B', $
		el4_flag:['0','Attenuator','Mirror (reflec.)','Mirror (trans.)'], $
		el4_thi:0.5, el4_ang:3.0, el4_rou:0.0, el4_den:'?', $
		;
		el5_for:'Pt', $
		el5_flag:['1','Attenuator','Mirror (reflec.)','Mirror (trans.)'], $
		el5_thi:0.5, el5_ang:3.0, el5_rou:0.0, el5_den:'?'} }
		end

	else:   begin
		message,/info,'Error: Program not found'
		out = 0
		end
	endcase

;
;----------------------- WARNING !! -------------------------------
; If this section is modified, please check also dabax_defaults.pro
;------------------------------------------------------------------
;
; rename the structure to out
;
out = 0
command = 'out = '+program_name
;print,command
tmp = Execute(command)

;
; Overwrite data with values from defaults files
; (when changing this code, also check xop_ifc.pro)
;
sep = sdep(/ds)
filedir = [Xop_GetEnv('XOP_HOME')+sep+'defaults']
filedir = [filedir]
IF Xop_GetEnv('XOP_DEFAULTS_DIR') NE '' THEN $
   filedir = [filedir,Xop_GetEnv('XOP_DEFAULTS_DIR')]

nfiles = n_elements(filedir)
if nfiles EQ 1 then filedir = [filedir]
tmp=0
for i=0,nfiles-1 do begin
  file = filedir[i]+sep+StrLowCase(program_name)+'.xop'
  tmp = checkfile(file)
  if tmp EQ 1 then begin
    str_par = Xop_Input_Load(inputFile=file)
    ;IF N_Tags(out.parameters) NE 0 THEN BEGIN
    IF (Where(StrUpCase(Tag_Names(out)) EQ 'PARAMETERS'))(0) NE -1 THEN BEGIN
      tmp = out.parameters
      Copy_Structure,str_par, tmp
      out.parameters = tmp
    ENDIF ELSE BEGIN
      tmp = out
      Copy_Structure,str_par, tmp
      out = tmp
    ENDELSE
    message,/info,'Defaults from file: '+file+'
  endif
endfor
;
; return
;
return,out
end
