Function nbragg_inp,inp1,ask=ask

;+
; NAME:
;       NBRAGG_INP
;
; PURPOSE:
;	Returns the structure with inputs for nbragg_calc.
;
; CATEGORY:
;       Neutron optics.
;
; CALLING SEQUENCE:
;	out = nbragg_inp([inp])
; OPTIONAL INPUTS:
;	inp = An existing input structure.
;
; KEYWORDS:
;	ask = three possible values:
;		0 (default). Returns the default structure (only calls
;			nop_defaults('nbragg'))
;		1 Ask for the new parameters by using command lines.
;			(To be used with non-X applications).
;		2 Ask for the new parameters by using widgets.
;
; OUTPUT:
;	out: a structure with the output data. This structure is the
;		input nbragg_calc and can be edited with bragg_inp.
;
; PROCEDURE:
;	It calls nop_defaults('nbragg') which uses the DABAX files:
;	  CrystalStructures.dat: to get the crystal tyle list
;	  Neutron_SLCS_*.dat: to get the scattering lengths
;
; EXAMPLE:
;	inp = nbragg_inp(ask=2)
;
; SEE ALSO:
;	nbragg_calc, nbragg_out, nop_defaults.
;
; MODIFICATION HISTORY:
;       2003-02-14 M. Sanchez del Rio (srio@esrf.fr)
;		From the version of Ch. Boisseau
;-
on_error,2
;
; ask = 0 (default) ; It does not ask, just return defaults
; ask = 1 It asks (command lines)
; ask = 2 It asks (widget)
;
; definition section
;
if not(keyword_set(ask)) then ask=0

if n_params() EQ 0 then inp = daban_defaults('nbragg') else inp=inp1

  filef0 = inp.parameters.filef0(1:n_elements(inp.parameters.filef0)-1)
  ifilef0 = inp.parameters.filef0(0) + 1
  polar = inp.parameters.polar(1:n_elements(inp.parameters.polar)-1)
  ipolar = inp.parameters.polar(0) + 1

  ilattice = inp.parameters.ilattice(0) + 1
  xtals = inp.parameters.ilattice(1:n_elements(inp.parameters.ilattice)-1)
  hmiller=inp.parameters.hmiller
   kmiller=inp.parameters.kmiller
    lmiller=inp.parameters.lmiller
  sig_tds = inp.parameters.sig_tds(0)
  DWf = inp.parameters.DWf
  EXPANS = inp.parameters.expans
  EMIN = inp.parameters.emin
   EMAX = inp.parameters.emax
    ESTEP = inp.parameters.estep
  OUTFIL = inp.parameters.outfil

;
; input section
;
if ask EQ 1 then begin
  print,'Please selected a file for b (real bound scat. length) : '
  for i=0,n_elements(filef0)-1 do print,'   ',i+1,': ',filef0(i)
  read,'Give me b-file index: ',ifilef0

  print,'Please selected a polarization for neutrons: '
  ;filepolar=['Unpolarized','Up(+1/2)','Down(-1/2)']
  ;for i=0,n_elements(filepolar)-1 do print,'   ',i+1,': ',filepolar(i)
  for i=0,n_elements(polar)-1 do print,'   ',i+1,': ',polar(i)
  read,'Give me neutrons'' polarization index: ',ipolar

  print,'Please selected a crystal: '
  for i=0,n_elements(xtals)-1 do print,'   ',i+1,': ',xtals(i)
  read,'Give me crystal index: ',ilattice

  read,' Miller index h: ',hmiller
  read,' Miller index k: ',kmiller
  read,' Miller index l: ',lmiller

  read,'TDS cross section [barn] ? ',sig_tds
  read,'Temperature (Debye-Waller) factor ? ',DWf
;;srio  read,'Angle Alpha between brag plane and crystal surface ? ',Alpha
  read,'Linar cell expansion factor ? ',EXPANS
  print, '**********************************************'
  read,'minimum photon energy (eV)  ? ',EMIN
  read,'maximum photon energy (eV)  ? ',EMAX
  read,'energy step (eV)            ? ',ESTEP
  read,'Output file name (for SHADOW) : ',OUTFIL
endif


inp.parameters.filef0=[strcompress(ifilef0-1,/rem),filef0]
inp.parameters.polar=[strcompress(ipolar-1,/rem),polar]
inp.parameters.ilattice=[strcompress(ilattice-1,/rem),xtals]
inp.parameters.hmiller=hmiller
inp.parameters.kmiller=kmiller
inp.parameters.lmiller=lmiller
inp.parameters.sig_tds=sig_tds
inp.parameters.DWf=DWf
inp.parameters.EXPANS=EXPANS
inp.parameters.EMIN=EMIN
inp.parameters.EMAX=EMAX
inp.parameters.ESTEP=ESTEP
inp.parameters.OUTFIL=OUTFIL


if ask EQ 2 then begin
  tmp = inp.parameters
  XScrMenu,tmp,/Interp,/NoType,action=action,Ncol=4,titles=inp.titles, $
	flags=inp.flags,wtitle='Bragg inputs'
  if  action EQ 'DO' then inp.parameters = tmp
endif

return,inp

end


