
filedabax = 'Neutron_SLCS_DataBooklet.dat'
h = dabax_access(filedabax)
wavelengths = MakeArray1(200,0.02,20.0,/log)
dirout='./IMDNK/'

;
; list of scans: 
;
n = spec_access(h)

openw,unit1,dirout+'AAACATALOG.TXT',/Get_Lun
printf,unit1,'FILE            DESCRIPTION, with [wavelength range in angstroms]'
printf,unit1,'------------------------------------------------------------------------'
whiteline='                                                             '

FOR i=1,n DO BEGIN
  name = spec_name(h,i,/Index)
  IF strmid(name,0,8) EQ 'natural.' THEN BEGIN
     nameshort=strmid(name,8) + '.natural'
  ENDIF ELSE BEGIN
      name = StrCompress(name,/Rem)
      tmp1 = StrMid(name,0,1,/Reverse)
      tmp2 = StrMid(name,1,1,/Reverse)
      n = StrParse(tmp2,[0123456789])
      IF n EQ -1 THEN symbol1=tmp1 ELSE symbol1=tmp2+tmp1
      tmp1 = StrMid(name,0,1)
      tmp2 = StrMid(name,1,1)
      tmp3 = StrMid(name,2,1)
      n2 = StrMatch(tmp2,'[0123456789]')
      n3 = StrMatch(tmp3,'[0123456789]')
      amass=tmp1 
      IF n2 EQ 1 THEN amass=amass+tmp2
      IF n3 EQ 1 THEN amass=amass+tmp3
      nameshort=symbol1+amass
  ENDELSE
  fileout=dirout+StrCompress(nameshort,/Rem)+'.nk'

 
  printf,unit1,nameshort+StrMid(whiteline,0,14-StrLen(nameshort))+'=Neutron data '+nameshort+' : [0.02 - 20]'

  openw,unit,fileout,/Get_Lun
  printf,unit,'; Refraction index for neutrons in '+name
  printf,unit,'; File created by XOP/NOP make_imdnk on: '+SysTime()
  printf,unit,';'
  printf,unit,'; Computed using scattering lengths taken from: '
  printf,unit,';'
  printf,unit,'; http://www.ati.ac.at/~neutropt/scattering/table.html'
  printf,unit,';'
  printf,unit,'; Also avalable at "Neutron Scattering Lengths"'
  printf,unit,'; by H. Rauch and W. Waschkowski, Chapter 1.1 in "Neutron Data Booklet"'
  printf,unit,'; Edited by the Institute Laue-Langevin, October 2001. '
  printf,unit,';'
  printf,unit,';'
  printf,unit,';'

  print,' '
  print,'>>>'+name+'<<<'
  z=spec_scan(h,i,/Index)
  print,'Z: ',z
  satwt = String(atomic_weights(name,/full_match),format='(G18.13)')
  print,'Atomic weight: '+satwt
  sdens= String( Atomic_Constants(z,RETURN='Density'),format='(G18.13)')
  print,'Density: '+sdens


  printf,unit,';'
  printf,unit,'; Atomic number: '+StrCompress(z,/rem)
  printf,unit,'; Used value of density: '+sdens
  printf,unit,'; Used value of atomic mass: '+satwt
  printf,unit,'; ' 
  printf,unit,';    lambda [A]      1-delta    beta   '
  printf,unit,'; --------------------------------------'

  delta = nsl_calc(filedabax,name,wavelengths,RET=7,/full_match,/V)
  beta = nsl_calc(filedabax,name,wavelengths,RET=8,/full_match,/V)
  FOR j=0,N_Elements(wavelengths)-1 DO  $
    printf,unit,wavelengths[j],1.0D0-delta[j],beta[j],Format='(3G18.8)'
  Free_Lun,unit
  print,'File written to disk: '+fileout
ENDFOR
Free_Lun,unit1
;
; remove files using bad density number
;
spawn,'rm IMDNK/At.natural.nk'
spawn,'rm IMDNK/Fr.natural.nk'
spawn,'echo "" >IMDNK/Au.nk'

END


