;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   phonV01_3.pro 
;   last modification: 21 Jan 1997 by hg
;   last modification: 20 Mar 1997 by jm -> error calculation corrected
;   last modification: 18 Apr 1997 by hg -> error in summing up detected
;                                           plot parameters on one page
;   last modification: 03 Oct 1998 by jm -> introduction of new HRM
;       last modification: 30 Oct 1998 by hg -> Pico1 and Pico2 works
;                                               as Ionisation chamber
;   last modification: 09 Nov 1998 by ab -> added Sn monochromator 1.0meV
;   last modification: 01 Dec 1998 by ab -> corrected error in PhonA_SumScans
;   last modification: 17 Mar 1999 by ab -> changed sign in 0.8meV
;                  and 4.4meV+new mech., and 
;                  changed format of
;                  output file
;   last modification: 01/13 Apr 1999 by ab/ol -> added new Eu
;                                                     monochr. (1.5meV)
;                        with new mechanics
;   last modification: 13 Apr 1999 by ab -> corrected error with Pico1
;       last modification: 09 Sep 1999 by ab -> added Sn monochromator 1.0meV
;                  with new mechanics
;       last modification: 17 Jul 2000 by ab -> added Fe monochromator
;                                               3.8meV with IK320 encoder
;   last modification: 27 Nov 2000 by ab -> now also a single scan
;                  may be "added"
;   last modification: 19 Apr 2001 by ab -> corrected all factors to
;                  convert encoder steps
;                  into energy
;   last modification: 19 Feb 2003 by srio@esrf.fr -> rename modules 
;		   (added phona prefix) to avoid conflict name for being 
;		   used as an XOP extension.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro PhonA_Check_MyErrors, error_status, MyFile
  IF error_status NE 0 THEN BEGIN     ;This statement begins the error handler.
    Ines_Print, 'Error index: ', Error_status
    Ines_Print, 'Error message:', !ERR_STRING
    errs = ['divide by 0', 'underflow', 'overflow', 'illegal operand']
    j=check_math()
    for i=4,7 do if ishft(j,-i) AND 1 then $
      Ines_Print, errs(i-4), ' occured'
  endif
  ;
  if (MyFile eq '') then $
      MyFile = Dialog_PickFile (Filter='*.*')
      ;read,MyFile, PROMPT=' --> Name of the file: ' 
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro PhonA_GetVersion, PhonVersion
  PhonVersion = "phonV01_3"
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro PhonA_ProgStamp, PhonVersion
  Ines_Print, "===================================================================="
  Ines_Print, " "
  Ines_Print, "                Bonjour de " + PhonVersion + ".pro
  Ines_Print, " "
  Ines_Print, "    created: 5.September 1996 by H.Gruensteudel and J.Metge "
  Ines_Print, "             Fortran version by A.Chumakov"
  Ines_Print, "===================================================================="
  Ines_Print, " last modification: 21 Jan 1997 by hg (version 1.0)"
  Ines_Print, " last modification: 20 Mar 1997 by jm (version 1.1)"
  Ines_Print, " last modification: 03 Oct 1998 by jm (version 1.2)"
  Ines_Print, "                    error calculation corrected"
  Ines_Print, " last modification: 19 Apr 2001 by ab (version 1.3)"
  Ines_Print, "===================================================================="
  ;Ines_Print, "   syntax:   IDL> .run phonA.pro"
  Ines_Print, "===================================================================="
  Ines_Print, "   language:      IDL"
  Ines_Print, "   aim:         - read in NIS spec scans "
  Ines_Print, "         - calibrate the energy axis "
  Ines_Print, "         - add up several scans "
  Ines_Print, "   files:   - input file to define scan file, "
  Ines_Print, "         scan numbers, HRM, columns for NFS/NIS/etc. signals "
  Ines_Print, "         (rules for input file see code) "
  Ines_Print, "        - spec scan file(s) "
  Ines_Print, "   procedure: - you need /sware/exp/idl.expg/specaccess/spec_access "
  Ines_Print, "                before running  phonA.pro type once "
  Ines_Print, "                IDL> .compile spec_access "
  ;Ines_Print, "   hint:   - if you use ^C to interrupt the program or if the "
  ;Ines_Print, "           program stops due to an error use:      "
  ;Ines_Print, "         IDL> RetAll  to return to the main program level "
  ;Ines_Print, "              and to rediscover disappearing variables"
  ;Ines_Print, "===================================================================="
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;    Get the resolution from the parameters
;(we need this in ReadParameters_GUI and PhonA_ReadParameters)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
FUNCTION PhonA_GetMonochromatorResolution,monochromator
	monochromator = strcompress(strtrim(monochromator,2))
	case strupcase(monochromator) of
		'422-1222':       resolution =  0.2106784284 
		'422-1222NM':     resolution = -0.0077618118
		'422-975' :       resolution =  0.1643635631
		'422-975NM' :     resolution = -0.0060554803
		'333-975' :       resolution =  0.1635747701
		'333-975NM' :     resolution = -0.0060264198
		'975-975' :       resolution =  0.0880281776 
		'975-975NM' :     resolution = -0.0032431327 
		'642-121212':     resolution =  0.1892071962
		'642-121212NM' :  resolution = -0.0069707693
		'444-880' :       resolution =  1.7367280722
		'444-880NM' :     resolution = -0.0639845133
		'440-12128' :     resolution =  0.1636367440
		'440-12128NM' :   resolution = -0.0060287034
		'800-1244' :      resolution =  1.0691621304
		'800-1244NM' :    resolution = -0.0393900573
		'444-18126' :     resolution =  0.0818323866
		'444-18126NM' :   resolution = -0.0030148681
      else: begin 
          Ines_Print, " HRM:  ERROR!!  : ",  RestString
          Ines_Print, " take default value:"
   		 resolution = 0.1643635631
      endcase
	endcase
	return,resolution
END
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;;  Read parameters from input file
;
;   Rules for the input file:
;   - empty lines do not disturb
;   - order: 1) type of High Resolution Monochromator
;            422-1222 (6.4meV) 57Fe Inchworm
;            422-1222NM (6.4meV) 57Fe New Mechanics
;            422-975  (4.4meV) 57Fe Inchworm
;            422-975NM (4.4meV) 57Fe New Mechanics
;            333-975 (3.5meV) 57Fe Inchworm
;                     333-975NM (3.5meV) 57Fe New Mechanics
;            975-975  (0.6meV) 57Fe Inchworm
;            975-975NM (0.6meV) 57Fe New Mechanics
;            642-121212 (0.7meV) 119Sn Inchworm
;            642-121212NM (0.7meV) 119Sn New Mechanics
;            444-880 (10meV) 119Sn Inchworm
;            444-880NM (10meV) 119Sn New Mechanics
;            440-12128 (1.2meV) 151Eu Inchworm
;            440-12128NM (1.2meV) 151Eu New Mechanics
;            800-1244 (6.0meV) 151Eu Inchworm
;            800-1244NM (6.0meV) 151Eu New Mechanics
;            444-18126 (1.0meV) 161Dy Inchworm
;            444-18126NM (1.0meV) 161Dy New Mechanics 
;       2) name of first scan file (filename1)
;       3) headers of detector columns in scan file:
;            Encoder DetInc  DetFwd  MonInc  MonDet
;                 IMPORTANT: when you use a picoamperometer as monitor
;                            the name must be Pico1 or Pico2 
;                            (because the counts
;                            do not depend on the time measured),
;                            otherwise the countrates will be wrong in the end 
;       4) scan numbers for filename1
;       5) scan filename2 etc. 
;   - comment lines can be everywhere, they start with "#...."
;     (... = blanks), whereas lines 1)-4) etc. start with  
;     "#HRM", "#File", "#Head", "#Scan"
;   Example:
;     #     Input file for my sample, T=300K
;     #     Data are in 2 scan files, same detector headers
;     #     same monochromator
;     #HRM    422-1222
;     #File   96Sept09a
;     #Head   b1222_enc  DetInc  DetFwd  MonInc  MonDet
;     #Scan   1, 2, 4, 8, 12, 23, 33 
;     #Scan   40, 41, 45, 60
;     #    
;     #File   96Sept10
;     #Scan   1, 2, 3, 5, 6, 7, 22,
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;  variable       dimensions    maximum          content
; -----------------------------------------------------------------------------
;  ScanFile            1          CountFile       filenames
;  CountScans         1          CountFile        number of scans per file
;  ScanN           2          ScanMax, CountFile   number of scans, filename
;  CountFile         0          one integer       number of files
;;;;;;;;
pro PhonA_ReadParameters, ParFile, ScanFile, ScanN, CountFile, CountScans,$
                    CountScanMax, Detectors, resolution
  openr, InFile, ParFile, /get_lun    ; open the file for reading
  i=0                    ; count total lines in the scanfile
  line = ''
  ScanFile = strarr(10)
  ScanN = intarr(1000, 10)
  CountScans =  intarr(1000)
  CountFile = -1
  Ines_Print, "===================================================================="
  while NOT EOF(InFile) do begin   ; read until end of file
    FirstString = ''
    RestString = ''
    readf, InFile, line
    FirstString = strmid(line, 0, 5)
    RestString = strmid(line, 6, strlen(line))
    case strupcase(FirstString) of
     '#    ': Ines_Print, "          "+  RestString
     '#FILE': begin
                CountFile = CountFile + 1
                ScanFile(CountFile) =  strtrim(RestString,2)
                Ines_Print, " --- "
                Ines_Print, " scanfile:  "+ScanFile(CountFile)
                Ines_Print, " --- "
                CountScans(CountFile) = 0
              end
     '#HEAD': begin 
                RestString = strcompress(strtrim(RestString,2))
                ii = 0          ; start searching in char. pos. 0
                bb = 0
                cnt_det = 0
                while (ii ne -1) do begin
                  ii = strpos (RestString, ' ', ii)  ; one " " is found
                  if (ii ne -1) then begin   
                    ll = ii-bb              ; length of string
                    detectors(cnt_det) = $
                      strtrim(strmid(RestString,bb,ll),2)
                    ii = ii + 1
                    bb = ii      ; next string-start position
                    cnt_det= cnt_det + 1
                  end else begin
                    detectors(cnt_det) = $
                      strtrim(strmid(RestString,bb,(strlen(RestString)-bb)),2)
                    cnt_det= cnt_det + 1
                  end
                endwhile
                Ines_Print, " --- "
                Ines_Print, " header:  Encoder column: "+string(detectors(0))
                Ines_Print, "          inc_del column: "+string(detectors(1))
                Ines_Print, "          fwd_del column: "+string(detectors(2))
                Ines_Print, "          inc_mon column: "+string(detectors(3))
                Ines_Print, "          fwd_mon column: "+string(detectors(4))
                Ines_Print, " --- "
              end
     '#HRM ': begin
	   	resolution=PhonA_GetMonochromatorResolution(RestString)
	      Ines_Print, " resolution("+RestString+") = "+ $
              string(resolution)+" meV/enc_steps"
	  endcase
     '#SCAN': begin
              Ines_Print, " scans: "+ RestString
              ii = 0           ; start searching in char. pos. 0
              bb = 0
              ee = 0
              while (ii ne -1) do begin
                ii = strpos(RestString, ',', ii) ; find position of ","
                if (ii ne -1) then begin   
                  ll = ii-bb          ; length of string
                  ScanN(CountScans(CountFile),CountFile) = $
                        fix(strtrim(strmid(RestString,bb,ll),2))
                  ii = ii + 1
                  bb = ii      ; next string-start position
                  CountScans(CountFile) = CountScans(CountFile) +1
                end
                if (ii eq -1) then begin
                  ScanN(CountScans(CountFile),CountFile) = $
                  fix(strtrim(strmid(RestString,bb,(strlen(RestString)-bb)),2))
                  CountScans(CountFile) = CountScans(CountFile) +1
                end
              endwhile
              end
       else  : begin
                 Ines_Print, " "
               end
    endcase 
    i=i+1
  endwhile
  CountScanMax = max(CountScans(*))-1
  free_lun, InFile
  Ines_Print, "===================================================================="
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;;  read parameters for actual scanfile
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro PhonA_ReadScanPar, head, ScanDate, Month_ii, Day_ii, Time_ii
  DateN = strarr(8)
  nn = 0
  ii = 0
  ll = 0
  bb = 0
  while (ii ne -1) do begin
    ii = strpos(ScanDate,' ',ii)           ; one " " is found
    if (ii ne -1) then begin   
      ll = ii - bb                    ; length of string
      DateN(nn) = strtrim(strmid(ScanDate,bb,ll),2)
      if (strpos(DateN(nn),':') ne -1) then begin
        tt = strarr(3)   
        tt(0) = strmid(DateN(nn),0,2)
        tt(1) = strmid(DateN(nn),3,2)
        tt(2) = strmid(DateN(nn),6,2)
        DateN(nn:(nn+2))=tt
        nn=nn+2
      end
      nn = nn + 1
      ii = ii + 1
      bb = ii               ; next string-start position
    end
    if (ii eq -1) then begin   
      DateN(nn) = strtrim(strmid(ScanDate,bb,(strlen(ScanDate)-bb)),2)
    end
  endwhile
  Month_ii = DateN(2)
  Day_ii =  DateN(3) * 1
  Time_ii =  60 * ((60 * DateN(4)) + DateN(5)) + DateN(6)
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;;  find E=0 position
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro PhonA_findzero, a, na, det, zero, a0max
  a1max = max(a(det,*),a0max)
  Ines_Print,string(format='(" scan contains ", I4, " points ")',na)
  Ines_Print,string($
   format='(" max f-delayeds:",I5," (channel",I4,") at enc_pos ",F11.1)',$
                 fix(a1max), a0max, a(0,a0max))
  pregion = where(a(det,*) ge a1max/3.)
  zero = total(a(det,pregion)*a(0,pregion))/total(a(det,pregion))
  Ines_Print,string(" zero position at                       ", zero)
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;;  Normalization
;
;  take Monitor value of point E=0 as average monitor 
;  value for this scan
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro PhonA_normalize, a, det, mon, zero
  a(det+2,*) = abs((a(det+2,*) / a(mon,*)) * a(mon,zero))
  a(det,*) = (a(det,*) / a(mon,*)) * a(mon,zero)
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;;  Energy scaling
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro PhonA_setescale, b, zero, scalefac
  b = (b - zero) * scalefac
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;;  Find Energy Boundaries
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro PhonA_FindEnergyBoundaries, a, numberE, Emin, Emax, mevBin
  Ines_Print,'FindEnergyBoundaries:'
  Emax = max(a(0,*),EmaxChannel)
  Emin = min(a(0,*),EminChannel)
  AbsEmin = Floor ((abs(Emin)-(mevBin/2))/mevBin) * mevBin
  SignEmin = Emin / abs(Emin)
  AbsEmax = Floor ((abs(Emax)-(mevBin/2))/mevBin) * mevBin
  SignEmax = Emax / abs(Emax)
  Emax = AbsEmax * SignEmax
  Emin = AbsEmin * SignEmin
  numberE = ((Emax - Emin) / mevBin) + 1
  Ines_Print,string( format='(" Minimum energy: ",F7.2)', Emin)
  Ines_Print,string( format='(" Maximum energy: ",F7.2)', Emax)
  Ines_Print,string( format='(" Number of points: ",F5.0)', numberE)
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;;  binning
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro PhonA_binmev, a, e, numberE, Emin, Emax, mevBin, det, Points 
  for i = 0, numberE-1  do begin
    DeltaI = where ( ( a(0,*) ge (e(0,i)-mevBin/2) )   AND       $
                     ( a(0,*) lt (e(0,i)+mevBin/2) ) , count )
    case count of
         0 : begin 
               e(det,i) = 0.
               e(det+2,i) = 0.
               e(Points,i) = count
             end
      else : begin   
               e(det,i) = total(a(det,DeltaI)) / count
               ;;;;;;;;;;;;;;;;;;
               ; error = sqrt(sum(x_error^2)) / (number of x)
               ;;;;;;;;;;;;;;;;;;
               e(det+2,i) = sqrt(total(a(det+2,DeltaI)^2)) / count
               e(Points,i) = count
             end
    endcase
  endfor
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;;  Sum up Scans in esum
;
;   ~~~~ = points defined in esum before adding e
;   .... = points defined in e              
;                        
;                        |
;                 ~~~~~~~|~~~~~~~~~~~~~~~~~       
;                        | 
;          ..............|.......                 
;                        |
;      ----|------|------|------|---------|----> energy
;          a      b     E=0     c         d
;
;   a-b : case 1 of ((e_b gt -1) AND (esum_b lt  0))
;   b-c : case 1 of ((e_b gt -1) AND (esum_b gt -1))
;   c-d : case 1 of ((e_b lt  0) AND (esum_b gt -1))
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro PhonA_SumScans, e, numberE, esum, mevBin, Points, DetInc, DetFwd
  numberEsum = n_elements(esum(0,*))
  Bmin = e(0,0) < esum(0,0)
  Bmax = e(0,numberE-1) > esum(0,numberEsum-1)
  numberB = ((Bmax - Bmin) / mevBin) + 1.
  b = dblarr(7, numberB) * 0.0
  b(0,*) =  mevBin * FINDGEN(numberB) + Bmin
  for i = 0, numberB-1  do begin
    e_b = total(where(abs((b(0,i)-e(0,*))) lt 0.0001))  
    esum_b = total(where(abs((b(0,i)-esum(0,*))) lt 0.0001))
    case 1 of 
     ((e_b lt 0) AND (esum_b gt -1)): begin 
        b(Points,i) = esum(Points,esum_b) 
        b(DetInc,i) = esum(DetInc,esum_b) 
        b(DetFwd,i) = esum(DetFwd,esum_b) 
        b(DetInc+2,i) = esum(DetInc+2,esum_b) 
        b(DetFwd+2,i) = esum(DetFwd+2,esum_b) 
       end
     ((e_b gt -1) AND (esum_b lt 0)): begin 
        b(Points,i) = e(Points,e_b) 
        b(DetInc,i) = e(DetInc,e_b) 
        b(DetFwd,i) = e(DetFwd,e_b) 
        b(DetInc+2,i) = e(DetInc+2,e_b) 
        b(DetFwd+2,i) = e(DetFwd+2,e_b) 
       end
     ((e_b gt -1) AND (esum_b gt -1)): begin
        b(Points,i) = e(Points,e_b) + esum(Points,esum_b)
        if (b(Points,i) eq 0.) then uu = 1
        if (b(Points,i) gt 0.) then uu = b(Points,i)
          
        b(DetInc,i) = (e(DetInc,e_b) * e(Points,e_b) + $
                      esum(DetInc,esum_b) * esum(Points,esum_b)) / uu
        b(DetFwd,i) = (e(DetFwd,e_b) * e(Points,e_b) + $
                      esum(DetFwd,esum_b) * esum(Points,esum_b)) / uu
        b(DetInc+2,i) = sqrt((e(DetInc+2,e_b) * e(Points,e_b))^2 + $ 
                        (esum(DetInc+2,esum_b) * esum(Points,esum_b))^2) / uu 
        b(DetFwd+2,i) = sqrt((e(DetFwd+2,e_b) * e(Points,e_b))^2 + $
                        (esum(DetFwd+2,esum_b) * esum(Points,esum_b))^2) / uu
       end
     else: Ines_Print, "error in summing up!"
    endcase
  endfor
  esum = b
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;; write to file
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro PhonA_WriteToFile, b, MyFile, MyHeader
    openw, OutFile, MyFile, /get_lun    ; open the file for writing
    printf,OutFile,MyHeader
    printf,OutFile,$
     format='(F10.3,3X,F10.3,3X,F10.3,3X,F10.3,3X,F10.3,3X,F10.0)',$ 
     b([0,1,2,3,4,5],*)
    free_lun, OutFile
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;; define plotting
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro PhonA_plosym
  s = findgen(8) * (!pi*2/8.)
  usersym, cos(s), sin(s), /fill
  !x.range = [0,0]
  !y.range = [0,0]
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;; plot on printer
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro PhonA_printerr_file, b, det, MyComment, MyFilePS
  AW = 'n'
  AWno = 0
  xx1 = min(b(0,*))-10
  xx2 = max(b(0,*))+10
  yy1 = min(b(det,*))
  yy2 = max(b(det,*))+max(b(det+2,*))
  xplot,parent=xplot_p,/no_block,coltitles=['X','Y'],$
		  xtitle='-1',ytitle='-1',wtitle=MyComment,$
		  [b(0,*),b(det,*)]
  
;  plot, [xx1,xx2],[yy1,yy2],PSYM=8, thick=3, title=MyComment, font=4, /NODATA
;  oploterr, b(0,*), b(det,*), b(det+2,*),4
;  repeat begin
;    Ines_Print, '   Plot spectrum on file (ps format) --> p  '
;    Ines_Print, '   Change axis                       --> c '
;    Ines_Print, '   Do nothing                        --> <RET> '
;    read, AW, PROMPT='   -->  Your Choice: '
;    case strupcase(AW) of
;      'P': begin
;             AW = MyFilePS
;             MyTitle =  MyComment + '   filename: ' + AW
;             catch, error_status
;             PhonA_Check_MyErrors, error_status, AW
;				  myDevice=!D.NAME
;             SET_PLOT, 'PS'
;             device, filename = AW, /helvetica, /bold, /landscape
;             plot,[xx1,xx2],[yy1,yy2],PSYM=8,thick=3,$
;      title=MyTitle,font=4,/NODATA
;             oploterr, b(0,*), b(det,*), b(det+2,*),4
;             DEVICE, /CLOSE
;             SET_PLOT, myDevice
;           end
;      'C': begin
;             !x.range = [0,0]
;             !y.range = [0,0]
;             read, xx1, PROMPT=' -> lower limit of x-axis: '  
;             read, xx2, PROMPT=' -> upper limit of x-axis: '  
;             read, yy1, PROMPT=' -> lower limit of y-axis: '  
;             read, yy2, PROMPT=' -> upper limit of y-axis: '  
;             plot,[xx1,xx2],[yy1,yy2],PSYM=8,thick=3,$
;      title=MyComment,font=4,/NODATA
;             oploterr, b(0,*), b(det,*), b(det+2,*),4
;           end
;     else:  AWno = 1
;    endcase
;  endrep until AWno
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;; plot_err on screen
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro PhonA_ploterr_screen, b, det, MyTitle
  xx1 = min(b(0,*))-10
  xx2 = max(b(0,*))+10
  yy1 = min(b(det,*))
  yy2 = max(b(det,*))+max(b(det+2,*))
  plot, [xx1,xx2],[yy1,yy2],PSYM=8, thick=3, title=MyTitle, font=4, /NODATA
  oploterr, b(0,*), b(det,*), b(det+2,*),4
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;    Main program
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO PHONA
	PhonVersion = ""
	PhonA_GetVersion,  PhonVersion
	PhonA_ProgStamp, PhonVersion 
	RingRing = string(7B)            ; ring the Bell!
	ScanFile = strarr(10)            ; scanfile names
	ScanFil = ''                  ; actual scanfile name
	CountFile = 0               ; number of scan files
	CountScans =  intarr(10)            ; number of scans per file
	ScanN = intarr(1000, 10)            ; scan numbers for every scanfile
	scannum = 0                   ; actual scan number
	CountScanMax = 0               ; maximum of CountScans
	Detectors =  strarr(5)            ; detector names in the scanfile:
                                    	  ; enc, det_inc, det_fwd, mon_inc, mon_fwd
	ScanMonth = strarr(1000, 10)            ; month of scan begin
	ScanDay = intarr(1000, 10)            ; day of scan begin
	ScanTime = fltarr(1000, 10)            ; time of scan begin
	ScanPointTime = intarr(1000, 10)      ; measured time per point
	EncZero = fltarr(1000, 10)            ; E=0 encoder position for each scan
	EncZero_ii = 0.000               ; E=0 encoder position for actual scan  
	ChanZero_ii = 0               ; E=0 channel for actual scan
	Correction = fltarr(1000, 10)         ; estimated correction of resolution
	ScanVelocity = fltarr(1000, 10)       ; velocity of the inchworm in 
                                    	  ; enc_steps/second
	Ines_Print, " "
	ParFile = ''
	Ines_Print, " Please define the name of the parameter input file ---> "
	rinvio: ParFile = Dialog_PickFile (/read, Filter='*.in')
	if (ParFile eq '') then begin
   	Ines_Print, ''
   	Ines_Print, ' Please select a file! ---> '
   	goto, rinvio
	endif 
	Ines_Print, " Read Parameters from "+ ParFile
	PhonA_ReadParameters, ParFile, ScanFile, ScanN, CountFile, CountScans, $
               	 CountScanMax, Detectors, resolution
	ScanFile = ScanFile(0:CountFile)
	CountScans =  CountScans(0:CountFile)
	ScanN = ScanN(0:CountScanMax,0:CountFile)
	ScanMonth = ScanMonth(0:CountScanMax,0:CountFile)
	ScanDay = ScanDay(0:CountScanMax,0:CountFile)
	ScanTime = ScanTime(0:CountScanMax,0:CountFile)
	ScanPointTime = ScanPointTime(0:CountScanMax,0:CountFile)
	EncZero = EncZero(0:CountScanMax,0:CountFile)
	ScanVelocity = ScanVelocity(0:CountScanMax,0:CountFile)
	Correction = Correction(0:CountScanMax,0:CountFile)
	CorrectionYN = 0
	Correct= ''
	Ines_Print, " -> Correction of the energy calibration makes only sense,  "
	Ines_Print, " -> when the measured time per point is constant for all scans! "
	Ines_Print, " "
	;read,Correct, PROMPT='Correct the energy calibration? (no: <n>, yes: <y>)'
	;rinvio2: Correct = strupcase(Correct)
	out1	  =  { Out1, $
					 correct_energy_cal: ['1',$
						 			  'No',$
									  'Yes']}
	XSCRMENU,out1,/interpret,titles=['Correct Energy calibration ?'],$
			action=action,WTITLE='Energy calibration'
	reads,out1.correct_energy_cal(0),CorrectionYN
	if CorrectionYN eq 1 then begin
	  Correct='Y'
	  CorrectionYN = 1
	  Ines_Print, ''
	  Ines_Print, " energy calibration correction is switched on!"
	endif else begin
	  Correct='N'
	  CorrectionYN = 0
	  Ines_Print, ''
	  Ines_Print, " energy calibration correction is switched off!"
	endelse
	
	Ines_Print, " "
	;; detectors:
	D_Enc=0
	D_DetInc=1
	D_DetFwd=2
	D_MonInc=3
	D_MonFwd=4
	;; a, e, esum:
	Enc=0
	DetInc=1
	DetFwd=2
	DetIncErr=3
	DetFwdErr=4
	MonInc=5
	MonFwd=6
	Points=5
	PhonA_plosym
	CountFile_ii = 0
	CountScans_ii = 0
	dummy = ''
	MyFile = 'dummy'
	;catch, error_status
	;PhonA_Check_MyErrors, error_status, MyFile
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; loop over all scanfiles ;;;;;;;;;;;;;;;
	repeat begin
	  ScanFil = ScanFile(CountFile_ii)
	  nscans = SPEC_ACCESS(sphandel, ScanFil)
	  Ines_Print, " File "+string(ScanFil)+ " contains "+string(nscans)+" scans."
	  Ines_Print, " =========================="
	  CountScans_ii = 0
	  ;;;;;;;;;;;;;;;;;;;;;;;; loop over all scans in scan file ;;;;;;;;;;;;;;;
	  repeat begin               
   	 scannum = ScanN(CountScans_ii,CountFile_ii)
   	 Ines_Print, "  ...................................................."
   	 Ines_Print, "  SCAN:"+string(scannum)+"  FILE:  "+string(ScanFil)
   	 if scannum gt 0 then begin
      	na = SPEC_POINTS(sphandel, scannum)
      	a = dblarr(7, na)
      	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
      	; read scan data into a: 
      	; a(0,*) = a(Enc,*)      = b1222_enc         : encoder value
      	; a(1,*) = a(DetInc,*)   = Del2/vct6         : 4 pi delayeds
      	; a(2,*) = a(DetFwd,*)   = Del1/vct4         : forward delayeds
      	; a(3,*) = a(DetInc+2,*) = sqrt(Del2/vct6)   : error of 4 pi delayeds
      	; a(4,*) = a(DetFwd+2,*) = sqrt(Del1/vct4)   : error of forward delayeds
      	; a(5,*) = a(MonInc,*)   = Pico1 or Pr4p/vct5: ion chamber or 4 pi prompt
      	; a(6,*) = a(MonFwd,*)   = Pico1             : ion chamber
      	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
      	a([Enc,DetInc,DetFwd,MonInc,MonFwd],*) = $
                        	 spec_data(sphandel, scannum, [Detectors(D_Enc),    $
                                 	 Detectors(D_DetInc), Detectors(D_DetFwd), $ 
                                 	 Detectors(D_MonInc), Detectors(D_MonFwd)])
      	a(DetInc+2,*) = sqrt(a(DetInc,*))
      	a(DetFwd+2,*) = sqrt(a(DetFwd,*))
      	;;;;;;;;
      	;  read epoch from scan file to define scan velocity (enc_steps/second)
      	;;;;;;;;
      	epoch = dblarr(2, na)
      	epoch([0,1],*) = spec_data(sphandel, scannum, ["Epoch",Detectors(D_Enc)])
      	ScanVelocity(CountScans_ii,CountFile_ii) = $
               	  (epoch(1,na-1)-epoch(1,0))/(epoch(0,na-1)-epoch(0,0))
      	;Ines_Print, format='(" scan velocity  :",F10.5, " enc_steps/second" )',$
         ;                  	  ScanVelocity(CountScans_ii,CountFile_ii)
      	Ines_Print,string(" scan velocity  :"+strtrim(ScanVelocity(CountScans_ii,CountFile_ii),2)$
					+" enc_steps/second")
      	;;;;;;;;
      	; read useful parameters from scan file
      	;  - header
      	;  - starting time of each scan 
      	;;;;;;;;
      	head = ''
      	Month_ii=''
      	Day_ii=0
      	Time_ii=0.0
      	PointTime_ii=0
      	head = spec_headers(sphandel, scannum, ['#S'])
      	ScanDate = strcompress(spec_headers(sphandel, scannum, ['#D']))
      	PhonA_ReadScanPar, head, ScanDate, Month_ii, Day_ii, Time_ii
      	ttt = spec_data(sphandel, scannum, "Seconds")
      	PointTime_ii = ttt(0)
      	;Ines_Print, format='(" measured time per point:",F4.1," seconds" )', $
         ;                  	 PointTime_ii
      	Ines_Print,string(" measured time per point: ",strtrim(PointTime_ii,2)," seconds")
      	;;;;;;;;
      	; define countrates per second
      	; and count the measured time per point for all scans
      	; to correct the countrate afterwards in ScanPointTime
      	;;;;;;;;
      	a([DetInc,DetFwd,DetInc+2,DetFwd+2,MonInc,MonFwd],*) = $
            	  a([DetInc,DetFwd,DetInc+2,DetFwd+2,MonInc,MonFwd],*)/PointTime_ii
      	if (Detectors(D_MonInc) eq 'Pico1') or (Detectors(D_MonInc) eq $
                           	 'Pico2') then $
            	  a(MonInc,*) = a(MonInc,*)*PointTime_ii
      	if (Detectors(D_MonFwd) eq 'Pico1') or (Detectors(D_MonFwd) eq $
                           	 'Pico2') then $ 
            	  a(MonFwd,*) = a(MonFwd,*)*PointTime_ii
      	ScanPointTime(CountScans_ii,CountFile_ii) = PointTime_ii
      	;;;;;;;;
      	; define COM of DetFwd (Fwd-delayeds) as zero energy
      	;;;;;;;;
      	PhonA_findzero, a, na, DetFwd, EncZero_ii, ChanZero_ii
      	if ((CountScans_ii eq 0) AND (CountFile_ii eq 0)) then $
                                       	EncZero_00 = EncZero_ii
      	EncZero(CountScans_ii,CountFile_ii) = EncZero_ii - EncZero_00
      	;;;;;;;;
      	; normalize data with monitor signal at E=0
      	;;;;;;;;
      	PhonA_normalize, a, DetInc, MonInc, ChanZero_ii 
      	PhonA_normalize, a, DetFwd, MonFwd, ChanZero_ii 
      	;;;;;;;;
      	; estimation of correction of resonance instability
      	;  - Time is here the time where E=0 (relative to the first scan)
      	;;;;;;;;
      	if ((CountScans_ii eq 0) AND (CountFile_ii eq 0)) then  begin
      	  Month_00 =  Month_ii 
      	  Day_00  =  Day_ii 
      	  PointTime_00 = PointTime_ii 
      	  Time_00  = epoch(0,0) + (ChanZero_ii * PointTime_ii)
      	  Epoch_00 = epoch(0,0)
      	end
      	ScanMonth(CountScans_ii,CountFile_ii) = Month_ii
      	ScanDay(CountScans_ii,CountFile_ii) = Day_ii
      	case 1 of
      	  ((Day_ii-Day_00) ge 0) : DeltaDay = Day_ii-Day_00
      	  else :                   DeltaDay = Day_ii-Day_00+max(ScanDay)
      	endcase
      	ScanTime(CountScans_ii,CountFile_ii) = $
                  	  epoch(0,0)+(ChanZero_ii*PointTime_ii)-Time_00
      	case 1 of
      	  ((CountScans_ii eq 0) AND (CountFile_ii eq 0)): begin
            	OldScans_ii = CountScans_ii
            	OldFile_ii  = CountFile_ii
            	Correction(0,0) = 1  
         	 end
      	  else: begin
            	DeltaZero = EncZero(CountScans_ii,CountFile_ii) - $
                        	EncZero(OldScans_ii,OldFile_ii)
            	DeltaTime = ScanTime(CountScans_ii,CountFile_ii) - $ 
                        	ScanTime(OldScans_ii,OldFile_ii)
            	Correction(CountScans_ii,CountFile_ii) = $
                        	1. - ((DeltaZero / DeltaTime) / ScanVelocity(0,0))
            	OldScans_ii = CountScans_ii
            	OldFile_ii  = CountFile_ii
         	 end
      	endcase
      	case CorrectionYN of
         	  1: resolution_ii = Correction(CountScans_ii,CountFile_ii) $
               	 * resolution
         	  0: resolution_ii = resolution
      	endcase
      	;;;;;;;;
      	; calibrate encoder positions to energy values
      	;;;;;;;;
      	aEnergy = a(0,*)
      	PhonA_setescale, aEnergy, EncZero_ii, resolution_ii
      	a(0,*) = aEnergy
      	;;;;;;;;
      	; search the right energy boundaries
      	;   and create the energy values e(0,*)
      	;;;;;;;;
      	MyHint = abs(a(0,0)-a(0,na-1))/na
      	Ines_Print, " mean energy step: "+string(MyHint)+" meV"
      	if ((CountScans_ii eq 0) AND (CountFile_ii eq 0)) then begin
      	  ;read, mevBin, prompt=' ----> binning in how many meVs : '
			  mevBin=MyHint
			  tmp=mevBin
			  xscrmenu,tmp,name='binning in how many meVs (mean step given as default):',/notype
      	  reads,tmp,mevBin
			  mevBin=float(mevBin)
			  MyHeaderStamp1= strcompress(string(mevBin), /remove_all)
      	  MyHeaderStamp= " [binsize="+MyHeaderStamp1+"meV] " + PhonVersion
      	end
			Ines_Print,mevBin
      	PhonA_FindEnergyBoundaries, a, numberE, Emin, Emax, mevBin 
      	e = dblarr(7, numberE)
      	e(Enc,*) =  mevBin * FINDGEN(numberE) + Emin
      	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
      	; fill energy table e(i,*): 
      	; e(0,*) = e(Enc,*)      = b1222_enc         : energy in meV 
      	; e(1,*) = e(DetInc,*)   = Del2/vct6         : 4 pi delayeds
      	; e(2,*) = e(DetFwd,*)   = Del1/vct4         : forward delayeds
      	; e(3,*) = e(DetInc+2,*) = sqrt(Del2/vct6)   : error of 4 pi delayeds
      	; e(4,*) = e(DetFwd+2,*) = sqrt(Del1/vct4)   : error of forward delayeds
      	; e(5,*) = e(Points,*)   = Points            : number of measured points 
      	;                                              for this energy
      	; e(6,*) = e(unused,*)   = 
      	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
      	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
      	PhonA_binmev, a, e, numberE, Emin, Emax, mevBin, DetInc, Points 
      	PhonA_binmev, a, e, numberE, Emin, Emax, mevBin, DetFwd, Points
      	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
      	; add up scans esum(i,*): i=0,1,2,3,4,5,6 like for e(i,*)  
      	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
      	if ((CountScans_ii eq 0) AND (CountFile_ii eq 0)) then  begin
         	  esum = e 
         	  sss = 1
      	MyHeader_sss = '1 '
         	  MyHeader = " First scan "+MyHeaderStamp
         	  PhonA_ploterr_screen, esum, DetInc, MyHeader
      	  end else begin
         	  sss = sss + 1 
         	  MyHeader_sss = strcompress(string(sss), /remove_all)
         	  PhonA_SumScans, e, numberE, esum, mevBin, Points, DetInc, DetFwd
         	  MyHeader =MyHeader_sss+" scans added "+MyHeaderStamp
         	  PhonA_ploterr_screen, esum, DetInc, MyHeader
      	end
      	;;;;;;;;
      	;   write results to file/screen/plotter
      	;;;;;;;;
      	MyHeader_all = "      4pi_del      fwd_del    4pi_del_err  fwd_del_err"
      	MyHeader_esum = "    Energy "+ MyHeader_all+$
                     	 "     Npoints"
      	MyHeader_e =    "e:    Energy "+ MyHeader_all+$
                     	 "    Npoints    ------  "+MyHeaderStamp
      	MyHeader_a =    "a:   Encoder "+ MyHeader_all+$
                     	 " 4pi_mon  fwd_mon " + PhonVersion 
      	MyFile = strcompress(string(ScanFil,'_',scannum,'.e'), /remove_all)
      	MyFile = strcompress(string(ScanFil,'_',scannum,'.a'), /remove_all)
   	 endif
   	 CountScans_ii = CountScans_ii + 1
	  endrep until CountScans_ii ge CountScans(CountFile_ii)
	  ;;;;;;;;;;;;;;;;;;;;;;;; loop over all scans in scanfile ;;;;;;;;;;;;;;; 
	  CountFile_ii = CountFile_ii + 1
	endrep until CountFile_ii gt CountFile
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; loop over all scanfiles ;;;;;;;;;;;;;;; 
	;;;;;;;;
	; up to now we have counts/sec in esum(DetInc,*) and esum(DetFwd,*)
	; now multiply with seconds measured in average per energy bin  
	; to get reasonable counts
	;;;;;;;;
	Ines_Print, "  ...................................................."
	Ines_Print, "  ...................................................."
	PointTimeFactor = (total(esum(Points,*))*(total(ScanPointTime)/sss))/$
                     	n_elements(esum(Points,*))
	esum([DetInc,DetFwd,DetInc+2,DetFwd+2],*) = $
                  	esum([DetInc,DetFwd,DetInc+2,DetFwd+2],*)*PointTimeFactor
	Ines_Print, string(fix(total(esum(Points,*)))," measured points,")
	Ines_Print, string(total(ScanPointTime)/sss)+  $
      	 " seconds measured in average per point,"
	Ines_Print, string(PointTimeFactor," seconds measured in average per energy bin")
	Ines_Print, "  ...................................................."
	Ines_Print, "  ...................................................."
	;;;;;;;;
	; do all plots and printouts
	;;;;;;;;
	Ines_Print, "  ***************************************************"
	MyHeader_esum1 = strcompress(string(PointTimeFactor), /remove_all)
	MyHeader_esum2 = MyHeader_esum1+" seconds per point "+$
               	  MyHeader_sss+" scans added "+'!C'+MyHeaderStamp 
	Ines_Print, "   --> Name for data file containing summed scans?"
	;Ines_Print, "        (no extension, please)"
	MyFileAW = ''
	MyFileAW = Dialog_PickFile (/write, Filter='*.dat')
	;remove .dat extension, if present
	name_cut=STRPOS(MyFileAW, '.dat')
   if name_cut(0)ne -1 then MyFileAW=STRMID(MyFileAW, 0, name_cut(0))

	if MyFileAW eq '' then MyFileAW = 'output_file'
	MyFile = MyFileAW + ".dat"
	PhonA_WriteToFile, esum, MyFile, MyHeader_esum
	Ines_Print, "  ***************************************************"
	Ines_Print, "  wrote file: " + MyFile
	MyFilePS = MyFile+".ps"
	
	;Moved to the end so we don't overdraw the xplot window
	;PhonA_printerr_file, esum, DetInc, MyHeader_esum2, MyFilePS
	
	Ines_Print, "  ***************************************************"
	MyFile = MyFileAW + ".par"
	openw, ZeroFile, MyFile, /get_lun    ; open the file for writing
	printf,ZeroFile, "### "+MyHeaderStamp +" ### "
	printf,ZeroFile, $
	format=$
	 '("     File  "," #Scan ","   E=0  "," t<sec> ","scan_veloc. ","cal_corr. ")'
	Ines_Print, string(MyHeaderStamp)
	Ines_Print,"     File   #Scan    E=0   t<sec> scan_veloc. cal_corr. "
	for j=0,CountFile do begin
	  for i=0,CountScanMax do begin
   	 if (ScanN(i,j) gt 0) then begin
      	Ines_Print, string(format = '(A10, I5, F10.2, F10.2, F10.6, F10.6)',$
      	 ScanFile(j),ScanN(i,j),EncZero(i,j),ScanTime(i,j),$
      	 ScanVelocity(i,j),Correction(i,j))
      	printf,ZeroFile, format='(A10, I5, F10.2, F10.2, F10.6, F10.6)',$
      	 ScanFile(j),ScanN(i,j),EncZero(i,j),ScanTime(i,j),$
      	 ScanVelocity(i,j),Correction(i,j)
   	 end
	  endfor
	endfor
	free_lun, ZeroFile
	Ines_Print, "  ***************************************************"
	Ines_Print, "  wrote file: " + MyFile
	Ines_Print, "  ***************************************************"
	!P.MULTI = [0,2,2]
	My1y = "number of points per energy bin "  
	My1x = "energy <meV> " 
	My2y = "scan velocity <enc_steps/sec>"
	My2x = "scan time <hours>" 
	My3y = "Encoder zero position"
	My4y = "calibration correction factor"
	MyHeader = MyFile+'  '+MyHeaderStamp+'!C'+MyHeader_esum2
	!P.MULTI = [0,2,2]
	!x.range = [0,0]
	!y.range = [0,0]
	plot, esum(Enc,*), esum(Points,*) , PSYM=8, thick=3, $
      	title=MyHeader, xtitle=My1x, ytitle=My1y
	!x.range = [0,0]
	!y.range = [0,0]
	plot, ScanTime/3600, ScanVelocity, PSYM=8, thick=3, $ 
      	xtitle=My2x, ytitle=My2y
	!x.range = [0,0]
	!y.range = [0,0]
	plot, ScanTime/3600 , EncZero, PSYM=8, thick=3, $ 
      	xtitle=My2x, ytitle=My3y
	!y.range = [0.95, 1.05]
	!x.range = [0,0]
	plot, ScanTime/3600 ,Correction, PSYM=8, thick=3, $ 
      	xtitle=My2x, ytitle=My4y
	!x.range = [0,0]
	!y.range = [0,0]
	!P.MULTI = 0
	;;;;;;;;;;;;;;;;;;;;;;;;;;;
	MyFilePS = MyFile + '.ps'
	MyHeader = MyFilePS+'  '+MyHeaderStamp+'!C'+MyHeader_esum2
	myDevice= !D.NAME
	SET_PLOT, 'PS'
	device, filename = MyFilePS, /helvetica, /bold, /landscape
	!P.MULTI = [0,2,2]
	!x.range = [0,0]
	!y.range = [0,0]
	plot, esum(Enc,*), esum(Points,*) , PSYM=8, thick=3, font=4, $
      	title=MyHeader, xtitle=My1x, ytitle=My1y
	!x.range = [0,0]
	!y.range = [0,0]
	plot, ScanTime/3600, ScanVelocity, PSYM=8, thick=3,font=4, $ 
      	xtitle=My2x, ytitle=My2y
	!x.range = [0,0]
	!y.range = [0,0]
	plot, ScanTime/3600 , EncZero, PSYM=8, thick=3, font=4, $
      	xtitle=My2x, ytitle=My3y
	!y.range = [0.95, 1.05]
	!x.range = [0,0]
	plot, ScanTime/3600 ,Correction, PSYM=8, thick=3, font=4, $
      	xtitle=My2x, ytitle=My4y
	!x.range = [0,0]
	!y.range = [0,0]
	DEVICE, /CLOSE
	!P.MULTI = 0
	SET_PLOT,myDevice
	Ines_Print, "  wrote file: " + MyFilePS
	Ines_Print, "  ***************************************************"
	;;;;;;;;;;;;;;;
	Ines_Print, "  ==================================================="
	Ines_Print, "              finished summing up scans !            " 
	Ines_Print, "  ==================================================="
	Ines_Print, " "
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	PhonA_printerr_file, esum, DetInc, MyHeader_esum2, MyFilePS
END




















