FUNCTION MPP_New,n,Pointer=pointer

;+
; 
; NAME: 
;	MPP_New
;
; PURPOSE:
;	This function returns a MPP handle, that could be a structure
;	or a pointer.
;
; CATEGORY:
;	MPP utilities to handle multiple array data
;
; CALLING SEQUENCE:
;	out = MPP_New()
;
; OPTIONAL INPUTS:
;     n: the dimension of the MPP handler (i.e., number of arrays 
;	stored).
;
; KEYWORD PARAMETERS:
;     POINTER: When set, the handler is a pointer, otherwise is 
;	a structure or array of structures. 
;
;
; EXAMPLES:
;	mpp = MPP_New()
;	mpp_set,mpp,Value=fltarr(3,3),/Add
;	tmp = mpp_info(mpp,/Verbose)
;	mpp_free,mpp  
;
; MODIFICATION HISTORY:
;	Initial version by M. Sanchez del Rio, February 2000.
;
;-
IF N_Elements(n) EQ 0 THEN RETURN,Ptr_New()

IF n EQ 0 THEN  RETURN,Ptr_New()

tmp = Replicate({mpp},n)
IF Keyword_Set(pointer) THEN out=Ptr_New(tmp) ELSE out=Temporary(tmp)

RETURN,out
END
