;+
; NAME:
;
;        TOPOSTART
;
; PURPOSE:
;
;        The start procedure for the TOPO surface topography library.
;
; CATEGORY:
;
;        Topographic analysis
;
; CALLING SEQUENCE:
;
;        At the IDL command line, type ".run TOPOSTART".
; 
; COMMON BLOCKS:
;
;        COMMON TOPO,TOPOHOME,TOPO
;        COMMON PLOT_PRINT,PRINTPARS (See PLOT_PRINT)
;
; PROCEDURE:
;
;        The site-configuration file (topositeconfig.pro) is read,
;        defining widget fonts, etc.  The topo save file is loaded
;        into IDL, using the RESTORE command.
;
; RESTRICTIONS:
; 
;        Requires IDL version 5.1 or higher.
;
;        UNITS and PRECISION:
;
;        When using any of the topo plot procedures: PLOT_PROF,
;        PLOT_SLOPE, PLOT_H_DIST, PLOT_S_DIST, PLOT_AUTOCOV, and
;        PLOT_PSD, or the procedures ANLZ_PROF, XANLZ_PROF, XANLZ_PSD,
;        and XANLZ_SURF, the data length (X for 1D, or X and Y for 2D)
;        and height (Y for 1D, or Z for 2D) units MUST ALL BE IN
;        ANGSTROMS.  However, the common block variable TOPO is used
;        to control the units that are actually displayed.
;        
;        In particular, the variables TOPO.XUNITS_PTR and
;        TOPO.YUNITS_PTR determine the units for lengths and heights,
;        respectively; set TOPO.XUNITS_PTR to 0 for angstroms, 1 for
;        nm, 2 for microns, or 3 for mm.  Same goes for
;        TOPO.YUNITS_PTR.
;
;        The precision of the fit parameters that are labelled on the
;        plots is determined by the values of the variables
;        TOPO.XPRECISION for length-related parameters (e.g.,
;        correlation length), TOPO.YPRECISION for height-related
;        parameters (e.g., rms roughness), and TOPO.SPRECISION for
;        slope-related parameters (e.g., rms slope.)  For example, if
;        TOPO.XPRECISION=3, then three places to the right of the
;        decimal will be displayed.
;
;        The TOPO.*UNITS_PTR and TOPO.*PRECISION variables can either
;        be set explicitly before executing any of the aforementioned
;        procedures, or they can be set transparently to the user be
;        selecting the appropriate menu items when using the
;        XANLZ_PROF, XANLZ_PSD, or  XANLZ_SURF procedure.
;
; MODIFICATION HISTORY:
;
;      David L. Windt, Bell Laboratories, May 1997
;      V2.03: June 1998
;      V2.04: December 1998
;      V2.05: September 2000
;      
;      windt@astro.columbia.edu
;
;-

common topo,topohome,topo
common plot_print,printpars

;; disable decomposed colors for true-color displays:
device,decomposed=0

;; check IDL version and select TOPO save file:
case 1 of
    float(strmid(!version.release,0,3)) lt 5.1: begin
        print,' '
        message,'This version of TOPO will only run under IDL V5.1 or higher.'
    end
    float(strmid(!version.release,0,3)) eq 5.1: topofile='topo_51'
    float(strmid(!version.release,0,3)) eq 5.2: topofile='topo_52'
    else: topofile='topo_53'
endcase

;; load TOPO:
print,' ' 
print,format="($,'Loading TOPO...')"
@topositeconfig
restore,topohome+topofile
print,'done.'
print,' '

;; load default color table:
tek_color
loadct,5,bottom=32,ncolors=((!d.n_colors < 255)-32)>1,/silent

forward_function topo_config
if topo_config() then begin
    print,' '
    print,'-------------------------------TOPO-------------------------------'
    print,' '
    print,'                      Version '+topo.version
    print,' '
    print,'                           David L. Windt'
    print,'                       windt@astro.columbia.edu'
    print,'            <http://cletus.phys.columbia.edu/windt/idl>'
    print,' '
    print,'    Copyright (c) 1997-2000, David L. Windt, All rights reserved'
    print,' '
    print,'-----------------------------------------------------------------'
    print,' '
    print,' '
    print,'-> '
    print,'-> Use XANLZ_PROF for 1D profile analysis, XANLZ_PSD for 1D PSD'
    print,'-> analysis, and XANLZ_SURF for 2D surface analysis.'
    print,'-> '
    print,'-> Please point your browser to the topo.html file for more help.'
    print,'-> '
    print,' '
endif
end
