;;
;; TOPO4XOP
;; 
;; This is the procedure used to create the topo4xop.sav files.
;;

pro topo4xop

common topo,topohome,topo
common plot_print,printpars

;; disable decomposed colors for true-color displays:
device,decomposed=0

;; check IDL version and select TOPO save file:
case 1 of
    float(strmid(!version.release,0,3)) lt 5.1: begin
        print,' '
        message,'This version of TOPO will only run under IDL V5.1 or higher.'
    end
    float(strmid(!version.release,0,3)) eq 5.1: topofile='topo_51'
    float(strmid(!version.release,0,3)) eq 5.2: topofile='topo_52'
    else: topofile='topo_53'
endcase

;; load TOPO:
print,' ' 
print,format="($,'Loading TOPO...')"
@topositeconfig
restore,topohome+topofile
print,'done.'
print,' '

;; load default color table:
tek_color
loadct,5,bottom=32,ncolors=(!d.n_colors < 255)-32,/silent

topo_version='2.05, September 2000'

print,' '
print,'-------------------------------TOPO-------------------------------'
print,' '
print,'                      Version '+topo_version
print,' '
print,'                           David L. Windt'
print,'                      windt@astro.columbia.edu'
print,'            <http://cletus.phys.columbia.edu/windt/idl>'
print,' '
print,'    Copyright (c) 1997-2000, David L. Windt, All rights reserved'
print,' '
print,'-----------------------------------------------------------------'
print,' '
print,' '
print,'-> '
print,'-> Use XANLZ_PROF for 1D profile analysis, XANLZ_PSD for 1D PSD'
print,'-> analysis, and XANLZ_SURF for 2D surface analysis.'
print,'-> '
print,'-> Please point your browser to the topo.html file for more help.'
print,' '

topo

end
