;
; Copyright (c) 1993-1998, ESRF.  All rights reserved.
;	Unauthorized reproduction prohibited.
; Copyright (c) 1991, Research Systems, Inc.  All rights reserved.
;	Unauthorized reproduction prohibited.
;+
; NAME:
;	XWMENU
; PURPOSE:
;	This routine provides an editor for any IDL variable.
; CATEGORY:
;	Widgets
; CALLING SEQUENCE:
;	XWMENU, VAR
; INPUTS:
;	VAR = The variable that is to be edited.
; KEYWORD PARAMETERS:
;	NAME = The NAME of the variable.  This keyword is overwritten with the
;		structure name if the variable is a structure.
;	GROUP = The widget ID of the widget that calls XWMENU.  When this
;		ID is specified, a death of the caller results in a death of
;		XWMENU.
;
;	The following keywords have been added at the ESRF in order to 
;	use XWMENU for creating user-interfaces 
;
;	NCOLUMN = number of column widget where to arrange the result
;	NROW = number of row widget where to arrange the result
;	ACTION = returns the string 'DO' or 'DONT' if the users exits
;		with ACCEPT od CANCEL respectively.
;	TITLES = (only works with structures) An array of strings
;	 with dimension equals to the number of tags, containing
;	 the titles of the tags to be displayed.
;	NOTYPE  = (only works with structures) When set to 1, then do not
;	 display the type of variable (string, float etc...)
;	INTERP  = (only works with structures) When set to one, INTERprets
;	 the tags which are defines as an array of strings as a pull-down
;	 menu whose label shows the widget's current value. The possibles
;	 value of the buttons are placed starting from the 1st index of
;	 the string array. The 0-th index is kept for a string containing
;	 the order of following elements to be display as defaul value.
;	 The following example will create a window with 3 widgets, one
;		with the title and the others with a pull-down menu, whereas
;		the default values are 'a4' and 'b0' respectively.
;
;		out	  =  { Stuct_name, $			; define
;		TITLE: 'ESRF XWMENU test', $			; structure
;		ITYPE: ['4','a0','a1','a2','a3','a4'] , $
;		KTYPE: ['0','b0','b1','b2','b3','b4','b5'] }
;		titles = [' This is the title: ', $
;			'5 possible values of a',$		; set the
;			'6 possible values of b']		; titles
;		XWMENU,out,/interpret,titles=titles,/notype
;	WTITLES = title for the main window.
;	FIELDLEN = the size of the text fields (for structure input) in
;		number of characters.
;	HELP  = A string with either a string or string-vector.
;		Depending on which one is chosen, the functionaly is different:
;		1) A string is interpreted as a command to be executed. i.e. 
;		   XWMENU,5,help="print,'socorro'" 
;		   will print "socorro" on your terminal when "help" is pressed.
;		2) A string-vector is interpreted as a text to be displayed. 
;		   i.e. XWMENU,5,help=['help','me'] will open a window with 
;		   a 2-lines text (help me) when pressing help.
;		clicking on the "Help" button.
;	SCROLL  = When set, forces scroll bar.
;	W_SIZE  = [w_size_x,w_size_y] the window size in pixels. This 
;		value is only used when the SCROLL keyword is set.
;		Default: w_size = (tmp(0) * [5,5]) /9  where tmp is got from: 
;		device, GET_SCREEN = tmp.
;	APPLY_BUTTON  = When set to 1, creates a new button labelled "Apply".
;		When pressed, the effect is the same that "Accept"
;		except the ACTION keyword that is set to "DO_APPLY".
;		This keyword can be used to simulate an "apply function"
;		by the caller program. XWMENU is a modal widget that 
;		cannot send events to the caller, but with the "Apply"
;		button we can tell the caller that we want to recreate
;		the XWMENU window. This action must be coded in the
;		caller program.
;		For example, a simple program to enter a number
;		(norte the use of get/set_frame to force the XWMENU
;		to sit at the same screen position).
;		  PRO xnumber,i
;		  action = ' '
;		  frame=0
;		  XWMENU,i,action=action,get_frame=frame,/apply_button
;		  while action EQ 'DO_APPLY' do $
;		   XWMENU,i,action=action,set_frame=frame,/apply_button
;		  end
;	GET_FRAME = Set this keyword to a named variable to get the
;		Main XWMENU window offset (get_frame(0) and get_frame(1)) and 
;		the window size (get_frame(2) and get_frame(3)).
;		(Note: this is an approximate value, see comment in code)
;	SET_FRAME = Set this keyword to 4-element array with:
;		set_frame(0) the XOFFSET value for the main base window,
;		set_frame(1) the YOFFSET value for the main base window,
;		set_frame(2) the XSIZE value for the main base window,
;		set_frame(3) the YSIZE value for the main base window.
;
; OUTPUTS:
;	VAR= The variable that has been edited, or the original when the user
;		selects the "Cancel" button in the editor.
; COMMON BLOCKS:
;	Xvarcom1 - stores the base widget positions and dimensions
; SIDE EFFECTS:
;	Initiates the XManager if it is not already running.
; RESTRICTIONS:
;	If the variable is exceedingly large such as a giant structure or
;	huge array, the editor will not fit on the screen and may not be able
;	to create enough widget components to edit the whole variable.
; PROCEDURE:
;	Create and register the widget and then exit.
;	If the user selects "accept", the values in the editor are written
;	to the variable passed in, otherwise, they are ignored.
; MODIFICATION HISTORY:
;	Written by: Steve Richards,	February, 1991
;	Nov 1993 M. Sanchez del Rio includes NROW , NCOLUMN , ACTION , 
;		TITLES , NOTYPE and INTERPRET keywords
;		for the ESRF applications. 
;	94-02-14 MSR renames from Xvaredit [modified] to XscrMenu
;	96-04-12 MSR automatic scrollbars when ntags > 15. Adds fieldlen kw
;	96-11-13 MSR supresses the error message "Unable to convert given 
;		STRING to Float". Includes xscrmenu_flags0 in xscrmenu.pro file.
;	97-01-06 MSR adds the "help" button
;	97-02-05 MSR adds automatic resizing.
;	97-03-24 MSR adds SCROLL and W_SIZE keywords.
;	97-08-26 MSR modified the HELP keyword, adds GET/SET_FRAME and 
;		APPLY_BUTTON keywords.
;	97-08-29 MSR adds frame_origin in common block to store the frame
;		origin when apply button is pressed. This value is used to 
;		create the next XScrMenu window at the same position.
;	97-10-16 MSR fix a bug with get_frame (it didn't give the right
;		result when the window was moved/resized by the user)
;	97-11-07 MSR changes the windows dimension keyword when scroll
;		is set: from scr_xsize to x_scroll_size (in windows the
;		window didn't appear).
;       97-11-10 Chr.Michetschlaeger, changes Common Blocks to Structure 
;		(info),changes XSCRMENU2 for recursively calling
;       97-11-12 CHM,adds Keywords to recursively callings 
;       97-11-13 CHM,puts frame_origin as an Common Block, because of the 
;		Apply_Button and the moving window action
;       98-01-16 CHM,changed array treatment
;       98-03-20 srio@esrf.fr renames to xwmenu, to keep the old
;		xscrmenu alive!. The xwmenu code is very screw-up!
;		The present routine has a big problem: it returns 
;		all the structure tags converted to STRING type. 
;	02-03-13 srio@esrf.fr str_sep substituted by strsplit
;-
;
;===============================================================================
;
; the next function is also in the util directory

Function xwmenu_Change_Struct, oldstruct,changefield,changevalue

struct=oldstruct
number=N_Tags(struct)
names=Tag_Names(struct)
g=0
While g LT (number) DO BEGIN
  fieldstr=names(g)    
  IF changefield NE fieldstr THEN BEGIN
   verifus=execute('helpfield=struct.'+fieldstr)    
   IF g EQ 0 THEN  BEGIN     
     ver=execute('newstruct={'+fieldstr+':helpfield}')     
   ENDIF ELSE BEGIN
   exstr= 'newstruct=Create_Struct(newstruct,'+"'"+fieldstr+"'"+',helpfield)'    
    whatus=execute(exstr)
   ENDELSE
  ENDIF ELSE BEGIN
   IF g EQ 0 THEN BEGIN     
     veritus=execute('newstruct={'+changefield+':changevalue}')
   ENDIF ELSE BEGIN      
     verita=execute('newstruct=Create_Struct(newstruct,'+"'"+changefield+"'"+$
	',changevalue)')
   ENDELSE
  ENDELSE
  g=g+1
ENDWHILE
Return,newstruct
END

;
;===============================================================================
;

Function xwmenu_InsertArr, List, index, str
insertlist=list
getbig=size(insertlist)
helpuslistus=StrArr(getbig(getbig(0)+2)+1)
newbig=size(helpuslistus)
qot=0
FOR q=0,(newbig(newbig(0)+2)-1) DO BEGIN
 IF q EQ index THEN BEGIN
   helpuslistus(q)=str
   qot=qot-1
 ENDIF ELSE BEGIN
   helpuslistus(q)=insertlist(qot)
 ENDELSE
 qot=qot+1   
ENDFOR
Return, helpuslistus
END

;
;===============================================================================
;

PRO xwmenu_flags0,struct,result,FLAGS=FLAGS
;
; returns numerical flags (result) given the logical flags (flags)
; and the structure (to get the values)
;
; Updated MSR 96/11/6 to avoid error message when converting rr(0) to float 
;
nt = n_tags(struct)
w = fltarr(nt)
for i=0,nt-1 do begin
  rr = struct.(i)
  ; if rr(0) is text, examine the first character. If the first
  ; character is numerical, put it in w, otherwise put 0
  if type(rr) NE 8 then begin
  if type(rr(0)) EQ 7 then begin ; text
    if Strparse(' .+-0123456789 ',strmid(strcompress(rr(0),/rem),0,1)) $
	gt 0 then w(i) = rr(0) else w(i) = 0
  endif else w(i) = rr(0) ;numbers
  endif else w(i)=0
endfor

result = strarr(nt)
for i=0,nt-1 do begin
  text = flags(i)
  tmp = EXECUTE('fflag = '+text)
  IF (fflag) THEN ival = 1 ELSE ival = 0
  result(i) =  strcompress(ival,/remove_all)
endfor
end

;
;===============================================================================
;
Function move_data,source,dest                  	;this is a dummy 
RETURN,0						;declaration so that
END

Function move_data,source,dest
succ=0
numer=N_Tags(source)
names=Tag_Names(source)
FOR y=0,(numer-1) DO BEGIN  
  exstr='getter=source.'+names(y)  
  res=execute(exstr)  
  check=size(getter)
  type=check(check(0)+1)
  IF type NE 8 THEN BEGIN 
  IF type NE 7 THEN BEGIN
  getter=String(getter,/Print)
  getter=StrCompress(getter)
  getter=Strtrim(getter,2)
  ENDIF  
  execstr='dest.'+names(y)+'=getter' 
  rest=execute(execstr) 
  ENDIF ELSE BEGIN
    oldstr='old=dest.'+names(y)   
    gh=execute(oldstr)   
    getter=move_data(getter,old)    
    execstr='dest.'+names(y)+'=getter'
    ty=execute(execstr)
  ENDELSE 
  succ=1
ENDFOR
Return,dest
END



;
;===============================================================================
;
; commented by srio 98/03/20
; Function upcase,str
; valstr=str
; numer=size(valstr)
; len=numer(numer(0)+2)
; FOR v=0,(len-1) DO BEGIN
;  valstr(v)=strupcase(valstr(v))
; ENDFOR
; Return,valstr
; END


;
;===============================================================================
;
Function comp_keys,names,valstr

; srio valstr=upcase(valstr)
; srio names=upcase(names)
valstr=strupcase(valstr)
names=strupcase(names)

check_num=size(names)
number=check_num(check_num(0)+2)

check=size(valstr)
len=check(check(0)+2)

l=0
y=0
retro1=1
WHILE l NE len AND (retro1 EQ 1) DO BEGIN
  retro1=0
  WHILE y NE number AND (retro1 EQ 0) DO BEGIN
    IF names(y) EQ valstr(l) THEN retro1=1$
    ELSE retro1=0
    y=y+1
  ENDWHILE
  l=l+1
ENDWHILE
Return,retro1
END



;
;===============================================================================
;
Function Key_Val,strct,str,keys
search=strct
valstr=str

check=size(search)
type=check(check(0)+1)
IF type EQ 8 THEN BEGIN
  inlist=comp_keys(keys,str)
  IF inlist EQ 1 THEN BEGIN
    Names=Tag_Names(search)
    retro1=comp_keys(names,valstr)
  ENDIF ELSE BEGIN
    retro1=0
  ENDELSE  
ENDIF

Return,retro1
END 


;
;===============================================================================
;
Function sub_add,strct,str,mode,STRUCT=struct
IF keyword_set(struct) THEN BEGIN
  newstrct=strct
  num=N_TAGS(newstrct)
  namro=TAG_NAMES(newstrct)
  FOR a=0,(num-1) DO BEGIN
    item=namro(a)
    exstr='get=newstrct.'+item
    oui =execute(exstr)
    IF A EQ 0 THEN added=Create_Struct(item,get) $
    ELSE added=Create_Struct(added,item,get)     
  ENDFOR
  r=a
  num=N_TAGS(str)
  namro=TAG_NAMES(str)
  FOR v=0,(num-1) DO BEGIN
    item=namro(v)
    exstr='get=str.'+item   
    oyi=execute(exstr)
    added=Create_Struct(added,item,get)
  ENDFOR
  found=1
  newerone=added
ENDIF ELSE BEGIN
strch=str
newstrct=strct
modi=mode
c=0
f=0
found=0
num=N_TAGS(newstrct)
namro=TAG_NAMES(newstrct) 
WHILE c NE num DO BEGIN
  item=namro(c) 
IF modi EQ 0 THEN BEGIN
  IF item NE strch THEN BEGIN
    extistr='get=newstrct.'+item
    vxc=execute(extistr)
    found=1
    IF f EQ 0 THEN newerone=Create_Struct(item,get) $
    ELSE newerone=Create_Struct(newerone,item,get)                   
    f=f+1
  ENDIF
ENDIF ELSE BEGIN
  IF item NE strch THEN BEGIN
    extistr='get=newstrct.'+item
    dfx=execute(extistr)
    found=1    
    IF f EQ 0 THEN newerone=Create_Struct(item,get) $
    ELSE newerone=Create_Struct(newerone,item,get)    
    f=f+1
  ENDIF ELSE BEGIN
    extistr='get=newstrct.'+item
    rty=execute(extistr)
    found=1
    IF f EQ 0 THEN newerone=Create_Struct(item,get) $
    ELSE newerone=Create_Struct(newerone,item,get)    
    f=f+1
  ENDELSE
ENDELSE
c=c+1
ENDWHILE
ENDELSE
IF found EQ 0 THEN newerone=0
Return,newerone
END

;
;===============================================================================
;
Function calc_struct, strct, str,mode,STRUCT=struct
IF keyword_set(struct) THEN BEGIN 
 oldstrct=str
 newstrct=strct
 newstrct=sub_add(newstrct,oldstrct,1,/Struct)   
ENDIF ELSE BEGIN
newstrct=strct
strarr=str
modi=mode
; srio substr=upcase(strarr)
substr=strupcase(strarr)

check=size(strarr)
len=check(check(0)+2)
h=0
found=0
typex=8
While h NE len  AND typex EQ 8 DO BEGIN
 strch=substr(h)
 newstrct=sub_add(newstrct,strch,modi)
 check_new=size(newstrct)
 typex=check_new(check_new(0)+1)
 h=h+1
ENDWHILE
ENDELSE
Return,newstrct
END

;
;===============================================================================
;
Function pick_out,source,dest
so=source
de=dest

names=TAG_NAMES(de)
number=N_TAGS(de)
FOR v=0,(number-1) DO BEGIN
  str='get=so.'+names(v)
  sd=execute(str)
  str='de.'+names(v)+'=get'
  zxc=execute(str)
ENDFOR
Return,de
END


;------------------------------------------------------------------------------
;	procedure XWMenu_ev
;------------------------------------------------------------------------------
; This procedure processes the events being sent by the XManager.
;------------------------------------------------------------------------------
PRO XWMenu_ev, event



Widget_Control,event.top,Get_UValue=info

;COMMON Xvarcom, thevar, initialvar, entries, eventval2, interp, flags, help1,$
;  wtitle1, frame_origin, get_frame1
COMMON Xvarcom1, frame_origin

WIDGET_CONTROL, event.id, GET_UVALUE = eventval		;find the user value
                                                        ;of the widget where
check_info=size(eventval)
typerus=check_info(check_info(0)+1)

IF typerus EQ 8 THEN BEGIN    ; resize window
  ;Resize Window, UValue=info_structure
  test_info=Where(TAG_NAMES(info) EQ 'RESIZE')
  check_info=size(test_info)
  IF check_info(0) EQ 0 THEN BEGIN
    IF test_info NE (-1) THEN BEGIN
      IF info.resize EQ 'Resize' THEN BEGIN
        widget_control,event.id, scr_xsize=event.x,scr_ysize=event.y
      ENDIF
    ENDIF
  ENDIF
  goto,out
ENDIF 


info.eventval2 = eventval
							;the event occured

if eventval EQ 'DO_APPLY' then begin
  eventval='DO'            				;the apply button
							; acts as Accept.
  ; when apply button is pressed, store the frame origins in the 
  ; common block. The purpose is to create a new XWMenu window at the 
  ; same position the next time that XWMenu is called.
  aa1=0 & aa2=0
  widget_control,event.top,tlb_get_offset=aa1,tlb_get_size=aa2
  frame_origin = [aa1(0)-5,aa1(1)-24]
endif


if eventval EQ 'DO' or eventval EQ 'DONT' then begin
	; frame position
	aa1=0 & aa2=0
	widget_control,event.top,tlb_get_offset=aa1,tlb_get_size=aa2
	; warning the (5,23) shift is for the window frame. It has been placed
	; by eye and can behave differently in different systems.
	; How to get the frame width in Unix? I do not know. If you know
	; please tell me (srio@esrf.fr)
	info.get_frame1 = [aa1(0)-5,aa1(1)-23,aa2(0),aa2(1)]
endif

;
; this part manages the buttons containing structures
;
FOR w=0,info.instr DO BEGIN ; start loop "MANAGING"
   we=STRING(w,/PRINT)
   we=STRCOMPRESS(we)
   we=STRTRIM(we,2)
   name='IN_STR'+we
   IF eventval EQ name THEN BEGIN   ; clicked structure button
	      inner=info.inner	     
	      index=STRING(w)
              index=STRCOMPRESS(index)
              index=STRTRIM(index,2)
              stri='instrct=inner.instrct'+index 
              sdf=execute(stri)
	      tmp=instrct.inval
	      keys=['GROUP','NAME','NCOLUMN','NROW','ACTION','TITLES',$
	      'NOTYPE','INTERPRET','FLAGS','WTITLE','FIELDLEN','HELP',$
              'SCROLL','W_SIZE','APPLY_BUTTON','SET_FRAME',$
              'GET_frame','MODAL']
	      	      
	      namesic=Tag_NAMES(tmp)
	      numsic=N_TAGS(tmp)
	      notf=0
	      fo=0
	      FOR p=0,(numsic-1) DO BEGIN
	        checker=namesic(p)
	        valsic=Key_Val(tmp,checker,keys)	        
	        IF valsic EQ 0 THEN BEGIN
	          IF notf EQ 0 THEN BEGIN
	            namerix=[checker]	          
	          ENDIF ELSE BEGIN
	            namerix=xwmenu_InsertArr(namerix,notf,checker)
	          ENDELSE
	          notf=notf+1
	        ENDIF ELSE BEGIN
	          IF fo EQ 0 THEN BEGIN
	            comerix=[checker]	            
	          ENDIF ELSE BEGIN
	            comerix=xwmenu_InsertArr(comerix,fo,checker)
	          ENDELSE
	          fo=fo+1	          
	        ENDELSE
	      ENDFOR	     
	      comstrct=calc_struct(tmp,namerix,0)	      
	      check_com=size(comstrct)
	      typer=check_com(check_com(0)+1)

	      ;
	      ; structure with "keywords" (not sure?)
	      ;
	      IF typer EQ 8 THEN BEGIN 
               def_strct={group:0,name:0,ncolumn:0,nrow:0,action:0,titles:0,$
		notype:0,interpret:0,flags:0,wtitle:0,fieldlen:0,help:0,$
		scroll:0,w_size:0,apply_button:0,set_frame:0,get_frame:0,$
		modal:0}                         
                names=TAG_NAMES(comstrct)
                numero=N_TAGS(comstrct)
	        check_key=size(keys)
	        num_key=check_key(check_key(0)+2)

	       ac_app=0
	       gf_app=0
	       g=0
	        WHILE g NE num_key DO BEGIN
	          vern=keys(g)
	          validus=Key_Val(comstrct,vern,keys)	        
	          IF validus EQ 1 THEN BEGIN
	            excstr='get=comstrct.'+vern
	            mn=execute(excstr)	          
                    IF vern EQ 'ACTION' THEN BEGIN
                      ac=''
                      ac_app=1
                    ENDIF
                    IF vern EQ 'GET_FRAME' THEN BEGIN
                      gf=IntArr(4)
                      gf_app=1
                    ENDIF
	            IF g EQ 0 THEN BEGIN
	              exstrct=Create_Struct(vern,get)
	            ENDIF ELSE BEGIN
	              exstrct=Create_Struct(exstrct,vern,get)	        
	            ENDELSE
	          ENDIF

	          IF validus EQ 0 THEN BEGIN
	            exerstr='get=def_strct.'+vern
	            bc=execute(exerstr)
	            IF vern EQ 'ACTION' THEN BEGIN
	              ac=0
	            ENDIF
	            IF vern EQ 'GET_FRAME' THEN BEGIN
	              gf=0
	            ENDIF
	            IF g EQ 0 THEN BEGIN
	              exstrct=Create_Struct(vern,get)	         
	            ENDIF ELSE BEGIN
	              exstrct=Create_Struct(exstrct,vern,get)
	            ENDELSE
	          ENDIF
	          g=g+1	        
	        ENDWHILE
	        varstrct=calc_struct(tmp,comerix,0)	      
		; voila the recurrent call
	        xwmenu,varstrct,GROUP = exstrct.group, NAME = exstrct.name, $
		 NCOLUMN=exstrct.ncolumn, NROW=exstrct.NROW, ACTION=ac, $
		 TITLES=exstrct.TITLES, NOTYPE=exstrct.NOTYPE, $
		 INTERPRET=exstrct.INTERPRET, FLAGS=exstrct.flags, $
		 WTITLE=exstrct.wtitle,FIELDLEN=exstrct.fieldlen, $
		 HELP=exstrct.help,SCROLL=exstrct.scroll,W_SIZE=exstrct.w_size,$
		 APPLY_BUTTON=exstrct.apply_button,SET_FRAME=exstrct.set_frame,$
		 GET_frame=gf,MODAL=exstrct.modal
                                           
                IF ac_app EQ 1 THEN exstrct.action=ac 
               
                IF gf_app EQ 1 THEN exstrct.get_frame=gf

                comstrct=pick_out(exstrct,comstrct)
               
                varstrct=calc_struct(varstrct,comstrct,1,/Struct)
                next={inname:instrct.inname,inval:varstrct}
	      ENDIF ELSE BEGIN ; structure with no "keywords"???
                xwmenu,tmp,/interp                      
                 next={inname:instrct.inname,inval:tmp}              
              ENDELSE             
              namix='inner.instrct'+index             
              excer=namix+"=move_data(next,"+namix+")"             
              vbn=execute(excer)                      
              newinner=instrct              
              info=xwmenu_Change_Struct(info,'INNER',inner)                           
  ENDIF
ENDFOR  ; End loop "MANAGING"


CASE eventval OF

  "HELP": BEGIN						;the help
	  if n_elements(info.help1) EQ 1 then $
	    itmp = execute(info.help1) else $
	    Xdisplayfile1,text=info.help1,group=event.top,Title='Help on '+$
		info.wtitle1
	  END
  "DONT": BEGIN						;the user chose the 
	    thevar = info.initialvar
; commented by srio 98/03/19
;	    w=0		    
;	    WHILE info.instr NE 0 DO BEGIN
;	    IF info.instr NE 0 THEN BEGIN	   	       
;	       inner=info.inner	       
;	       index=STRING(w,/PRINT)
;	       index=STRCOMPRESS(index)
;	       index=STRTRIM(index,2)
;	       str='strct=inner.instrct'+index	       	       
;	       iopi=execute(str)	       
;	       name=strupcase(strct.inname)	       	       	       
;	      thevar=xwmenu_Change_Struct(thevar,name,strct.inval)
;	      info.instr=info.instr-1
;	      w=w+1	      
;	    ENDIF	   
;	    ENDWHILE	    
	    up={thevar:thevar,eventval2:info.eventval2,$
		get_frame1:info.get_frame1}
	    Handle_Value,info.ptr,up,/Set		;cancel button so just
	    WIDGET_CONTROL, event.top, /DESTROY		;return the initial
	  END						;variable

  "DO": BEGIN						;the user chose accept
          i = 0
          arr_halt=0          				;so go ahead and modify 
          arr_name=''
          create_arr=0
          si_create=1
	  ; whole loop over the number of tags
 	  WHILE(i LT N_ELEMENTS(info.entries))DO BEGIN	;the user's variable to
            entries=info.entries                    
            IF(entries(i).type NE 8) THEN BEGIN		;reflect his or her 
	      WIDGET_CONTROL, entries(i).widid, $	;choice
			GET_VALUE = newval					
			pass=1
	                Widget_Control, entries(i).widid,GET_UValue=newuval	               	                
	                check_new=size(newuval)	                
	                typerix=check_new(check_new(0)+1)
	                IF typerix EQ 7 THEN BEGIN
	                  sub=STRMID(newuval,0,6)
	                  sub=STRUPCASE(sub)	                  
	                  IF sub EQ 'IN_STR' THEN pass=0
	                ENDIF
			IF pass EQ 1 THEN BEGIN			   
			   initial=info.initialvar			   
			   exterstr='picker=initial.'+entries(i).name
			   jk=execute(exterstr)
			   check_picker=size(picker)
			   type_picker=check_picker(check_picker(0)+1)			  
			   IF check_picker(0) GT 0 AND type_picker NE 6 THEN $
			     BEGIN
			     newval=STRING(newval)
			     newval=STRCOMPRESS(newval)
			     newval=STRTRIM(newval,2)
			     picker(0)=newval
			     get=picker			     
			   ENDIF 
			   IF check_picker(0) EQ 0 AND type_picker NE 6 THEN $
			     BEGIN
			     check_val=size(newval)
			     IF check_val(0) GT 0 THEN BEGIN
			       helpval=newval(0)
			       newval=helpval
			     ENDIF
			     typerixus=check_val(check_val(0)+1)
			     IF typerixus NE 7 THEN BEGIN
			       newval=STRING(newval)
			       newval=STRCOMPRESS(newval)
			       newval=STRTRIM(newval,2)
			     ENDIF
			     test_n=size(newval)
			     type=test_n(test_n(0)+1)
			     IF type EQ 7 THEN get=newval $
	                       ELSE error = EXECUTE('get='+newval)
	                     ;new lines
	                     ;fb=STR_SEP(entries(i).name,'(')
	                     fb=StrSplit(entries(i).name,'(',/Extract)
	                     test_fb=size(fb)
	                     len_fb=test_fb(test_fb(0)+2)	                     	                     	                     
	                     IF len_fb GT 1 THEN BEGIN
	                       ;sb=STR_SEP(fb(1),')')	                       
	                       sb=StrSplit(fb(1),')',/Extract)
	                       example_var=info.initialvar
	                       example_names=Tag_names(example_var)        
	                       fb_name=STRUPCASE(fb(0))
	                       IF fb_name NE arr_name AND arr_halt NE 0 THEN $
				arr_halt=0
	                       IF arr_halt EQ 0 THEN BEGIN
	                         arr_name=fb_name
	                         exer="tempix_var=example_var."+fb_name
	                         error=execute(exer)
	                         test_tem=size(tempix_var)
	                         exer="arr_temp=StrArr("
	                         FOR j=1,test_tem(0) DO BEGIN
	                           exer=exer+STRTRIM(STRCOMPRESS($
					STRING(test_tem(j))),2)
	                           IF j NE test_tem(0) THEN exer=exer+','
	                         ENDFOR
	                         exer=exer+")"	                         
	                         error=execute(exer)
	                         arr_halt=arr_halt+1
	                         create_arr=1	                       
	                       ENDIF ELSE BEGIN
	                           create_arr=0
	                       ENDELSE
	                       si_create=0
	                     ENDIF
	                     ;new lines
            ENDIF		   	                 
            ; 
            ; when the user's variable has a complex value,
            ; the real and imaginary components  must be
            ; reassembled from its respective editable
            ; widget  components
            ;
            IF (entries(i).type EQ 6 ) THEN BEGIN 
	                     WIDGET_CONTROL, entries(i).widid, $ 
			        GET_VALUE = realval
	                        i = i + 1
	                     WIDGET_CONTROL, entries(i).widid, $ 
			       GET_VALUE = imagval
	                        error = EXECUTE(get  + $
				"= complex(" + $
				string(realval(0)) + $
				"," + $
				string(imagval(0)) + $
				")")
            ENDIF	
	                   ;changed lines		
			   IF si_create EQ 1 THEN BEGIN
			     IF i EQ 0 THEN BEGIN
	                       thevar=Create_Struct(entries(i).name,get)
	                     ENDIF ELSE BEGIN
	                       thevar=Create_Struct(thevar,entries(i).name,get)
	                     ENDELSE 	
	                   ENDIF
	                   ;changed lines
	                   ;new lines
	                   IF si_create EQ 0 THEN BEGIN
	                     IF i EQ 0 AND create_arr EQ 1 THEN BEGIN
	                       thevar=Create_Struct(fb_name,arr_temp)
	                       exer="thevar."+fb_name+"("+fb(1)+"=get"
	                       error=execute(exer)
	                     ENDIF
	                     IF i NE 0 AND create_arr EQ 1 THEN BEGIN
	                       thevar=Create_Struct(thevar,fb_name,arr_temp)
	                       exer="thevar."+fb_name+"("+fb(1)+"=get"
	                       error=execute(exer)
	                     ENDIF
	                     IF create_arr EQ 0 THEN BEGIN
	                      exer="thevar."+fb_name+"("+fb(1)+"=get"
	                      print,'exer:',exer
	                      error=execute(exer)	                      
	                     ENDIF	                     
	                   ENDIF
	                   ;new lines
	               ENDIF
              ENDIF							
	    i = i + 1    
	  ENDWHILE
	  w=0
	  WHILE info.instr NE 0 DO BEGIN
	   IF info.instr NE 0 THEN BEGIN	       
	       inner=info.inner
	       index=STRING(w,/PRINT)
	       index=STRCOMPRESS(index)
	       index=STRTRIM(index,2)
	       str='instrct=inner.instrct'+index	       	       
	       iopi=execute(str)	              
	      thevar=Create_Struct(thevar,instrct.inname,instrct.inval)
	      info.instr=info.instr-1	      
	      w=w+1
	   ENDIF
	  ENDWHILE
	  
	  	  
	  up={thevar:thevar,eventval2:info.eventval2,get_frame1:info.get_frame1}
	    Handle_Value,info.ptr,up,/Set
	  WIDGET_CONTROL, event.top, /DESTROY		;once the variables 
	END						;have been retrieved, 
							;the widget hierarchy
  ELSE: BEGIN						;can be destroyed

		;		
		; if FLAGS are define, then MAP the widgets after
		; any action
		;
		IF (N_ELEMENTS(info.flags) GT 1) THEN BEGIN
          	i = 0	
		w = 0.0
	 	WHILE(i LT N_ELEMENTS(info.entries))DO BEGIN
	    	  IF(info.entries(i).type NE 6)THEN BEGIN	
	      	    WIDGET_CONTROL, info.entries(i).widid, $	
			GET_VALUE = wtmp
  			;print,'wtmp before: ',wtmp
  			; if wtmp is text, examine the first character. 
			; If the first character is numerical, keep it, 
			; otherwise put 0
  			wtmp2 = wtmp(0)
  			if type(wtmp2) EQ 7 then begin ; text
			  ;print,'<<text>>'
			  ;print,'char: ',strmid(strcompress(wtmp2,/rem),0,1)
    			  if Strparse(' .+-0123456789 ',$
			  strmid(strcompress(wtmp2,/rem),0,1)) le 0 then $
			  wtmp2 = 0
  			endif
			;print,'wtmp after: ',wtmp2
			;w = [w,wtmp]
			w = [w,wtmp2]
	    	  ENDIF ELSE BEGIN			
	      	    WIDGET_CONTROL, info.entries(i).widid, $	
				GET_VALUE = wtmp	
		    w = [w,wtmp]
	      	    i = i + 1				
	      	    WIDGET_CONTROL, info.entries(i).widid, $
			GET_VALUE = wtmp	
		    w = [w,wtmp]
	    	  ENDELSE
	    	  i = i + 1
	  	ENDWHILE
		w = w(1:n_elements(w)-1)
		;
          	i = 0					
		; so go ahead and modify the user's variable to reflect his 
		; or her choice
 		WHILE(i LT N_ELEMENTS(info.entries))DO BEGIN
            	IF(info.entries(i).type NE 6)THEN BEGIN
		  IF (info.flags(i) NE '1') THEN BEGIN
                    text = info.flags(i)
		    tmp = EXECUTE('fflag = '+text)
		    IF (fflag) THEN ival = 1 ELSE ival = 0
              	    WIDGET_CONTROL, info.entries(i).widid, $
                        MAP = ival
		  ENDIF
            	ENDIF ELSE BEGIN                            ;when the user's
            	ENDELSE
            	i = i + 1
          	ENDWHILE
		ENDIF
	END
   

ENDCASE
out:
IF WIDGET_INFO(event.top,/VALID_ID) THEN Widget_Control,event.top,$
  Set_UValue=info

END ;============= end of XWMENU event handling routine task =============


;
;===============================================================================
;
;------------------------------------------------------------------------------
;	procedure AddEditEntry
;------------------------------------------------------------------------------
; This procedure adds an entry to the list that contains the variables names
; and the widget id for the edit field corresponding to the variable name.
;------------------------------------------------------------------------------

Function AddEditEntry, thename, thetype, thewidid,info

;COMMON Xvarcom, thevar, initialvar, entries, eventval2, interp, flags, help1,$
;  wtitle1, frame_origin, get_frame1

COMMON Xvarcom1, frame_origin

IF N_ELEMENTS(thewidid) EQ 0 THEN thewidid = 0L
newelt = {entstr, name:thename, $			;first create a record
		  widid:thewidid, $			;and then 
		  type:thetype}				;just create a list
numents = N_ELEMENTS(info.entries)				;with one more element
IF(NOT(KEYWORD_SET(info.entries)))THEN ENTRIES = newelt $	;and replace the old 
ELSE BEGIN						;one
  newentries = REPLICATE(newelt, numents + 1)
  newentries(0:numents - 1) = info.entries
  newentries(numents) = newelt
  entries = newentries
ENDELSE
;info.entries=entries

chname='ENTRIES'
change=entries

names=Tag_Names(info)
number=N_Tags(info)
FOR y=0,(number-1) DO BEGIN
IF names(y) NE chname THEN BEGIN
str='get=info.'+names(y)
qwe=execute(str)
ENDIF ELSE BEGIN
get=change
ENDELSE
IF y EQ 0 THEN BEGIN
newinfo=CREATE_STRUCT(names(y),get)
ENDIF ELSE BEGIN
newinfo=CREATE_STRUCT(newinfo,names(y),get)
ENDELSE
ENDFOR

info=newinfo

Return,info
END ;============== end of XWMENU event handling routine task ===============






;
;===============================================================================
;

;------------------------------------------------------------------------------
;	procedure XWMenuField
;------------------------------------------------------------------------------
;  This routine is used to create the widget or widgets needed for a given 
;  variable type.  It could call itself recursively if the variable was itself
;  a structure comprised of other IDL variables.
;------------------------------------------------------------------------------

FUNCTION XWMenuField, base, type, val,info, NAME = NAME, $
	fieldlen=fieldlen        	;this is a dummy 
RETURN,0						;declaration so that
END							;this routine can call
							;itself recursively
FUNCTION XWMenuField, base, val,info, NAME = NAME, $
 RECNAME = RECNAME, NCOLUMN=ncolumn, NROW=nrow, TITLES=titles, $
 NOTYPE=NOTYPE, INTERP = interp, FLAGS_INI=flags_ini,fieldlen=fieldlen

;Help,info,/Structures

if not(keyword_set(INTERP)) then interp = 0 else interp = 1
if not(keyword_set(NCOLUMN)) then ncolumn = 0
if not(keyword_set(NROW)) then nrow = 0
if not(keyword_set(fieldlen)) then fieldlen = 12
if ((NCOLUMN EQ 0) AND (NROW EQ 0) ) then begin
  NCOL = 0  &  NCOLUMN = 1
endif
 
dimarr = [18, 4, 7, 10, 12, 16, 12, fieldlen]			;an array of lengths of
							;each type

typarr = ["Undefined", "Byte", "Integer", $		;an array of names of 
	  "Longword Integer", "Floating Point", $	;each type
	  "Double Precision Floating", $
	  "Complex Floating Point", $
	  "String", "Structure"]

varsize = size(val)					;determine the size and
vardims = N_ELEMENTS(varsize) - 2			;type of the variable
type = varsize(vardims)
numelements = varsize(vardims + 1)

IF(numelements GE 10) THEN $				;if the array is larger
  scrollval = 1 $					;than 10 elements, use
ELSE scrollval = 0					;a scrolling base to
							;conserve screen space

abase = WIDGET_BASE(base, $				;create a base for the
		/FRAME, $				;variable to live in
		COLUMN=ncolumn, $
		ROW=nrow, $
		XPAD = 8, $
		YPAD = 8, $
		SCROLL = scrollval)

IF(numelements GT 1) THEN BEGIN				;if the variable is an
  suffix = " Array("					;array, then say so and
  FOR j = 1, varsize(0) DO BEGIN			;show the array
    suffix = suffix + strtrim(varsize(j), 2)		;dimensions.
    IF j NE varsize(0) THEN suffix = suffix + ", "
  ENDFOR
  suffix = suffix + ")"
ENDIF ELSE suffix = ""


IF(type EQ 8) THEN NAME = TAG_NAMES(val, /STRUCTURE)	;if the variable is a 
							;structure, use its 
							;name
if not(keyword_set(notype)) then begin
  IF(KEYWORD_SET(NAME)) THEN $				;build up the name of
    lbl = WIDGET_LABEL(abase, $				;variable with the 
		  VALUE = NAME + $			;type in parenthesese
			  " (" + $
			  typarr(type) + $
			  suffix + $
			  ")") $
  ELSE lbl = WIDGET_LABEL(abase, $
		  value = typarr(type) + suffix)
endif else begin
  IF(KEYWORD_SET(NAME)) THEN $
    lbl = WIDGET_LABEL(abase,VALUE = NAME) $
  ELSE lbl = WIDGET_LABEL(abase, value = '')
endelse



IF(NOT(KEYWORD_SET(RECNAME))) THEN RECNAME = "thevar"	;establish the name
							;if not being called 
							;recursively

IF(varsize(0) GT 1) THEN BEGIN
  moduli = LONARR(varsize(0)-1) + 1
  FOR i = varsize(0), 2,-1 DO BEGIN
    FOR j = 1,i-1 DO $
      moduli(i - 2) = moduli(i - 2) * varsize(j)
  ENDFOR
ENDIF

FOR element = 0, numelements - 1 DO BEGIN		;for each array element

  IF(numelements NE 1) THEN BEGIN			;use array subscripting
    indexname = "("					;if variable is an
    indexname = indexname + $
		strtrim(element mod varsize(1),2)
    IF(varsize(0) GT 1) THEN BEGIN
      indexarr = lonarr(varsize(0) - 1)
      flatindex = element
      FOR i = varsize(0) - 2, 0, -1 DO BEGIN
	indexarr(i) = flatindex / moduli(i)
	flatindex = flatindex mod moduli(i)
      ENDFOR
      FOR i = 0, varsize(0) - 2 DO $
	indexname = indexname + ", " + $
		strtrim(indexarr(i), 2)
    ENDIF
    indexname = indexname + ")"
    thename = RECNAME + indexname			;build up the name from
    thebase = WIDGET_BASE(abase, $			;any previous recursive
		/FRAME, $
		/ROW)
    alabel = WIDGET_LABEL(thebase, $
		VALUE = indexname + ": ")
    FRAMESETTING = 0
  ENDIF ELSE BEGIN
    FRAMESETTING = 1
    thename = RECNAME
    thebase = abase
  ENDELSE
   
 
  CASE type OF						;depending on the type,
							;build a string 
							;variable with proper
							;formatting

    0: thevalue = "Undefined Variable"			;Undefined

    1: thevalue = string(val(element), $		;Byte
		FORMAT = '(I3)')

    6: BEGIN						;Complex Float
	 rowbase = WIDGET_BASE(thebase, $		;here the variable must
		/ROW)					;be displayed in two
	 lable = WIDGET_LABEL(rowbase, $		;separate widgets for
		VALUE = "Real: ")			;its real and imaginary
	 id = WIDGET_TEXT(rowbase, $			;components
		VALUE = STRING(FLOAT(val(element))), $
		FRAME = FRAMESETTING, $
		YSIZE = 1, $
		XSIZE = dimarr(type), $
		/EDITABLE, $
		UVALUE = ' ')
	 info=AddEditEntry( thename, type, id,info)
	 lable = WIDGET_LABEL(rowbase, $
		VALUE = "Imaginary: ")
	 id = WIDGET_TEXT(rowbase, $
		VALUE = STRING(IMAGINARY(val(element))), $
		FRAME = FRAMESETTING, $
		YSIZE = 1, $
		XSIZE = dimarr(type), $
		/EDITABLE, $
		UVALUE = ' ')
	info=AddEditEntry(thename, type, id,info)
      END
    
    7: thevalue = val(element)				;String

    8: BEGIN						;Structure
	 tags = TAG_NAMES(val(element))
	 FOR i = 0, N_ELEMENTS(tags) - 1 DO BEGIN
	   error = EXECUTE("fieldvalue = val(element)." + tags(i))
	   fldsize = size(fieldvalue)
	   flddims = N_ELEMENTS(fldsize) - 2
	   if keyword_set(titles) then ccname = titles(i) else ccname=tags(i)
	   ttype = fldsize(fldsize(0)+1)
	   IF ( (ttype EQ 7) AND $
		(N_ELEMENTS(fieldvalue) GT 1 AND interp EQ 1) ) THEN BEGIN
	     id = cw_bselector(thebase,fieldvalue(1:n_elements(fieldvalue)-1), $
		/frame,label_top=ccname, set_value=fix(fieldvalue(0)) ,  $
		return_uvalue=fieldvalue(1:n_elements(fieldvalue)-1) )
		thename=tags(i)
	     info=AddEditEntry( thename , ttype, id,info)
	   ENDIF ELSE BEGIN	     
	     checkix=size(fieldvalue)
	     check=checkix(checkix(0)+1)
	     IF check NE 8 THEN BEGIN	     
	       returux = XWMenuField(thebase, $
		fieldvalue,info, $
		;NAME = tags(i), $
		NAME = ccname, $
		RECNAME = tags(i), NOTYPE=notype, $
		fieldlen=fieldlen)
		;RECNAME = thename + "." + tags(i), NOTYPE=notype,
	       id=returux.id
	       info=returux.info
	     ENDIF ELSE BEGIN	       
               inname=tags(i)               
               inval=fieldvalue
               ind=STRING(info.instr,/PRINT)
               ind=STRCOMPRESS(ind)
               ind=STRTRIM(ind,2)
               rec='IN_STR'+ind
               tmp = Widget_Base(thebase,/Align_Center)              
               IF keyword_set(titles) THEN $
		id=Widget_Button(tmp,XSIZE=130,YSIZE=30,Value=ccname,$
			UValue=rec,FRAME=1,/Align_Center) ELSE $
		id=widget_button(tmp,XSIZE=130,YSIZE=30,VALUE=inname,$
			UVALUE=rec,FRAME=1) 
               info=AddEditEntry(thename, type, id,info)
               if keyword_set(flags_ini) THEN Widget_Control,tmp,$
		MAP=flags_ini(i)                         
               instrct={inname:inname,inval:inval}                            
               IF info.instr EQ 0 THEN BEGIN               
                 inarr=Create_Struct('instrct0',instrct)               
               ENDIF ELSE BEGIN
                 indexerus=STRING(info.instr,/PRINT)
                 indexerus=STRCOMPRESS(indexerus)
                 indexerus=STRTRIM(indexerus,2)
                 strct_name='instrct'+indexerus
                 inarr=Create_Struct(inarr,strct_name,instrct)
               ENDELSE                             
               IF info.instr EQ 0 THEN BEGIN
                 info=Create_Struct(info,'inner',inarr)
                 nexter=info.inner              
               ENDIF ELSE BEGIN
                 info=xwmenu_Change_Struct(info,'INNER',inarr)              
               ENDELSE
               info.instr=info.instr+1
	     ENDELSE
	   ENDELSE
	   IF KEYWORD_SET(FLAGS_INI) THEN WIDGET_CONTROL,id,MAP=flags_ini(i)
	 ENDFOR
	 
	END

    ELSE: thevalue = strtrim(val(element), 2)
  ENDCASE

  IF((type NE 6) AND (type NE 8)) THEN BEGIN		;here the actual widget
    id = WIDGET_TEXT(thebase, $				;is created if it was
		value = thevalue, $			;neither a structure or
		FRAME = FRAMESETTING, $			;a complex value
		YSIZE = 1, $
		XSIZE = dimarr(type), $
		/EDITABLE, $
		UVALUE = ' ')
		;Help,info,/Structures
		
    info=AddEditEntry(thename, type, id,info)
  END

ENDFOR


back={id:id,info:info}
return,back

END ;============= end of XWMENU event handling routine task =============


;------------------------------------------------------------------------------
;	procedure XWMENU
;------------------------------------------------------------------------------
; this is the actual routine that is called.  It builds up the variable editing
; fields by calling other support routines and then registers the widget 
; hierarchy with the XManager.  Notice that the widget is registered as a MODAL
; widget so it will desensitize all other current widgets until it is done.
;------------------------------------------------------------------------------
PRO XWMENU, var, GROUP = GROUP, NAME = NAME, NCOLUMN=NCOLUMN, $
NROW=NROW, ACTION=ACTION, TITLES=TITLES, NOTYPE=NOTYPE, INTERPRET=INTERPRET, $
FLAGS=flagsb, WTITLE=wtitle,FIELDLEN=fieldlen,HELP=help,$
SCROLL=scroll,W_SIZE=w_size,APPLY_BUTTON=apply_button,SET_FRAME=set_frame,$
GET_frame=get_frame,MODAL=modal

;COMMON Xvarcom, thevar, initialvar, entries, eventval2, interp, flags, help1,$
 ; wtitle1, frame_origin, get_frame1

COMMON Xvarcom1, frame_origin


if not(keyword_set(scroll)) then scroll=0
if not(keyword_set(frame_origin)) then frame_origin = [0,0]

if not(keyword_set(fieldlen)) then fieldlen=12
if type(var) EQ 8 then $
  if n_tags(var) gt 15 then scroll = 1 
if not(keyword_set(flagsb)) then begin
  flags = 0 
endif else begin
  flags=flagsb
  XWMenu_flags0,var,flags_ini,FLAGS=FLAGS
endelse
if not(keyword_set(INTERPRET)) then interp = 0 else interp = 1
if not(keyword_set(WTITLE)) then wtitle='XWMENU'
wtitle1=wtitle
if not(keyword_set(NCOLUMN)) then ncolumn = 0
if not(keyword_set(NROW)) then nrow = 0
if ((NROW EQ 0) and (NCOLUMN EQ 0)) then begin
  NROW = 0  &  NCOLUMN = 1
endif
if(n_params() ne 1) THEN $
  MESSAGE, "Must have one parameter"

;IF(XRegistered("XWMENU")) THEN RETURN			;only one instance of
							;the XWMENU widget
							;is allowed.  If it is
							;already managed, do
							;nothing and return


if keyword_set(scroll) then scroll=1
if sdep() EQ 'WINDOWS' and sdep(/vf) EQ '5.0B5' then scroll=0
if keyword_set(set_frame) then begin
  if n_elements(set_frame) ne 4 then message,/info,$
    'Error in setting frame attributes.'
  xoffset = set_frame(0) & yoffset = set_frame(1)
  xsize = set_frame(2) & ysize = set_frame(3)
endif else begin
  if keyword_set(apply_button) then xoffset = frame_origin(0) else xoffset = 0
  if keyword_set(apply_button) then yoffset = frame_origin(1) else yoffset = 0
  xsize = 0
  ysize = 0
endelse

if scroll then begin
  if not(keyword_set(w_size)) then begin
    device, GET_SCREEN = w_size
    ;w_size = (w_size(0) * [5,4]) /9
    w_size = (w_size(0) * [5,5]) /9
  endif
  XWMenubase = WIDGET_BASE(TITLE = wtitle, $	;create the main base
		/COLUMN,/scroll,x_scroll_size=w_size(0),y_scroll_size=w_size(1),$
	;	/COLUMN,/scroll,scr_xsize=w_size(0),scr_ysize=w_size(1) );,$
		/TLB_SIZE_EVENTS,$
		XOFFSET=xoffset,YOFFSET=yoffset,XSIZE=xsize,YSIZE=ysize) 
endif else begin
  XWMenubase = WIDGET_BASE(TITLE = wtitle, /COLUMN,$
		/TLB_SIZE_EVENTS,$
		XOFFSET=xoffset,YOFFSET=yoffset,XSIZE=xsize,YSIZE=ysize)
endelse

;buttons = [    '"Cancel"               DONT',  $       ;create the menu
;                '"Accept"               DO']           ;selections
buttons = [    '"Accept"               DO',  $       ;create the menu
                '"Cancel"               DONT']           ;selections

if keyword_set(apply_button) then begin
  buttons = [buttons, $
                '"Apply"                DO_APPLY']     ;apply
endif

help1=0
if keyword_set(help) then begin
  help1 = help
  buttons = [buttons, $
                '"Help"                 HELP']         ;help
endif

XPdMenu, buttons,XWMenubase

initialvar = var
thevar = var
varsize = size(var)
vardims = N_ELEMENTS(varsize) - 2

entries=0
get_frame1=IntArr(4)
start=0
instr=0
eventval2=''
resize='Resize'
info={resize:resize,thevar:thevar, initialvar:initialvar, entries:entries,$
       interp:interp, flags:flags, help1:help1, wtitle1:wtitle1, $
       eventval2:eventval2,get_frame1:get_frame1,start:start,instr:instr}

retour = XWMenuField(XWMenubase, var,info, NAME = NAME ,NCOLUMN=ncolumn, $
  NROW=nrow, TITLES=TITLES, NOTYPE=NOTYPE, INTERP=interp, $
  FLAGS_INI=flags_ini,fieldlen=fieldlen)

ids=retour.id
info=retour.info



WIDGET_CONTROL, XWMenubase, /REALIZE			;create the widgets


							;that are defined
; frame position
aa1=0 & aa2=0
widget_control,XWMenubase,tlb_get_offset=aa1,tlb_get_size=aa2
; warning the (5,23) shift is for the window frame. It has been placed
; by eye and can behave differently in different systems.
; How to get the frame width in Unix? I do not know. If you know
; please tell me (srio@esrf.fr)
get_frame1 = [aa1(0)-5,aa1(1)-23,aa2(0),aa2(1)]
;


pointer=Handle_Create()

info=Create_Struct(info,'ptr',pointer)
;print,'info.inner:',info.inner

Widget_Control,XWMenubase,Set_UValue=info



XManager, "XWMENU", XWMenubase, $			;register the widgets
		EVENT_HANDLER = "XWMenu_ev", $	;with the XManager
		GROUP_LEADER = GROUP , $		;and pass through the
		 /MODAL				;group leader if this
							;routine is to be 
							;called from some group
							;leader.

Handle_Value,pointer,retrix

thevar=retrix.thevar
eventval2=retrix.eventval2
get_frame1=retrix.get_frame1

entries = 0
var = thevar
action = eventval2

get_frame=get_frame1
Handle_Free,pointer

END ;================== end of XWMENU main routine =======================


