;***************mirror ellip definition************
function blv_mirror_ellip_hole, baseY, baseX, holeY, holeX, nb_cotte=nb_cotte, prof=hauteur, Color=color


Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_mirror_ellip_hole: error caught: '+!error_state.msg)
   RETURN,0
ENDIF


if n_elements(hauteur) eq 0 then hauteur=0.03
if n_elements(color) eq 0 then color=[100,100,255]
if n_elements(nb_cotte) eq 0 then nb_cotte=16
da=(2*!dpi/nb_cotte)
point=fltarr(nb_cotte*4,3)
a=0
for p=0, nb_cotte-1 do begin
	point[p*2,*]=[baseX*cos(a),baseY*sin(a),-hauteur]
	point[p*2+1,*]=[baseX*cos(a),baseY*sin(a),0]
	a=a+da
endfor
a=0
for p=nb_cotte, (2*nb_cotte)-1 do begin
	point[p*2,*]=[holeX*cos(a),holeY*sin(a),-hauteur]
	point[p*2+1,*]=[holeX*cos(a),holeY*sin(a),0]
	a=a+da
endfor

;******************

mirror=obj_new('idlgrmodel')
; le tour ext
connexExt=intarr(5,nb_cotte)
for p=0, nb_cotte-2 do begin
	connexExt[*,p]=[4,(p*2),(p*2)+1,(p*2)+3,(p*2)+2]
end
connexExt[*,nb_cotte-1]=[4,((nb_cotte-2)*2)+2,((nb_cotte-2)*2)+3,1,0]
connexInt=intarr(5,nb_cotte)
for p=nb_cotte, (2*nb_cotte)-2 do begin
	connexInt[*,p-nb_cotte]=[4,(p*2),(p*2)+1,(p*2)+3,(p*2)+2]
end
connexInt[*,nb_cotte-1]=[4,((2*nb_cotte-2)*2)+2,((2*nb_cotte-2)*2)+3,2*nb_cotte+1,2*nb_cotte]

connexH=intarr(5,nb_cotte)
connexB=intarr(5,nb_cotte)

for p=0, nb_cotte-2 do begin
	connexB[*,p]=[4, p*2,p*2+2*nb_cotte, p*2+2*nb_cotte+2,p*2+2 ]
	connexH[*,p]=[4, p*2+1,p*2+2*nb_cotte+1, p*2+2*nb_cotte+2+1,p*2+3 ]
endfor
connexB[*,nb_cotte-1]=[4,(nb_cotte-2)*2+2, (nb_cotte-2)*2+2*nb_cotte+2, $
							2 *nb_cotte, 0]
connexH[*,nb_cotte-1]=[4,(nb_cotte-2)*2+3, (nb_cotte-2)*2+2*nb_cotte+3, $
							2 *(nb_cotte)+1, 1]

mirror->add, obj_new('idlgrpolygon', point[*,0],point[*,1],point[*,2], $
						 POLYGONS =connexExt, Color=color,/shading )
mirror->add, obj_new('idlgrpolygon', point[*,0],point[*,1],point[*,2], $
						 POLYGONS =connexInt, Color=color,/shading )

mirror->add, obj_new('idlgrpolygon', Point[*,0],Point[*,1],Point[*,2], $
						POLYGONS =connexB, Color=color, /SHADING)
mirror->add, obj_new('idlgrpolygon', Point[*,0],Point[*,1],Point[*,2], $;
						POLYGONS =connexH, Color=color, /SHADING)

return, mirror
end
;**********************************************
