;
; This file includes the preferencies for SHADOWVUI
; It has to be customized to reflect the local paths.
; Please change the STEP 1 and STEP 2 section
;
common xsh_f0, wk_names, wk_data
common shadow, xshgeom, xshoe, shadow_start
common xhelp, docdir 
; forward_function shadow_version
;
; customize shadow initialization (by default we use Bourne shell)
; Please check that the file .shadowrc.sh is correctly customized:
;      1) the directory paths are correctly set,
;      2) the SHADOW_START_FORMAT is set to GFILE (not FORTRAN)
;      3) the SHADOW_ENV_FILE points to /tmp/shadow-env-${USER} (this
;             is necessary to run sources without using make_id)
;
;

ds=SDep(/ds)
!; Extends the path to data directory under shadowvui
!path=!path+SDep(/ps)+XOP_GetEnv('XOP_HOME')+ds+'extensions'+ds+'shadowvui'+ds+'data'
;
;===WINDOWS
;ds=SDep(/ds)
;shadow_start=['set SHADOW_ROOT='+XOP_GetEnv('XOP_HOME')+ds+'extensions'+ds+'shadowvui'+ds+'SHADOW2.3.0','set PATH='+XOP_GetEnv('XOP_HOME')+ds+'extensions'+ds+'shadowvui'+ds+'SHADOW2.3.0'+ds+'bin;c:\windows\command.com','SET SHADOW_ENV_FILE=xsh_env_file.inp']
; ; this is to define SHADOW_ROOT at any time in IDL
; SetEnv,'SHADOW_ROOT='+XOP_GetEnv('XOP_HOME')+ds+'extensions'+ds+'shadowvui'+ds+'SHADOW2.3.0'

;
;===UNIX
;
shadow_root='/scisoft/XRayOptics/shadow-2.3.2'


; by default it uses /bin/sh
shadow_start='. '+shadow_root+'/.shadowrc.sh'
setenv,'SHELL=/bin/sh'

; if using /bin/csh uncomment the next section
; shadow_start='source '+shadow_root+'/.shadowrc'
; setenv,'SHELL=/bin/csh'

; this is to define SHADOW_ROOT at any time in IDL
spawn,'echo '+shadow_root,tmp
setenv,'SHADOW_ROOT='+tmp[0]

;
; in the case you want to use the csh you must comment the above commands
; and uncomment and customize the following two commands:
;
; shadow_start='source /usr/local/shadow/.shadowrc'
; setenv,'SHELL=/bin/csh'
;

;===== Extends the docdir path
;
docdir=[docdir,XOP_GetEnv('XOP_HOME')+ds+'extensions'+ds+'shadowvui'+ds+'doc']

;
; in case you want a define a starting working directory, uncomment and
; customize the next command. Warning: the selected directory must
; exists, otherwise SHADOWVUI will not start.
; This SHADOWVUI_WD variable can be defined in the Unix script or the 
; windows .bat file that start SHADOWVUI, instead of here.
; If defined in both places, the one defined here will be considered.
; The default is the current directory under Unix.
; setenv,'SHADOWVUI_WD=/tmp'
