
filedabax = 'Neutron_SLCS_NeutronNews.dat'
h = dabax_access(filedabax)
wavelengths = MakeArray1(200,0.02,20.0)
dirout='./IMDFF/'

;
; list of scans: 
;
n = spec_access(h)
list = StrArr(n)
FOR i=1,n DO BEGIN
  name = spec_name(h,i,/Index)
  list[i-1]=name
ENDFOR

;
; take only the natiral isotopes
;
igood = StrPos(list,'natural.')
igood = Where(igood EQ 0)
list=list[igood]
n = N_elements(list)
print,list
re = Physical_Constants('re')*1e13 ; in fm
hc = Physical_Constants('hc')


FOR i=0,n-1 DO BEGIN
  name = list(i)
  nameShort  = strmid(name,8)
  fileout=dirout+StrLowCase(nameShort)+'.ff'

  openw,unit,fileout,/Get_Lun
  printf,unit,'; Neutron atomic scattering for '+name+'.'
  printf,unit,'; File created by XOP/NOP make_imdff on: '+SysTime()
  printf,unit,';'
  printf,unit,'; Computed using scattering lengths taken from: '
  printf,unit,';'
  printf,unit,'; Neutron News, Vol. 3, No. 3, 1992, pp.  29-37'
  printf,unit,';'
  printf,unit,'; The data in this file is a fake tabulation of the neutron '
  printf,unit,'; scattering lengths (i.e., scattering lengths in odd units). '
  printf,unit,'; With these data, IMD is able to build the refraction index'
  printf,unit,'; for neutrons using the same formulas and code than for x-rays. '
  printf,unit,';'

  print,' '
  print,'>>>'+name+'<<<'
  igood = dabax_select(h,name,/full_match)
  print,'<>',spec_name(h,igood,/Index)
  z=spec_scan(h,igood,/Index)
  print,'Z: ',z

  b = nsl_calc(filedabax,name,wavelengths,/full_match,/V)

  ; put data with "nice" units in the comments.
  printf,unit,'; Scattering length value : '
  printf,unit,';      Real(b) = '+StrCompress(b[0],/Rem)
  printf,unit,';      Imag(b) = '+StrCompress(b[1],/Rem)
  printf,unit,';'
  printf,unit,'; Col1: The energy of a photon that has the same wavelength than'
  printf,unit,';       the corresponding neutron. It covers the range [0.02,20] A.'
  printf,unit,'; Col2: f1 is the real part of the scattering length divided by the '
  printf,unit,';       classical electron radius. '
  printf,unit,'; Col3: f2 is the imaginary part of the scattering length divided by'
  printf,unit,';       the classical electron radius changed of sign. '
  printf,unit,';'

  printf,unit,';'
  printf,unit,';   E (eV) f1 f2'
  printf,unit,';----------------------'
  ; put data with "odd" units in the body.
  FOR j=0,N_Elements(wavelengths)-1 DO  $
    printf,unit,hc/wavelengths[j],b[0]/re,-1.0D0*b[1]/re,Format='(3G18.8)'
  Free_Lun,unit
  print,'File written to disk: '+fileout
ENDFOR

END


