;;
;; IMD4NOP
;; 
;; This is the procedure used to create the imd4nop.sav files.
;;

pro imd4nop

common imd, $
  imd,imdhome,imd_nkpath,imd_nkpath_ptr, $
  imdsplot,imdsplot_fc,imdsplot_bangpy, $
  imdnplot,imdnplot_fc, $
  imdfplot,imdfplot_fc, $
  imdcplot,imdcplot_fc, $
  imdprint
common imd_str,iv_str,fp_str,cp_str,ambient_str,layer_str,substrate_str
common imd_pars, $
  iv,fp,fp_c,cp,ambient,ambient_nc,ambient_f1f2, $
  layer,layer_nc,layer_f1f2, $
  substrate,substrate_nc,substrate_f1f2, $
  iv0,ambient0,ambient_nc0,ambient_f1f20, $
  layer0,layer_nc0,layer_f1f20, $
  substrate0,substrate_nc0,substrate_f1f20, $
  seed
common imd_vars, $
  theta,lambda,idvar,fitpar,chi_2,nc,z,sigma,sigma_from_psd,interface, $
  f,q,ares,pres, $
  r,rs,rp,prs,prp,psi,delta,t,ts,tp,pts,ptp,a,as,ap, $
  user1,user2,user3
common imd_fpars,pt_spacing,ambient_depth,substrate_depth
common imd_fvars,depth,int,ints,intp
common imd_nsvars,q_range, $
  theta_in,theta_out,phi, $
  psd_xi_perp,sigma_d, $
  psd_sigma_r,psd_xi_par,psd_h, $
  psd_omega,psd_nu,psd_n, $
  didomega_dwba,didomega_baa,didomega_bas,didomega_bap
common imd_m,x_m,y_m,sigy_m
common imd_f1f2,atwt_list,element_list, $
  f1f2_compound,f1f2_density,f1f2_number,f1f2_element, $
  f1f2_lambda,f1f2_n,f1f2_k,f1f2_autoplot
common imd_widget, $
  mainw,ambw,layw,mlw,subw,ivw,open_mw,fitw,cpw,fpw, $
  pmfcw,ppsdw,psavw, $
  pfldw,nkvieww,pnkpathw,printw,f1f2w

;; disable decomposed colors for true-color displays:
device,decomposed=0

;; check IDL version and select IMD save file:
case 1 of
    float(strmid(!version.release,0,3)) lt 5.1: begin
        print,' '
        message,'This version of IMD will only run under IDL V5.1 or higher.'
    end
    float(strmid(!version.release,0,3)) eq 5.1: imdfile='imd_51'
    float(strmid(!version.release,0,3)) eq 5.2: imdfile='imd_52'
    else: imdfile='imd_53'
endcase

;; load IMD:
print,' ' 
print,format="($,'Loading IMD...')"
;---------------------------------------------------------
; srio insert this file explicitely
;@imdsiteconfig
;
;;-IMDSITECONFIG.PRO-----------------------------------------------------
;;
;; SITE/PLATFORM-DEPENDENT SETTINGS 
;;
;; This file contains the parameters you will need to set to get IMD
;; to work on your computer.
;;
;;
;; The most important thing to set here is the installation directory.
;; If you don't set this correctly, IMD will not work at all.
;;
;; If you will use IMD with a licensed copy of IDL, then the default
;; IMD installation directory is inside of the user_contrib directory
;; in the main IDL directory (i.e., inside the directory specified by
;; the !DIR system variable.)  If you did not install IMD in this
;; location, then you MUST set the value of the 'imdhome' variable
;; below to reflect the actual installation directory.
;;
;; If you will use IMD as a XOP extension, then IMD must be installed
;; in the extensions subdirectory of the xop directory.
;; 
;;
;; You can also add optical constants directories to the IMD optical
;; constants search path, by setting the string array variable
;; imd_nkpath accordingly.
;;
;; 
;; You might also need to set (a) the desired widget font for your
;; platform, and (b) the special characters necessary for widgets to
;; display the angstrom symbol and the greek mu character.  If you're
;; not sure about these special characters, just use an 'A' for the
;; angstrom symbol and a 'u' for the mu symbol.
;; 
;;
;; Finally, the sp_max_array_size and ns_max_array_size parameters can
;; be adjusted according to the memory limitations of your computer.
;; That is, you might be able to avoid the 'Not enough memory to make
;; array' error message when trying to calculate large arrays, under
;; certain conditions:
;;
;; For specular optical functions, the largest arrays that IMD will
;; attempt to create to perform the actual computation are
;; proportional to (number of wavelengths) x (number of angles) x
;; (number of layers).  So if you get the 'Not enough memory' message
;; when computing specular optical functions as a function of multiple
;; angles or wavelengths, you can try DECREASING the sp_max_array_size
;; parameter.
;;
;; For non-specular reflected intensities, the 'Not enough memory'
;; error is most likely to occur when using the Omega/Nu/N PSD model,
;; if you have defined large Nu values or Omega values equal to zero.
;; In this case, IMD will need to create arrays that are proportional
;; to (number of angles) x (number of layers) x (number of layers),
;; where (number of angles) is equal to the number of incidence angles
;; for Rocking and Offset scans, and the number of scattering angles
;; for Detector scans. So if you get the 'Not enough memory' message
;; when computing non-specular reflected intensities as a function of
;; multiple angles using the Omega/Nu/N PSD model under the
;; circumstances just mentioned, you can try DECREASING the
;; ns_max_array_size parameter.
;; 
;; Also, these parameters can be decreased if you find that your
;; computer is using a lot of virtual memory (i.e., spending a lot of
;; time swapping to disk).  Note, however, that decreasing
;; sp_max_array_size or ns_max_array_size too low will result in a
;; large speed penalty.
;;
;;
;;------------------------------------------------------------------------
;; 
;; NOTE: Each line of this file must use valid IDL syntax. Lines
;; cannot be continued using the $ symbol.  Be careful making changes:
;; If you mess it up, IMD won't run.
;;
;;------------------------------------------------------------------------
;;
;; UNIX PLATFORMS:
;;
;; 

;; IMD Installation directory:
;;
if (!version.os_family eq 'unix') then imdhome=!dir+'/user_contrib/imd/' 
;;
;; installation directory for imd4xop
;;srio if (!version.os_family eq 'unix') and (getenv('XOP_HOME') ne '') then imdhome=getenv('XOP_HOME')+'/extensions/imd/'
if (!version.os_family eq 'unix') and (getenv('XOP_HOME') ne '') then imdhome=getenv('XOP_HOME')+'/extensions/nop/imd/'
Message,/Info,'imdhome is: '+imdhome
;;
;; IMD optical constants search paths:
if (!version.os_family eq 'unix') then imd_nkpath=[imdhome+'nk.dir/','./'] 
;;
;; you shouldn't have to change this:
if (!version.os_family eq 'unix') then imdf1f2path=imdhome+'f1f2.dir/' 
;;
;; default widget fonts, special characters, and max array size:
;;
;; these work for me on HP-UX:
if (!version.os eq "hp-ux") then font_w='' 
if (!version.os eq "hp-ux") then angstrom_w=string(208B) 
if (!version.os eq "hp-ux") then mu_w=string(243B) 
if (!version.os eq "hp-ux") then sp_max_array_size=500000L
if (!version.os eq "hp-ux") then ns_max_array_size=7000000L

;; these work for me on Sun OS
if (!version.os eq "sunos") then font_w='helvR12' 
if (!version.os eq "sunos") then angstrom_w=string(197B) 
if (!version.os eq "sunos") then mu_w=string(181B) 
if (!version.os eq "sunos") then sp_max_array_size=500000L
if (!version.os eq "sunos") then ns_max_array_size=7000000L

;; these are untested:
if (!version.os eq "A/UX") then font_w='' 
if (!version.os eq "A/UX") then angstrom_w='A'
if (!version.os eq "A/UX") then mu_w='u'
if (!version.os eq "A/UX") then sp_max_array_size=500000L
if (!version.os eq "A/UX") then ns_max_array_size=7000000L

;; these are untested:
if (!version.os eq "AIX") then font_w='' 
if (!version.os eq "AIX") then angstrom_w='A'
if (!version.os eq "AIX") then mu_w='u'
if (!version.os eq "AIX") then sp_max_array_size=500000L
if (!version.os eq "AIX") then ns_max_array_size=7000000L

;; these are untested:
if (!version.os eq "DG/UX") then font_w='' 
if (!version.os eq "DG/UX") then angstrom_w='A'
if (!version.os eq "DG/UX") then mu_w='u'
if (!version.os eq "DG/UX") then sp_max_array_size=500000L
if (!version.os eq "DG/UX") then ns_max_array_size=7000000L

;; these are untested:
if (!version.os eq "IRIX") then font_w='' 
if (!version.os eq "IRIX") then angstrom_w='A'
if (!version.os eq "IRIX") then mu_w='u'
if (!version.os eq "IRIX") then sp_max_array_size=500000L
if (!version.os eq "IRIX") then ns_max_array_size=7000000L

;; these are untested:
if (!version.os eq "linux") then font_w='' 
if (!version.os eq "linux") then angstrom_w='A'
if (!version.os eq "linux") then mu_w='u'
if (!version.os eq "linux") then sp_max_array_size=500000L
if (!version.os eq "linux") then ns_max_array_size=7000000L

;; these are untested:
if (!version.os eq "OSF") then font_w='' 
if (!version.os eq "OSF") then angstrom_w='A'
if (!version.os eq "OSF") then mu_w='u'
if (!version.os eq "OSF") then sp_max_array_size=500000L
if (!version.os eq "OSF") then ns_max_array_size=7000000L

;; these are untested:
if (!version.os eq "RISC/os") then font_w='' 
if (!version.os eq "RISC/os") then angstrom_w='A'
if (!version.os eq "RISC/os") then mu_w='u'
if (!version.os eq "RISC/os") then sp_max_array_size=500000L
if (!version.os eq "RISC/os") then ns_max_array_size=7000000L

;; add your unix platform here 
;; 
if (!version.os eq "YOUR UNIX OS") then font_w='' 
if (!version.os eq "YOUR UNIX OS") then angstrom_w='A'
if (!version.os eq "YOUR UNIX OS") then mu_w='u'
if (!version.os eq "YOUR UNIX OS") then sp_max_array_size=500000L
if (!version.os eq "YOUR UNIX OS") then ns_max_array_size=7000000L

;;------------------------------------------------------------------------
;;
;; WINDOWS:
;;

;; 
;; IMD Installation directory:
;;
if (!version.os eq 'Win32') then imdhome=!dir+'\user_contrib\imd\' 
;;
;; installation directory for imd4xopi
;;srio if (!version.os eq 'Win32') and (getenv('XOP_HOME') ne '') then imdhome=getenv('XOP_HOME')+'extensions\imd\'
if (!version.os eq 'Win32') and (getenv('XOP_HOME') ne '') then imdhome=getenv('XOP_HOME')+'\extensions\nop\imd\'
itmp=Dialog_Message(/Info,'imdhome is: '+imdhome)
;; 
;; IMD optical constants search paths:
;;
if (!version.os eq 'Win32') then imd_nkpath=[imdhome+'nk.dir\',''] 
;;
;; you shouldn't have to change these:
;;
if (!version.os eq 'Win32') then imdf1f2path=imdhome+'f1f2.dir\' 
;;
;; default widget fonts, special characters, and max array size:
;;
if (!version.os eq 'Win32') then font_w='' 
if (!version.os eq 'Win32') then angstrom_w=string(197B)
if (!version.os eq 'Win32') then mu_w=string(181B)
if (!version.os eq 'Win32') then sp_max_array_size=200000L
if (!version.os eq 'Win32') then ns_max_array_size=2000000L

;;------------------------------------------------------------------------
;;
;; MACINTOSH:
;;

;;
;; IMD Installation directory:
;;
if (!version.os eq 'MacOS') then imdhome=!dir+'user_contrib:imd:' 
;;
;; installation directory for imd4xop
;;srio if (!version.os eq 'MacOS') and (getenv('XOP_HOME') ne '') then imdhome=getenv('XOP_HOME')+'extensions:imd:'
if (!version.os eq 'MacOS') and (getenv('XOP_HOME') ne '') then imdhome=getenv('XOP_HOME')+'extensions:nop:imd:'
;; 
;; IMD optical constants search paths:
;;
if (!version.os eq 'MacOS') then imd_nkpath=[imdhome+'nk.dir:',''] 
;;
;; you shouldn't have to change these:
;;
if (!version.os eq 'MacOS') then imdf1f2path=imdhome+'f1f2.dir:' 
;;
;; default widget fonts, special characters, and max array size:
;;
if (!version.os eq 'MacOS') then font_w='' 
if (!version.os eq 'MacOS') then angstrom_w=string(129B) 
if (!version.os eq 'MacOS') then mu_w='u' 
if (!version.os eq 'MacOS') then sp_max_array_size=200000L
if (!version.os eq 'MacOS') then ns_max_array_size=2000000L

;;------------------------------------------------------------------------
;;
;; VMS:
;;

;;
;; I have no clue about the VMS file system:
;;
if (!version.os eq 'vms') then imdhome=!dir+':[user_contrib.imd]' 
;; 
;; installation directory for imd4xop
if (!version.os eq 'vms') and (getenv('XOP_HOME') ne '') then imdhome=getenv('XOP_HOME')+':[extensions.imd]'
;;
;; IMD optical constants search paths:
;;
if (!version.os eq 'vms') then imd_nkpath=[imdhome+'nk.dir','[]'] 
;;
if (!version.os eq 'vms') then imdf1f2path=imdhome+'f1f2.dir' 
;;
;; default widget fonts, special characters, and max array size:
;;
if (!version.os eq 'vms') then font_w='' 
if (!version.os eq 'vms') then angstrom_w='A' 
if (!version.os eq 'vms') then mu_w='u' 
if (!version.os eq 'vms') then sp_max_array_size=200000L
if (!version.os eq 'vms') then ns_max_array_size=2000000L
;---------------------------------------------------------

case !version.os of
    'Win32': sep='\'
    'Mac': sep=':'
    else: sep='/'
endcase

; restore,getenv('XOP_HOME')+sep+'extensions'+sep+'imd'+sep+imdfile
restore,getenv('XOP_HOME')+sep+'extensions'+sep+'nop'+sep+'imd'+sep+imdfile
print,'done.'
print,' '

;; print message, and start imd:
imd_version='4.1.1, August 2000'

print,' '
print,'-------------------------------IMD-------------------------------'
print,' '
print,'                      Version '+imd_version
print,' '
print,'                           David L. Windt'
print,'                      windt@astro.columbia.edu'
print,'            <http://cletus.phys.columbia.edu/windt/idl>'
print,' '
print,'                Copyright (c) 1997-2000, David L. Windt'
print,'                         All rights reserved'
print,' '
print,'-----------------------------------------------------------------'
print,' '

ds = SDep(/ds)
rfile = Xop_GetEnv('XOP_HOME')+ds+'extensions'+ds+'nop'+ds+'doc'+ds+'README_IMD.TXT'
xdisplayfilenative,rfile

imd

end
