;+
; 
;      ============================= XAID  ======================
;
; XAID is a collection of programs for XAFS data analysis 
;
;   The documentation for XAID (the XOP's XAFS toolbox) can be found at:
;   http://www.esrf.fr/computing/scientific/xop/xaid/doc/
;
;		
;
; REFERENCE: "XAID: A package for XAFS data analysis based on IDL"
;       by Manuel Sanchez del Rio. Proceedings of the 9th International
;	Conference on X-ray Absorption Fine Structure
;	J. Phys. IV, Coll C2-209-210, 1997. 
; 
; The XAID main window allows you to start the different applications 
; included in XAID:
;
;    For standard EXAFS Data analysis:
;	EXAFS signal Extraction (XAID_MU2CHI)
;	Fourier Filtering (XAID_FF)
;	Dilute samples (EXODUS)
;
;    For Dispersive EXAFS Data analysis
;	Calibration & Analisys (DELIA)
;	Calibration (XAID_CALIB)': XAID_CALIB,Group=event.top
;
;    DABAX tools:
;	f1 and f2 values
;	McKale phases
;	EXAFS spectra database
;	XANES spectra database
;
; Note: In addition to the widget application mentioned before, 
; XAID contains an IDL library of functions that can be used 
; on machines licensed to IDL (XOP's developer mode). This library
; permits to customize XAFS applications. 
;
; Some EXAFS procedures and functions included in the XAID library:
;	bftr		Calculate Back Fourier Transform (Standard procedure)
;	bftrset		Driver for bftr and fastbftr
;	e2k		change the energy scale to wavenumber
;	fastbftr	calculate the back F.T. (fast FT algorithm)
;	fastftr		calculates the F.T (fast F.T. algorithm)
;	ftr		calculates the  Fourier Transform (Standard procedure)
;	ftrset		drivet for ftr and fastftr
;	gete0		to get the edge
;	getjump		to get the jump value
;	k2e		transform the k scale to energy
;	polspl		multipolynomial spline
;	polspl_evaluate	multipolynomial spline evaluation
;	postedge	a driver for polspl
;	window_ftr	windows for F.T.
;	writeset	writes a set into a file
;
; LAST MODIFICATION: msr/msr/03-08-27
;
;-
;
;============================================================================
;
PRO Xaid_Event, event

Catch, error_status
IF error_status NE 0 THEN BEGIN
  Message,/Info,'error caught: '+!err_string
  itmp = Dialog_Message(/Error,Dialog_Parent=event.top,$
    'XAID_EVENT: '+'error caught: '+!error_state.msg)
  Catch, /Cancel
  GoTo,out
ENDIF

;
; register the events
;
stateid = Widget_Info(event.handler,/Child)
Widget_control, stateid,  Get_uValue=state,/No_copy

Widget_Control,event.id,GET_UValue=uval


CASE uval OF
  'Quit': BEGIN
	Widget_Control,event.top,/Destroy
	END
  'ABOUT': XAID_Help,Group=event.top
  'HELP': BEGIN
	tmp=''
	Widget_Control,event.id,Get_Value=tmp
	Xhelp,StrLowCase(tmp[0]),group=event.top
	END
  'MANUAL': BEGIN
	Widget_Control,/HourGlass
	ds = SDep(/ds)
        IF sdep() EQ 'WINDOWS' THEN BEGIN
          spawn,'start '+xop_getenv('XOP_HOME')+ds+'extensions'+ds+'xaid'+ds+'doc'+ds+'xaid.pdf'
        ENDIF ELSE BEGIN
          spawn,'acroread '+xop_getenv('XOP_HOME')+ds+'extensions'+ds+'xaid'+ds+'doc'+ds+'xaid.pdf &'
        ENDELSE
	END
  'Start...': BEGIN
	; help,event.value
	CASE event.value OF
	  'Quit':Widget_Control,event.top,/Destroy
	  'Extraction (XAID_MU2CHI)': BEGIN
		set = state.set
		IF N_ElementS(set) GT 1 THEN $
		XAID_MU2CHI,set,No_Block=state.no_block ELSE $
			XAID_MU2CHI,No_Block=state.no_block
		END
	  'Fourier Filtering (XAID_FF)': BEGIN
		set = state.set
		IF N_Elements(set) GT 1 THEN $
		XAID_FF, set, No_Block=state.no_block ELSE $
			XAID_FF, No_Block=state.no_block
		END
	  'Dilute Samples (EXODUS)': EXODUS,No_Block=state.no_block,/Xafs
	  'Calibration & Analisys (DELIA)': DELIA,No_Block=state.no_block
	  'Calibration (XAID_CALIB)': XAID_CALIB,No_Block=state.no_block
	  'f1 and f2 values': Xf1f2
	  'McKale phases': BEGIN
		file = 'XAFS_McKale.dat'
		IF StrCompress(Dabax_PathF(file,Group=event.top)) EQ '' THEN $
		  BEGIN
		  itmp = Dialog_Message(/Info, Dialog_Parent=event.top,$
		     ['The DABAX file containing the McKale phases',$
			'('+file+') cannot be found.','',$
		      'Please install it before using this application.'])
		ENDIF ELSE XMcKale
		END
	  'EXAFS spectra database': BEGIN
	        Widget_Control,/Hourglass
	        file = 'XAFS_DATA_EXAFS_CHI.dat'
		IF StrCompress(Dabax_PathF(file,Group=event.top)) EQ '' THEN $
		  BEGIN
		  itmp = Dialog_Message(/Info, Dialog_Parent=event.top,$
		     ['The DABAX file containing the EXAFS spectra',$
			'('+file+') cannot be found.','',$
		      'Please install it before using this application.'])
		ENDIF ELSE BEGIN
	          h=dabax_access(file(0))
	          xplot,spec=h,wtitle=file(0),xtitle='-1',ytitle='-1', $
			title='#S',No_Block=state.no_block
		ENDELSE
		END
	  'XANES spectra database': BEGIN
	        Widget_Control,/Hourglass
	        file = 'XAFS_DATA_XANES.dat'
		IF StrCompress(Dabax_PathF(file,Group=event.top)) EQ '' THEN $
		  BEGIN
		  itmp = Dialog_Message(/Info, Dialog_Parent=event.top,$
		     ['The DABAX file containing the XANES spectra',$
			'('+file+') cannot be found.','',$
		      'Please install it before using this application.'])
		ENDIF ELSE BEGIN
	          h=dabax_access(file(0))
	          xplot,spec=h,wtitle=file(0),xtitle='-1',ytitle='-1', $
			title='#S',No_Block=state.no_block
		ENDELSE
		END
	  else:
	ENDCASE
	END
  'XPLOT': BEGIN
	Widget_Control,/HourGlass
	set = state.set
	IF N_Elements(set) GT 1 THEN $
	  Xplot,set,Group=event.top, No_Block=state.no_block ELSE $
	  Xplot, No_Block=state.no_block  ; ,Group=event.top 
	END
  else: BEGIN
	Widget_Control,/HourGlass
	command = uval+',Group=event.top'
	itmp = Execute(command)
	END
ENDCASE

out:
If Type(stateid) EQ 3 THEN $
  IF Widget_Info(stateid,/Valid_Id) EQ 1 THEN $
  Widget_Control, stateid, Set_UValue=state,/No_Copy

END ; XPeakFit_event
;
;============================================================================
;


PRO Xaid, set, Group = group, No_Block = no_Block

Catch, error_status
IF error_status NE 0 THEN BEGIN
  Message,/Info,'error caught: '+!err_string
  itmp = Dialog_Message(/Error,Dialog_Parent=group,$
    'XAID: '+'error caught: '+!error_state.msg)
  Catch, /Cancel
  RETURN
ENDIF

IF N_Elements(no_block) EQ 0 THEN no_block=0
IF N_Elements(set) EQ 0 THEN set=0

; add directory $XOP_HOME/extensions/xaid/path to DABAX_PATH 
; (if not present)
Dabax_Path_Add,'xaid'

Xop_SetEnv,'XOP_EXTENSION_XAID=1'

wTop = Widget_Base(Title='XAID',MBAR=wMenu)
wtmp = Widget_Base(wTop) ; to store state

;
; define menu bar
;
wtmp0 = Widget_Button(wMenu, Value='File', /MENU)
 wtmp1 = Widget_Button(wtmp0, Value='Quit', UValue='Quit',/Separator)

;wExafsToolsMenu = Widget_Button(wMenu,Value='EXAFS',/Menu)
;  wtmp = Widget_Button(wExafsToolsMenu,Value='Extraction (XAID_MU2CHI)',$
;	UValue='XAID_MU2CHI')
;  wtmp = Widget_Button(wExafsToolsMenu,Value='Fourier Filtering (XAID_FF)',$
;	UValue='XAID_FF')
;  wDExafsToolsMenu = Widget_Button(wExafsToolsMenu,Value='Dispersive EXAFS',$
;	/Menu)
;    wtmp = Widget_Button(wDExafsToolsMenu,Value=$
;	'Calibration & Analisys (DELIA)',UValue='DELIA')
;    wtmp = Widget_Button(wDExafsToolsMenu,Value='Calibration (XAID_CALIB)',$
;	UValue='XAID_CALIB')
;
;wDabaxMenu = Widget_Button(wMenu,Value='DABAX',/Menu)
;  wtmp = Widget_Button(wDabaxMenu,Value='f1 and f2 values',$
;	UValue='XF1F2')
;  wtmp = Widget_Button(wDabaxMenu,Value='McKale phases',$
;	UValue='XMCKALE')
;  wtmp = Widget_Button(wDabaxMenu,Value='EXAFS spectra database',$
;	/Separator,UValue='DABAX_EXAFS')
;  wtmp = Widget_Button(wDabaxMenu,Value='XANES spectra database',$
;	UValue='DABAX_XANES')

wToolsMenu = Widget_Button(wMenu,Value='Tools',/Menu)
  wtmp = Widget_Button(wToolsMenu,Value='XOP Main window',$
	UValue='XOP')
  wtmp = Widget_Button(wToolsMenu,Value='Plotting tool...',$
	UValue='XPLOT')
  wtmp = Widget_Button(wToolsMenu,Value='Display file...',$
	UValue='XOP_FILE_DISPLAY')

wHelpMenu = Widget_Button(wMenu,Value='Help',/Help)
  wtmp = Widget_Button(wHelpMenu, Value='About XAID',UValue='ABOUT')
  wtmp = Widget_Button(wHelpMenu, Value='XAID',UValue='HELP')
  wtmp = Widget_Button(wHelpMenu, Value='XAID Manual',UValue='MANUAL')
;

desc = [ '0\Quit', $
	 '1\Start...' , $
         '1\EXAFS' , $
           '0\Extraction (XAID_MU2CHI)' , $
           '0\Fourier Filtering (XAID_FF)' , $
           '2\Dilute Samples (EXODUS)' , $
         '1\Dispersive EXAFS' , $
           '0\Calibration & Analisys (DELIA)' , $
           '2\Calibration (XAID_CALIB)' , $
         '1\DABAX' , $
           '0\f1 and f2 values' , $
           '0\McKale phases' , $
           '0\EXAFS spectra database' , $
           '2\XANES spectra database']

wBase = Widget_Base(wTop,/Column)
wtmp = CW_PDMenu(wBase,desc,/Return_Name,UValue='Start...')


if sdep() EQ 'WINDOWS' then $
font = 'VERDANA*BOLD*ITALIC*24' else $
font = '-adobe-helvetica-bold-o-normal--18-180-75-75-p-104-iso8859-1'

;junk = WIDGET_LABEL( wBase, FONT=font, VALUE=' XAID ')
junk = WIDGET_LABEL( wBase, FONT=font, $
  VALUE="XAID: XOP's XAFS toolbox")


Widget_Control,wTop,/Realize 

wids = { junk:0}
state= { wids:wids, set:set, no_block:no_block}

Widget_control,Widget_Info(wTop,/CHILD),set_uValue=state,/No_copy

XManager, 'XAID', wTop, GROUP_LEADER=group,No_Block=no_block

END ; XpeakFit
